/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.extensibility.modules;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.Duration;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.web.extensibility.modules.WebTelemetryModule;
import com.microsoft.applicationinsights.web.internal.ApplicationInsightsHttpResponseWrapper;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class WebRequestTrackingTelemetryModule
implements WebTelemetryModule,
TelemetryModule {
    private TelemetryClient telemetryClient;
    private boolean isInitialized = false;

    @Override
    public void onBeginRequest(ServletRequest req, ServletResponse res) {
        if (!this.isInitialized) {
            return;
        }
        try {
            RequestTelemetryContext context = ThreadContext.getRequestTelemetryContext();
            RequestTelemetry telemetry = context.getHttpRequestTelemetry();
            HttpServletRequest request = (HttpServletRequest)req;
            String method = request.getMethod();
            String rURI = request.getRequestURI();
            String scheme = request.getScheme();
            String host = request.getHeader("Host");
            String query = request.getQueryString();
            String userAgent = request.getHeader("User-Agent");
            telemetry.setHttpMethod(method);
            if (!Strings.isNullOrEmpty((String)query)) {
                telemetry.setUrl(String.format("%s://%s%s?%s", scheme, host, rURI, query));
            } else {
                telemetry.setUrl(String.format("%s://%s%s", scheme, host, rURI));
            }
            String rUriWithoutSessionId = this.removeSessionIdFromUri(rURI);
            telemetry.setName(String.format("%s %s", method, rUriWithoutSessionId));
            telemetry.getContext().getUser().setUserAgent(userAgent);
            telemetry.setTimestamp(new Date(context.getRequestStartTimeTicks()));
        }
        catch (Exception e) {
            String moduleClassName = this.getClass().getSimpleName();
            InternalLogger.INSTANCE.error("Telemetry module " + moduleClassName + " onBeginRequest failed with exception: %s", new Object[]{e.getMessage()});
        }
    }

    @Override
    public void onEndRequest(ServletRequest req, ServletResponse res) {
        if (!this.isInitialized) {
            return;
        }
        try {
            RequestTelemetryContext context = ThreadContext.getRequestTelemetryContext();
            RequestTelemetry telemetry = context.getHttpRequestTelemetry();
            long endTime = new Date().getTime();
            ApplicationInsightsHttpResponseWrapper response = (ApplicationInsightsHttpResponseWrapper)res;
            if (response != null) {
                telemetry.setSuccess(response.getStatus() < 400 || response.getStatus() == 401);
                telemetry.setResponseCode(Integer.toString(response.getStatus()));
            } else {
                InternalLogger.INSTANCE.error("Failed to get response status for request ID: %s", new Object[]{telemetry.getId()});
            }
            telemetry.setDuration(new Duration(endTime - context.getRequestStartTimeTicks()));
            this.telemetryClient.track((Telemetry)telemetry);
        }
        catch (Exception e) {
            String moduleClassName = this.getClass().getSimpleName();
            InternalLogger.INSTANCE.error("Telemetry module " + moduleClassName + " onEndRequest failed with exception: %s", new Object[]{e.getMessage()});
        }
    }

    public void initialize(TelemetryConfiguration configuration) {
        try {
            this.telemetryClient = new TelemetryClient(configuration);
            this.isInitialized = true;
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to initialize telemetry module " + this.getClass().getSimpleName() + ". Exception: %s.", new Object[]{e.getMessage()});
        }
    }

    private String removeSessionIdFromUri(String uri) {
        int separatorIndex = uri.indexOf(59);
        if (separatorIndex == -1) {
            return uri;
        }
        String urlWithoutSessionId = uri.substring(0, separatorIndex);
        return urlWithoutSessionId;
    }
}

