/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal;

import com.google.common.base.Strings;
import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.agent.internal.coresync.impl.AgentTLS;
import com.microsoft.applicationinsights.internal.agent.AgentConnector;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.ThreadLocalCleaner;
import com.microsoft.applicationinsights.web.internal.ApplicationInsightsHttpResponseWrapper;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import com.microsoft.applicationinsights.web.internal.WebModulesContainer;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.LinkedList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WebRequestTrackingFilter
implements Filter {
    private static final String FILTER_NAME = "ApplicationInsightsWebFilter";
    private static final String WEB_INF_FOLDER = "WEB-INF/";
    private WebModulesContainer webModulesContainer;
    private boolean isInitialized = false;
    private TelemetryClient telemetryClient;
    private String key;
    private boolean agentIsUp = false;
    private final LinkedList<ThreadLocalCleaner> cleaners = new LinkedList();

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        ApplicationInsightsHttpResponseWrapper response = new ApplicationInsightsHttpResponseWrapper((HttpServletResponse)res);
        this.setKeyOnTLS(this.key);
        boolean isRequestProcessedSuccessfully = this.invokeSafeOnBeginRequest(req, (ServletResponse)response);
        try {
            chain.doFilter(req, (ServletResponse)response);
            this.invokeSafeOnEndRequest(req, (ServletResponse)response, isRequestProcessedSuccessfully);
        }
        catch (ServletException se) {
            this.onException((Exception)((Object)se), req, (ServletResponse)response, isRequestProcessedSuccessfully);
            throw se;
        }
        catch (IOException ioe) {
            this.onException(ioe, req, (ServletResponse)response, isRequestProcessedSuccessfully);
            throw ioe;
        }
        catch (RuntimeException re) {
            this.onException(re, req, (ServletResponse)response, isRequestProcessedSuccessfully);
            throw re;
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        try {
            ThreadContext.remove();
            this.setKeyOnTLS(null);
            for (ThreadLocalCleaner cleaner : this.cleaners) {
                cleaner.clean();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void onException(Exception e, ServletRequest req, ServletResponse res, boolean isRequestProcessedSuccessfully) {
        try {
            InternalLogger.INSTANCE.trace("Unhandled application exception: %s", new Object[]{e.getMessage()});
            if (this.telemetryClient != null) {
                this.telemetryClient.trackException(e);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.invokeSafeOnEndRequest(req, res, isRequestProcessedSuccessfully);
    }

    public void init(FilterConfig config) {
        try {
            this.initialize(config);
            TelemetryConfiguration configuration = TelemetryConfiguration.getActive();
            if (configuration == null) {
                InternalLogger.INSTANCE.error("Java SDK configuration cannot be null. Web request tracking filter will be disabled.", new Object[0]);
                return;
            }
            this.telemetryClient = new TelemetryClient(configuration);
            this.webModulesContainer = new WebModulesContainer(configuration);
            this.isInitialized = true;
        }
        catch (Exception e) {
            String filterName = this.getClass().getSimpleName();
            InternalLogger.INSTANCE.info("Application Insights filter %s has been failed to initialized.\nWeb request tracking filter will be disabled. Exception: %s", new Object[]{filterName, e.getMessage()});
        }
    }

    public void destroy() {
    }

    private boolean invokeSafeOnBeginRequest(ServletRequest req, ServletResponse res) {
        if (!this.isInitialized) {
            return false;
        }
        boolean success = true;
        try {
            RequestTelemetryContext context = new RequestTelemetryContext(new Date().getTime(), (HttpServletRequest)req);
            ThreadContext.setRequestTelemetryContext(context);
            this.webModulesContainer.invokeOnBeginRequest(req, res);
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to invoke OnBeginRequest on telemetry modules with the following exception: %s", new Object[]{e.getMessage()});
            success = false;
        }
        return success;
    }

    private void invokeSafeOnEndRequest(ServletRequest req, ServletResponse res, boolean inProgress) {
        try {
            if (this.isInitialized && inProgress) {
                this.webModulesContainer.invokeOnEndRequest(req, res);
            }
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.error("Failed to invoke OnEndRequest on telemetry modules with the following exception: %s", new Object[]{e.getMessage()});
        }
    }

    private void setKeyOnTLS(String key) {
        block3: {
            if (this.agentIsUp) {
                try {
                    AgentTLS.setTLSKey((String)key);
                }
                catch (Throwable e) {
                    if (!(e instanceof ClassNotFoundException) && !(e instanceof NoClassDefFoundError)) break block3;
                    this.agentIsUp = false;
                    InternalLogger.INSTANCE.error("setKeyOnTLS: Failed to find AgentTLS: '%s'", new Object[]{e.getMessage()});
                }
            }
        }
    }

    private synchronized void initialize(FilterConfig filterConfig) {
        try {
            try {
                AgentConnector agentConnector = AgentConnector.INSTANCE;
            }
            catch (Throwable t) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.INFO, "Agent was not found. Skipping the agent registration", new Object[0]);
                return;
            }
            ServletContext context = filterConfig.getServletContext();
            String name = this.getName(context);
            String key = this.registerWebApp(name);
            this.setKey(key);
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.INFO, "Successfully registered the filter '%s'", new Object[]{FILTER_NAME});
        }
        catch (Throwable t) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Failed to register '%s', exception: '%s'", new Object[]{FILTER_NAME, t.getMessage()});
        }
    }

    private String registerWebApp(String name) {
        String key = null;
        if (!Strings.isNullOrEmpty((String)name)) {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.INFO, "Registering WebApp with name '%s'", new Object[]{name});
            AgentConnector.RegistrationResult result = AgentConnector.INSTANCE.register(this.getClass().getClassLoader(), name);
            if (result == null) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Did not get a result when registered '%s'. No way to have RDD telemetries for this WebApp", new Object[]{name});
            }
            if (Strings.isNullOrEmpty((String)(key = result.getKey()))) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Key for '%s' key is null'. No way to have RDD telemetries for this WebApp", new Object[]{name});
            } else {
                if (result.getCleaner() != null) {
                    this.cleaners.add(result.getCleaner());
                }
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.INFO, "Registered WebApp '%s' key='%s'", new Object[]{name, key});
            }
        } else {
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "WebApp name is not found, unable to register WebApp", new Object[0]);
        }
        return key;
    }

    private String getName(ServletContext context) {
        String name;
        block4: {
            name = null;
            try {
                String contextPath = context.getContextPath();
                if (Strings.isNullOrEmpty((String)contextPath)) {
                    URL[] jarPaths;
                    for (URL url : jarPaths = ((URLClassLoader)this.getClass().getClassLoader()).getURLs()) {
                        String[] parts;
                        String urlPath = url.getPath();
                        int index = urlPath.lastIndexOf(WEB_INF_FOLDER);
                        if (index == -1 || (parts = (urlPath = urlPath.substring(0, index)).split("/")).length <= 0) continue;
                        name = parts[parts.length - 1];
                        break block4;
                    }
                    break block4;
                }
                name = contextPath.substring(1);
            }
            catch (Throwable t) {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "Exception while fetching WebApp name: '%s'", new Object[]{t.getMessage()});
            }
        }
        return name;
    }

    private void setKey(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            this.agentIsUp = false;
            this.key = key;
            return;
        }
        try {
            AgentTLS.getTLSKey();
            this.agentIsUp = true;
            this.key = key;
        }
        catch (Throwable throwable) {
            this.agentIsUp = false;
            this.key = null;
            InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "setKey: Failed to find AgentTLS", new Object[0]);
        }
    }
}

