/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.extensibility.modules;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.extensibility.context.SessionContext;
import com.microsoft.applicationinsights.web.extensibility.modules.WebTelemetryModule;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import com.microsoft.applicationinsights.web.internal.cookies.Cookie;
import com.microsoft.applicationinsights.web.internal.cookies.SessionCookie;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class WebSessionTrackingTelemetryModule
implements WebTelemetryModule,
TelemetryModule {
    public void initialize(TelemetryConfiguration configuration) {
    }

    @Override
    public void onBeginRequest(ServletRequest req, ServletResponse res) {
        HttpServletRequest request = (HttpServletRequest)req;
        RequestTelemetryContext context = ThreadContext.getRequestTelemetryContext();
        SessionCookie sessionCookie = Cookie.getCookie(SessionCookie.class, request, "ai_session");
        if (sessionCookie == null) {
            return;
        }
        context.setSessionCookie(sessionCookie);
        String sessionId = sessionCookie.getSessionId();
        this.getTelemetrySessionContext(context).setId(sessionId);
    }

    @Override
    public void onEndRequest(ServletRequest req, ServletResponse res) {
    }

    private SessionContext getTelemetrySessionContext(RequestTelemetryContext aiContext) {
        return aiContext.getHttpRequestTelemetry().getContext().getSession();
    }
}

