/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.internal.schemav2.DataPointType;
import com.microsoft.applicationinsights.internal.schemav2.SeverityLevel;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.telemetry.Duration;
import com.microsoft.applicationinsights.telemetry.JsonSerializable;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JsonTelemetryDataSerializer {
    private static final String JSON_SEPARATOR = ",";
    private static final String JSON_START_OBJECT = "{";
    private static final String JSON_CLOSE_OBJECT = "}";
    private static final String JSON_START_ARRAY = "[";
    private static final String JSON_CLOSE_ARRAY = "]";
    private static final String JSON_COMMA = "\"";
    private static final String JSON_NAME_VALUE_SEPARATOR = ":";
    private static final String JSON_EMPTY_OBJECT = "{}";
    private static final int DELTA = 2;
    private static final Set<Class<?>> WRAPPER_TYPES = JsonTelemetryDataSerializer.getWrapperTypes();
    private Writer out;
    private String separator = "";

    public JsonTelemetryDataSerializer(Writer out) throws IOException {
        this.reset(out);
    }

    public void reset(Writer out) throws IOException {
        this.separator = "";
        this.out = out;
        this.out.write(JSON_START_OBJECT);
    }

    public void close() throws IOException {
        this.out.write(JSON_CLOSE_OBJECT);
        this.out.close();
    }

    public void write(String name, Duration value) throws IOException {
        this.writeName(name);
        this.write(String.valueOf(value));
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, DataPointType value) throws IOException {
        if (value != null) {
            this.writeName(name);
            this.out.write(String.valueOf(value.getValue()));
            this.separator = JSON_SEPARATOR;
        }
    }

    public void write(String name, int value) throws IOException {
        this.writeName(name);
        this.out.write(String.valueOf(value));
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, SeverityLevel value) throws IOException {
        if (value != null) {
            this.writeName(name);
            this.out.write(JSON_COMMA);
            this.out.write(String.valueOf((Object)value));
            this.out.write(JSON_COMMA);
            this.separator = JSON_SEPARATOR;
        }
    }

    public void write(String name, Integer value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeName(name);
        this.out.write(String.valueOf(value));
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, double value) throws IOException {
        this.writeName(name);
        this.out.write(Double.isNaN(value) || Double.isInfinite(value) ? "0.0" : String.valueOf(value));
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, Double value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeName(name);
        this.out.write(Double.isNaN(value) || Double.isInfinite(value) ? "0.0" : String.valueOf(value));
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, short value) throws IOException {
        this.writeName(name);
        this.out.write(String.valueOf(value));
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, Short value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeName(name);
        this.out.write(String.valueOf(value));
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, long value) throws IOException {
        this.writeName(name);
        this.out.write(String.valueOf(value));
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, Long value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeName(name);
        this.out.write(String.valueOf(value));
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, boolean value) throws IOException {
        this.writeName(name);
        this.out.write(String.valueOf(value));
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, Boolean value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeName(name);
        this.out.write(String.valueOf(value));
        this.separator = JSON_SEPARATOR;
    }

    public void write(String name, Date value) throws IOException {
        if (value == null) {
            return;
        }
        this.writeName(name);
        this.write(LocalStringsUtils.getDateFormatter().format(value));
        this.separator = JSON_SEPARATOR;
    }

    @Deprecated
    public void write(String name, String value) throws IOException {
    }

    public void write(String name, String value, int len) throws IOException {
        if (value == null || value.equals("")) {
            return;
        }
        this.writeToJson(name, value, len);
    }

    public void writeRequired(String name, String value, int len) throws IOException {
        if (value == null || value.equals("")) {
            value = "DEFAULT " + name;
        }
        this.writeToJson(name, value, len);
    }

    private void writeToJson(String name, String value, int len) throws IOException {
        this.writeName(name);
        this.out.write(JSON_COMMA);
        String sanitizedValue = this.sanitizeStringForJSON(value, len);
        this.out.write(sanitizedValue);
        this.out.write(JSON_COMMA);
        this.separator = JSON_SEPARATOR;
    }

    public <T extends JsonSerializable> void write(String name, T value) throws IOException {
        if (value == null) {
            return;
        }
        String jsonStringToAppend = this.createJsonFor(value);
        if (Strings.isNullOrEmpty(jsonStringToAppend)) {
            return;
        }
        this.writeName(name);
        this.out.write(jsonStringToAppend);
        this.separator = JSON_SEPARATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void write(String name, Map<String, T> map) throws IOException {
        if (map == null) {
            return;
        }
        this.writeName(name);
        try {
            if (map.size() < 1) {
                this.out.write("null");
            } else {
                this.out.write(JSON_START_OBJECT);
                this.separator = "";
                for (Map.Entry<String, T> entry : map.entrySet()) {
                    this.writeName(this.sanitizeKey(entry.getKey()));
                    this.write(entry.getValue());
                    this.separator = JSON_SEPARATOR;
                }
                this.out.write(JSON_CLOSE_OBJECT);
            }
        }
        finally {
            this.separator = JSON_SEPARATOR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void write(String name, List<T> list) throws IOException {
        if (list == null) {
            return;
        }
        this.writeName(name);
        try {
            if (list.size() < 1) {
                this.out.write("null");
            } else {
                this.out.write(JSON_START_ARRAY);
                this.separator = "";
                for (T item : list) {
                    this.out.write(this.separator);
                    this.write(item);
                    this.separator = JSON_SEPARATOR;
                }
                this.out.write(JSON_CLOSE_ARRAY);
            }
        }
        finally {
            this.separator = JSON_SEPARATOR;
        }
    }

    private <T> void write(T item) throws IOException {
        if (item instanceof JsonSerializable) {
            StringWriter stringWriter = new StringWriter();
            String jsonStringToAppend = this.createJsonFor((JsonSerializable)item);
            if (Strings.isNullOrEmpty(jsonStringToAppend)) {
                return;
            }
            this.out.write(jsonStringToAppend);
        } else if (WRAPPER_TYPES.contains(item.getClass())) {
            this.out.write(String.valueOf(item));
        } else {
            String truncatedName = this.truncate(String.valueOf(item), 8192);
            String sanitizedItem = this.sanitizeStringForJSON(truncatedName, 8192);
            this.out.write(JSON_COMMA);
            this.out.write(sanitizedItem);
            this.out.write(JSON_COMMA);
        }
    }

    private <T extends JsonSerializable> String createJsonFor(T value) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonTelemetryDataSerializer temp = new JsonTelemetryDataSerializer(new BufferedWriter(stringWriter));
        value.serialize(temp);
        temp.close();
        String jsonStringToAppend = stringWriter.toString();
        if (Strings.isNullOrEmpty(jsonStringToAppend) || JSON_EMPTY_OBJECT.equals(jsonStringToAppend)) {
            return "";
        }
        return jsonStringToAppend;
    }

    private void writeName(String name) throws IOException {
        this.out.write(this.separator);
        this.out.write(JSON_COMMA);
        this.out.write(name);
        this.out.write(JSON_COMMA);
        this.out.write(JSON_NAME_VALUE_SEPARATOR);
    }

    private static Set<Class<?>> getWrapperTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Short.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        ret.add(Void.class);
        return ret;
    }

    private String sanitizeStringForJSON(String text, int maxLength) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(text);
        char curr = iterator.current();
        while (true) {
            if (curr == '\uffff' || result.length() >= maxLength - 2) break;
            if (curr == '\"') {
                result.append("\\\"");
            } else if (curr == '\\') {
                result.append("\\\\");
            } else if (curr == '/') {
                result.append("\\/");
            } else if (curr == '\b') {
                result.append("\\b");
            } else if (curr == '\f') {
                result.append("\\f");
            } else if (curr == '\n') {
                result.append("\\n");
            } else if (curr == '\r') {
                result.append("\\r");
            } else if (curr == '\t') {
                result.append("\\t");
            } else if (!Character.isISOControl(curr)) {
                result.append(curr);
            } else {
                if (result.length() + 7 >= maxLength) break;
                result.append("\\u");
                result.append(String.format("%04x", curr));
            }
            curr = iterator.next();
        }
        return result.toString();
    }

    private String sanitizeKey(String key) {
        String sanitizedKey = JsonTelemetryDataSerializer.trimAndTruncate(key, 150);
        sanitizedKey = this.sanitizeStringForJSON(sanitizedKey, 150);
        sanitizedKey = this.MakeKeyNonEmpty(sanitizedKey);
        return sanitizedKey;
    }

    private static String trimAndTruncate(String value, int maxLength) {
        if (value == null) {
            return value;
        }
        String sanitized = value.trim();
        if (sanitized.length() > maxLength) {
            sanitized = sanitized.substring(0, maxLength);
        }
        return sanitized;
    }

    private String MakeKeyNonEmpty(String key) {
        return Strings.isNullOrEmpty(key) ? "(required property name is empty)" : key;
    }

    private String truncate(String value, int len) {
        if (value.length() > len) {
            return value.substring(0, len);
        }
        return value;
    }
}

