/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.correlation;

import com.microsoft.applicationinsights.web.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.web.dependencies.http.ParseException;
import com.microsoft.applicationinsights.web.dependencies.http.client.config.RequestConfig;
import com.microsoft.applicationinsights.web.dependencies.http.client.methods.HttpGet;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.CloseableHttpAsyncClient;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.HttpAsyncClients;
import com.microsoft.applicationinsights.web.dependencies.http.nio.client.HttpAsyncClient;
import com.microsoft.applicationinsights.web.dependencies.http.util.EntityUtils;
import com.microsoft.applicationinsights.web.internal.correlation.AppProfileFetcher;
import com.microsoft.applicationinsights.web.internal.correlation.ProfileFetcherResult;
import com.microsoft.applicationinsights.web.internal.correlation.ProfileFetcherResultTaskStatus;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class CdsProfileFetcher
implements AppProfileFetcher {
    private HttpAsyncClient httpClient;
    private String endpointAddress;
    private static final String ProfileQueryEndpointAppIdFormat = "%s/api/profiles/%s/appId";
    private static final String DefaultProfileQueryEndpointAddress = "https://dc.services.visualstudio.com";
    private final ConcurrentMap<String, Future<HttpResponse>> tasks;

    public CdsProfileFetcher() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).build();
        this.httpClient = HttpAsyncClients.custom().setDefaultRequestConfig(requestConfig).build();
        ((CloseableHttpAsyncClient)this.httpClient).start();
        this.tasks = new ConcurrentHashMap<String, Future<HttpResponse>>();
        this.endpointAddress = DefaultProfileQueryEndpointAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileFetcherResult fetchAppProfile(String instrumentationKey) throws InterruptedException, ExecutionException, ParseException, IOException {
        if (instrumentationKey == null || instrumentationKey.isEmpty()) {
            throw new IllegalArgumentException("instrumentationKey must be not null or empty");
        }
        ProfileFetcherResult result = new ProfileFetcherResult(null, ProfileFetcherResultTaskStatus.PENDING);
        Future<HttpResponse> currentTask = (Future<HttpResponse>)this.tasks.get(instrumentationKey);
        if (currentTask == null) {
            currentTask = this.createFetchTask(instrumentationKey);
            this.tasks.putIfAbsent(instrumentationKey, currentTask);
        }
        if (!currentTask.isDone()) {
            return result;
        }
        try {
            HttpResponse response = currentTask.get();
            if (response.getStatusLine().getStatusCode() != 200) {
                ProfileFetcherResult profileFetcherResult = new ProfileFetcherResult(null, ProfileFetcherResultTaskStatus.FAILED);
                return profileFetcherResult;
            }
            String appId = EntityUtils.toString(response.getEntity());
            if (appId == null || appId.isEmpty()) {
                ProfileFetcherResult profileFetcherResult = new ProfileFetcherResult(null, ProfileFetcherResultTaskStatus.FAILED);
                return profileFetcherResult;
            }
            ProfileFetcherResult profileFetcherResult = new ProfileFetcherResult(appId, ProfileFetcherResultTaskStatus.COMPLETE);
            return profileFetcherResult;
        }
        finally {
            this.tasks.remove(instrumentationKey);
        }
    }

    public void setHttpClient(HttpAsyncClient client) {
        this.httpClient = client;
    }

    public void setEndpointAddress(String endpoint) throws MalformedURLException {
        URL url = new URL(endpoint);
        String urlStr = url.toString();
        this.endpointAddress = urlStr.substring(0, urlStr.length() - url.getFile().length());
    }

    private Future<HttpResponse> createFetchTask(String instrumentationKey) {
        HttpGet request = new HttpGet(String.format(ProfileQueryEndpointAppIdFormat, this.endpointAddress, instrumentationKey));
        return this.httpClient.execute(request, null);
    }
}

