/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.config.AppInsightsConfigurationBuilder;
import com.microsoft.applicationinsights.internal.config.ApplicationInsightsXmlConfiguration;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

class JaxbAppInsightsConfigurationBuilder
implements AppInsightsConfigurationBuilder {
    JaxbAppInsightsConfigurationBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationInsightsXmlConfiguration build(InputStream resourceFile) {
        if (resourceFile == null) {
            return null;
        }
        try {
            ApplicationInsightsXmlConfiguration applicationInsights;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ApplicationInsightsXmlConfiguration.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            XMLStreamReader resourceFileReader = this.getXmlStreamReader(resourceFile);
            if (resourceFileReader == null) {
                ApplicationInsightsXmlConfiguration applicationInsightsXmlConfiguration = null;
                return applicationInsightsXmlConfiguration;
            }
            ApplicationInsightsXmlConfiguration applicationInsightsXmlConfiguration = applicationInsights = (ApplicationInsightsXmlConfiguration)unmarshaller.unmarshal(resourceFileReader);
            return applicationInsightsXmlConfiguration;
        }
        catch (JAXBException e) {
            if (e.getCause() != null) {
                InternalLogger.INSTANCE.error("Failed to parse configuration file: '%s'", ExceptionUtils.getStackTrace(e));
            } else {
                InternalLogger.INSTANCE.error("Failed to parse configuration file: '%s'", ExceptionUtils.getStackTrace(e));
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        finally {
            try {
                resourceFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private XMLStreamReader getXmlStreamReader(InputStream input) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            return factory.createXMLStreamReader(input);
        }
        catch (Throwable t) {
            InternalLogger.INSTANCE.error("Failed to create stream reader for configuration file: '%s'", ExceptionUtils.getStackTrace(t));
            return null;
        }
    }
}

