/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.impl.conn;

import com.microsoft.applicationinsights.web.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.web.dependencies.http.HttpResponseFactory;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.web.dependencies.http.config.MessageConstraints;
import com.microsoft.applicationinsights.web.dependencies.http.impl.DefaultHttpResponseFactory;
import com.microsoft.applicationinsights.web.dependencies.http.impl.conn.DefaultHttpResponseParser;
import com.microsoft.applicationinsights.web.dependencies.http.io.HttpMessageParser;
import com.microsoft.applicationinsights.web.dependencies.http.io.HttpMessageParserFactory;
import com.microsoft.applicationinsights.web.dependencies.http.io.SessionInputBuffer;
import com.microsoft.applicationinsights.web.dependencies.http.message.BasicLineParser;
import com.microsoft.applicationinsights.web.dependencies.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

