/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentialsInterceptor;
import com.microsoft.rest.credentials.TokenCredentials;
import java.io.IOException;
import java.net.Proxy;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Authenticator;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public abstract class AzureTokenCredentials
extends TokenCredentials {
    private final AzureEnvironment environment;
    private final String domain;
    private String defaultSubscription;
    private Proxy proxy;
    private SSLSocketFactory sslSocketFactory;

    public AzureTokenCredentials(AzureEnvironment environment, String domain) {
        super("Bearer", null);
        this.environment = environment == null ? AzureEnvironment.AZURE : environment;
        this.domain = domain;
    }

    protected final String getToken(Request request) throws IOException {
        String host = request.url().toString().toLowerCase();
        String resource = this.environment().managementEndpoint();
        for (Map.Entry<String, String> endpoint : this.environment().endpoints().entrySet()) {
            if (!host.contains(endpoint.getValue())) continue;
            if (endpoint.getKey().equals(AzureEnvironment.Endpoint.KEYVAULT.identifier())) {
                resource = String.format("https://%s/", endpoint.getValue().replaceAll("^\\.*", ""));
                break;
            }
            if (endpoint.getKey().equals(AzureEnvironment.Endpoint.GRAPH.identifier())) {
                resource = this.environment().graphEndpoint();
                continue;
            }
            if (!endpoint.getKey().equals(AzureEnvironment.Endpoint.DATA_LAKE_STORE.identifier()) && !endpoint.getKey().equals(AzureEnvironment.Endpoint.DATA_LAKE_ANALYTICS.identifier())) continue;
            resource = this.environment().dataLakeEndpointResourceId();
        }
        return this.getToken(resource);
    }

    public abstract String getToken(String var1) throws IOException;

    public String domain() {
        return this.domain;
    }

    public AzureEnvironment environment() {
        return this.environment;
    }

    public String defaultSubscriptionId() {
        return this.defaultSubscription;
    }

    public AzureTokenCredentials withDefaultSubscriptionId(String subscriptionId) {
        this.defaultSubscription = subscriptionId;
        return this;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    public AzureTokenCredentials withProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public AzureTokenCredentials withSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public void applyCredentialsFilter(OkHttpClient.Builder clientBuilder) {
        clientBuilder.interceptors().add(new AzureTokenCredentialsInterceptor(this));
        clientBuilder.authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                Pattern pattern;
                Matcher matcher;
                String authenticateHeader = response.header("WWW-Authenticate");
                if (authenticateHeader != null && !authenticateHeader.isEmpty() && (matcher = (pattern = Pattern.compile("resource=\"([a-zA-Z0-9.:/-_]+)\"")).matcher(authenticateHeader)).find()) {
                    String resource = matcher.group(1);
                    return response.request().newBuilder().header("Authorization", "Bearer " + AzureTokenCredentials.this.getToken(resource)).build();
                }
                return null;
            }
        });
    }
}

