/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.ConsistencyLevel;
import com.azure.data.cosmos.JsonSerializable;
import com.google.common.base.CaseFormat;

public final class ConsistencyPolicy
extends JsonSerializable {
    private static final ConsistencyLevel DEFAULT_DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.SESSION;
    private static final int DEFAULT_MAX_STALENESS_INTERVAL = 5;
    private static final int DEFAULT_MAX_STALENESS_PREFIX = 100;

    public ConsistencyPolicy() {
    }

    ConsistencyPolicy(String jsonString) {
        super(jsonString);
    }

    public ConsistencyLevel defaultConsistencyLevel() {
        ConsistencyLevel result = DEFAULT_DEFAULT_CONSISTENCY_LEVEL;
        String consistencyLevelString = super.getString("defaultConsistencyLevel");
        try {
            result = ConsistencyLevel.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, consistencyLevelString));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("Unknown consistency level {}, value ignored.", (Object)consistencyLevelString);
        }
        return result;
    }

    public ConsistencyPolicy defaultConsistencyLevel(ConsistencyLevel level) {
        super.set("defaultConsistencyLevel", level.toString());
        return this;
    }

    public int maxStalenessPrefix() {
        Integer value = super.getInt("maxStalenessPrefix");
        if (value == null) {
            return 100;
        }
        return value;
    }

    public ConsistencyPolicy maxStalenessPrefix(int maxStalenessPrefix) {
        super.set("maxStalenessPrefix", maxStalenessPrefix);
        return this;
    }

    public int maxStalenessIntervalInSeconds() {
        Integer value = super.getInt("maxIntervalInSeconds");
        if (value == null) {
            return 5;
        }
        return value;
    }

    public ConsistencyPolicy maxStalenessIntervalInSeconds(int maxStalenessIntervalInSeconds) {
        super.set("maxIntervalInSeconds", maxStalenessIntervalInSeconds);
        return this;
    }
}

