/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.ConnectionPolicy;
import com.azure.data.cosmos.ConsistencyLevel;
import com.azure.data.cosmos.CosmosClient;
import com.azure.data.cosmos.CosmosKeyCredential;
import com.azure.data.cosmos.TokenResolver;
import com.azure.data.cosmos.internal.Configs;
import com.azure.data.cosmos.internal.Permission;
import com.azure.data.cosmos.sync.CosmosSyncClient;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CosmosClientBuilder {
    private Configs configs = new Configs();
    private String serviceEndpoint;
    private String keyOrResourceToken;
    private ConnectionPolicy connectionPolicy;
    private ConsistencyLevel desiredConsistencyLevel;
    private List<Permission> permissions;
    private TokenResolver tokenResolver;
    private CosmosKeyCredential cosmosKeyCredential;

    public TokenResolver tokenResolver() {
        return this.tokenResolver;
    }

    public CosmosClientBuilder tokenResolver(TokenResolver tokenResolver) {
        this.tokenResolver = tokenResolver;
        return this;
    }

    public String endpoint() {
        return this.serviceEndpoint;
    }

    public CosmosClientBuilder endpoint(String endpoint) {
        this.serviceEndpoint = endpoint;
        return this;
    }

    public String key() {
        return this.keyOrResourceToken;
    }

    public CosmosClientBuilder key(String key) {
        this.keyOrResourceToken = key;
        return this;
    }

    public String resourceToken() {
        return this.keyOrResourceToken;
    }

    public CosmosClientBuilder resourceToken(String resourceToken) {
        this.keyOrResourceToken = resourceToken;
        return this;
    }

    public List<Permission> permissions() {
        return this.permissions;
    }

    public CosmosClientBuilder permissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public ConsistencyLevel consistencyLevel() {
        return this.desiredConsistencyLevel;
    }

    public CosmosClientBuilder consistencyLevel(ConsistencyLevel desiredConsistencyLevel) {
        this.desiredConsistencyLevel = desiredConsistencyLevel;
        return this;
    }

    public ConnectionPolicy connectionPolicy() {
        return this.connectionPolicy;
    }

    public CosmosClientBuilder connectionPolicy(ConnectionPolicy connectionPolicy) {
        this.connectionPolicy = connectionPolicy;
        return this;
    }

    public CosmosKeyCredential cosmosKeyCredential() {
        return this.cosmosKeyCredential;
    }

    public CosmosClientBuilder cosmosKeyCredential(CosmosKeyCredential cosmosKeyCredential) {
        this.cosmosKeyCredential = cosmosKeyCredential;
        return this;
    }

    public CosmosClient build() {
        this.validateConfig();
        return new CosmosClient(this);
    }

    private void validateConfig() {
        this.ifThrowIllegalArgException(this.serviceEndpoint == null, "cannot build client without service endpoint");
        this.ifThrowIllegalArgException(this.keyOrResourceToken == null && (this.permissions == null || this.permissions.isEmpty()) && this.tokenResolver == null && this.cosmosKeyCredential == null, "cannot build client without any one of key, resource token, permissions, token resolver, and cosmos key credential");
        this.ifThrowIllegalArgException(this.cosmosKeyCredential != null && StringUtils.isEmpty((CharSequence)this.cosmosKeyCredential.key()), "cannot build client without key credential");
    }

    public CosmosSyncClient buildSyncClient() {
        this.validateConfig();
        return new CosmosSyncClient(this);
    }

    Configs configs() {
        return this.configs;
    }

    CosmosClientBuilder configs(Configs configs) {
        this.configs = configs;
        return this;
    }

    private void ifThrowIllegalArgException(boolean value, String error) {
        if (value) {
            throw new IllegalArgumentException(error);
        }
    }
}

