/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.internal.Conflict;
import com.azure.data.cosmos.internal.Strings;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;

public class CosmosConflictProperties
extends Resource {
    CosmosConflictProperties() {
    }

    CosmosConflictProperties(String jsonString) {
        super(jsonString);
    }

    public String operationKind() {
        return super.getString("operationType");
    }

    public String resourceType() {
        return super.getString("resourceType");
    }

    String sourceResourceId() {
        return super.getString("resourceId");
    }

    public <T extends Resource> T getResource(Class<T> klass) {
        String resourceAsString = super.getString("content");
        if (!Strings.isNullOrEmpty(resourceAsString)) {
            try {
                return (T)((Resource)klass.getConstructor(String.class).newInstance(resourceAsString));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException("Failed to instantiate class object.", e);
            }
        }
        return null;
    }

    static List<CosmosConflictProperties> getFromV2Results(List<Conflict> results) {
        return results.stream().map(conflict -> new CosmosConflictProperties(conflict.toJson())).collect(Collectors.toList());
    }
}

