/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.ChangeFeedOptions;
import com.azure.data.cosmos.CosmosConflict;
import com.azure.data.cosmos.CosmosConflictProperties;
import com.azure.data.cosmos.CosmosContainerProperties;
import com.azure.data.cosmos.CosmosContainerRequestOptions;
import com.azure.data.cosmos.CosmosContainerResponse;
import com.azure.data.cosmos.CosmosDatabase;
import com.azure.data.cosmos.CosmosItem;
import com.azure.data.cosmos.CosmosItemProperties;
import com.azure.data.cosmos.CosmosItemRequestOptions;
import com.azure.data.cosmos.CosmosItemResponse;
import com.azure.data.cosmos.CosmosScripts;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.SqlParameter;
import com.azure.data.cosmos.SqlParameterList;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.internal.Document;
import com.azure.data.cosmos.internal.DocumentCollection;
import com.azure.data.cosmos.internal.Offer;
import com.azure.data.cosmos.internal.RequestOptions;
import com.azure.data.cosmos.internal.ResourceResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosContainer {
    private CosmosDatabase database;
    private String id;
    private CosmosScripts scripts;

    CosmosContainer(String id, CosmosDatabase database) {
        this.id = id;
        this.database = database;
    }

    public String id() {
        return this.id;
    }

    CosmosContainer id(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosContainerResponse> read() {
        return this.read(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosContainerResponse> read(CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().readCollection(this.getLink(), options.toRequestOptions()).map(response -> new CosmosContainerResponse((ResourceResponse<DocumentCollection>)response, this.database)).single();
    }

    public Mono<CosmosContainerResponse> delete(CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().deleteCollection(this.getLink(), options.toRequestOptions()).map(response -> new CosmosContainerResponse((ResourceResponse<DocumentCollection>)response, this.database)).single();
    }

    public Mono<CosmosContainerResponse> delete() {
        return this.delete(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosContainerResponse> replace(CosmosContainerProperties containerSettings) {
        return this.replace(containerSettings, null);
    }

    public Mono<CosmosContainerResponse> replace(CosmosContainerProperties containerSettings, CosmosContainerRequestOptions options) {
        Resource.validateResource(containerSettings);
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().replaceCollection(containerSettings.getV2Collection(), options.toRequestOptions()).map(response -> new CosmosContainerResponse((ResourceResponse<DocumentCollection>)response, this.database)).single();
    }

    public Mono<CosmosItemResponse> createItem(Object item) {
        return this.createItem(item, new CosmosItemRequestOptions());
    }

    public Mono<CosmosItemResponse> createItem(Object item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.database.getDocClientWrapper().createDocument(this.getLink(), CosmosItemProperties.fromObject(item), requestOptions, true).map(response -> new CosmosItemResponse((ResourceResponse<Document>)response, requestOptions.getPartitionKey(), this)).single();
    }

    public Mono<CosmosItemResponse> upsertItem(Object item) {
        return this.upsertItem(item, null);
    }

    public Mono<CosmosItemResponse> upsertItem(Object item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.getDatabase().getDocClientWrapper().upsertDocument(this.getLink(), CosmosItemProperties.fromObject(item), options.toRequestOptions(), true).map(response -> new CosmosItemResponse((ResourceResponse<Document>)response, requestOptions.getPartitionKey(), this)).single();
    }

    public Flux<FeedResponse<CosmosItemProperties>> readAllItems() {
        return this.readAllItems(new FeedOptions());
    }

    public Flux<FeedResponse<CosmosItemProperties>> readAllItems(FeedOptions options) {
        return this.getDatabase().getDocClientWrapper().readDocuments(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosItemProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public Flux<FeedResponse<CosmosItemProperties>> queryItems(String query) {
        return this.queryItems(new SqlQuerySpec(query), null);
    }

    public Flux<FeedResponse<CosmosItemProperties>> queryItems(String query, FeedOptions options) {
        return this.queryItems(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosItemProperties>> queryItems(SqlQuerySpec querySpec) {
        return this.queryItems(querySpec, null);
    }

    public Flux<FeedResponse<CosmosItemProperties>> queryItems(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getDatabase().getDocClientWrapper().queryDocuments(this.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponseWithQueryMetrics(CosmosItemProperties.getFromV2Results(response.results()), response.responseHeaders(), response.queryMetrics()));
    }

    public Flux<FeedResponse<CosmosItemProperties>> queryChangeFeedItems(ChangeFeedOptions changeFeedOptions) {
        return this.getDatabase().getDocClientWrapper().queryDocumentChangeFeed(this.getLink(), changeFeedOptions).map(response -> new FeedResponse<CosmosItemProperties>(CosmosItemProperties.getFromV2Results(response.results()), response.responseHeaders(), false));
    }

    public CosmosItem getItem(String id, Object partitionKey) {
        return new CosmosItem(id, partitionKey, this);
    }

    public CosmosScripts getScripts() {
        if (this.scripts == null) {
            this.scripts = new CosmosScripts(this);
        }
        return this.scripts;
    }

    public Flux<FeedResponse<CosmosConflictProperties>> readAllConflicts(FeedOptions options) {
        return this.database.getDocClientWrapper().readConflicts(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosConflictProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public Flux<FeedResponse<CosmosConflictProperties>> queryConflicts(String query) {
        return this.queryConflicts(query, null);
    }

    public Flux<FeedResponse<CosmosConflictProperties>> queryConflicts(String query, FeedOptions options) {
        return this.database.getDocClientWrapper().queryConflicts(this.getLink(), query, options).map(response -> BridgeInternal.createFeedResponse(CosmosConflictProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public CosmosConflict getConflict(String id) {
        return new CosmosConflict(id, this);
    }

    public Mono<Integer> readProvisionedThroughput() {
        return this.read().flatMap(cosmosContainerResponse -> this.database.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + ((CosmosContainerProperties)cosmosContainerResponse.resourceSettings()).resourceId() + "'", new FeedOptions()).single()).flatMap(offerFeedResponse -> {
            if (offerFeedResponse.results().isEmpty()) {
                return Mono.error((Throwable)BridgeInternal.createCosmosClientException(400, "No offers found for the resource"));
            }
            return this.database.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.results().get(0)).selfLink()).single();
        }).map(cosmosOfferResponse -> ((Offer)cosmosOfferResponse.getResource()).getThroughput());
    }

    public Mono<Integer> readMinThroughput() {
        return this.read().flatMap(cosmosContainerResponse -> this.database.getDocClientWrapper().queryOffers(new SqlQuerySpec("select * from c where c.offerResourceId = @OFFER_RESOURCE_ID", new SqlParameterList(new SqlParameter("@OFFER_RESOURCE_ID", ((CosmosContainerProperties)cosmosContainerResponse.resourceSettings()).resourceId()))), new FeedOptions()).single()).flatMap(offerFeedResponse -> {
            if (offerFeedResponse.results().isEmpty()) {
                return Mono.error((Throwable)BridgeInternal.createCosmosClientException(400, "No offers found for the resource"));
            }
            return this.database.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.results().get(0)).selfLink()).single();
        }).map(cosmosOfferResponse -> Integer.parseInt(cosmosOfferResponse.getResponseHeaders().get("x-ms-cosmos-min-throughput")));
    }

    public Mono<Integer> replaceProvisionedThroughput(int requestUnitsPerSecond) {
        return this.read().flatMap(cosmosContainerResponse -> this.database.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + ((CosmosContainerProperties)cosmosContainerResponse.resourceSettings()).resourceId() + "'", new FeedOptions()).single()).flatMap(offerFeedResponse -> {
            if (offerFeedResponse.results().isEmpty()) {
                return Mono.error((Throwable)BridgeInternal.createCosmosClientException(400, "No offers found for the resource"));
            }
            Offer offer = (Offer)offerFeedResponse.results().get(0);
            offer.setThroughput(requestUnitsPerSecond);
            return this.database.getDocClientWrapper().replaceOffer(offer).single();
        }).map(offerResourceResponse -> ((Offer)offerResourceResponse.getResource()).getThroughput());
    }

    public CosmosDatabase getDatabase() {
        return this.database;
    }

    String URIPathSegment() {
        return "colls";
    }

    String parentLink() {
        return this.database.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.id());
        return builder.toString();
    }
}

