/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.CosmosResponse;
import com.azure.data.cosmos.CosmosStoredProcedure;
import com.azure.data.cosmos.CosmosStoredProcedureProperties;
import com.azure.data.cosmos.internal.ResourceResponse;
import com.azure.data.cosmos.internal.StoredProcedure;
import com.azure.data.cosmos.internal.StoredProcedureResponse;

public class CosmosStoredProcedureResponse
extends CosmosResponse<CosmosStoredProcedureProperties> {
    private CosmosStoredProcedure storedProcedure;
    private StoredProcedureResponse storedProcedureResponse;

    CosmosStoredProcedureResponse(ResourceResponse<StoredProcedure> response, CosmosContainer cosmosContainer) {
        super(response);
        if (response.getResource() != null) {
            super.resourceSettings(new CosmosStoredProcedureProperties(response));
            this.storedProcedure = new CosmosStoredProcedure(((CosmosStoredProcedureProperties)this.resourceSettings()).id(), cosmosContainer);
        }
    }

    CosmosStoredProcedureResponse(StoredProcedureResponse response, CosmosContainer cosmosContainer, String storedProcedureId) {
        super(response);
        this.storedProcedureResponse = response;
        this.storedProcedure = new CosmosStoredProcedure(storedProcedureId, cosmosContainer);
    }

    public CosmosStoredProcedureProperties properties() {
        return (CosmosStoredProcedureProperties)super.resourceSettings();
    }

    public CosmosStoredProcedure storedProcedure() {
        return this.storedProcedure;
    }

    @Override
    public String activityId() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getActivityId();
        }
        return super.activityId();
    }

    @Override
    public String sessionToken() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getSessionToken();
        }
        return super.sessionToken();
    }

    @Override
    public int statusCode() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getStatusCode();
        }
        return super.statusCode();
    }

    @Override
    public double requestCharge() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getRequestCharge();
        }
        return super.requestCharge();
    }

    public String responseAsString() {
        return this.storedProcedureResponse.getResponseAsString();
    }

    public String scriptLog() {
        return this.storedProcedureResponse.getScriptLog();
    }
}

