/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosError;
import com.azure.data.cosmos.internal.directconnectivity.HttpUtils;
import com.azure.data.cosmos.internal.http.HttpHeaders;
import java.util.Map;

public class RequestEntityTooLargeException
extends CosmosClientException {
    private static final long serialVersionUID = 1L;

    RequestEntityTooLargeException() {
        this("The size of the response exceeded the maximum allowed size, limit the  response size by specifying smaller value for '%s' header.");
    }

    public RequestEntityTooLargeException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(413, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    RequestEntityTooLargeException(String msg) {
        super(413, msg);
    }

    RequestEntityTooLargeException(String msg, String resourceAddress) {
        super(msg, null, null, 413, resourceAddress);
    }

    public RequestEntityTooLargeException(String message, HttpHeaders headers, String requestUriString) {
        this(message, null, headers, requestUriString);
    }

    RequestEntityTooLargeException(Exception innerException) {
        this("The size of the response exceeded the maximum allowed size, limit the  response size by specifying smaller value for '%s' header.", innerException, null, null);
    }

    RequestEntityTooLargeException(String message, Exception innerException, HttpHeaders headers, String requestUriString) {
        super(String.format("The size of the response exceeded the maximum allowed size, limit the  response size by specifying smaller value for '%s' header.", message), innerException, HttpUtils.asMap(headers), 413, requestUriString);
    }
}

