/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.Resource;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class Document
extends Resource {
    public Document() {
    }

    @Override
    public Document id(String id) {
        super.id(id);
        return this;
    }

    Document(String jsonString, ObjectMapper objectMapper) {
        super(jsonString);
        BridgeInternal.setMapper(this, objectMapper);
    }

    public Document(String jsonString) {
        super(jsonString);
    }

    public static Document FromObject(Object document, ObjectMapper objectMapper) {
        if (!(document instanceof Document)) {
            try {
                return new Document(objectMapper.writeValueAsString(document));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
        Document typedDocument = (Document)document;
        return typedDocument;
    }

    public Integer getTimeToLive() {
        if (super.has("ttl")) {
            return super.getInt("ttl");
        }
        return null;
    }

    public void setTimeToLive(Integer timeToLive) {
        if (timeToLive != null) {
            BridgeInternal.setProperty(this, "ttl", timeToLive);
        } else if (super.has("ttl")) {
            BridgeInternal.remove(this, "ttl");
        }
    }
}

