/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity;

import com.azure.data.cosmos.InternalServerErrorException;
import com.azure.data.cosmos.internal.AuthorizationTokenType;
import com.azure.data.cosmos.internal.IAuthorizationTokenProvider;
import com.azure.data.cosmos.internal.OperationType;
import com.azure.data.cosmos.internal.PathsHelper;
import com.azure.data.cosmos.internal.ResourceId;
import com.azure.data.cosmos.internal.ResourceType;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.Utils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class BarrierRequestHelper {
    private static final Logger logger = LoggerFactory.getLogger(BarrierRequestHelper.class);

    public static Mono<RxDocumentServiceRequest> createAsync(RxDocumentServiceRequest request, IAuthorizationTokenProvider authorizationTokenProvider, Long targetLsn, Long targetGlobalCommittedLsn) {
        boolean isCollectionHeadRequest = BarrierRequestHelper.isCollectionHeadBarrierRequest(request.getResourceType(), request.getOperationType());
        AuthorizationTokenType originalRequestTokenType = request.authorizationTokenType;
        if (originalRequestTokenType == AuthorizationTokenType.Invalid) {
            String message = "AuthorizationTokenType not set for the read request";
            assert (false) : message;
            logger.error(message);
        }
        String authorizationToken = "";
        RxDocumentServiceRequest barrierLsnRequest = null;
        if (!isCollectionHeadRequest) {
            barrierLsnRequest = RxDocumentServiceRequest.create(OperationType.HeadFeed, (String)null, ResourceType.Database, (Map<String, String>)null);
        } else if (request.getIsNameBased()) {
            String collectionLink = PathsHelper.getCollectionPath(request.getResourceAddress());
            barrierLsnRequest = RxDocumentServiceRequest.createFromName(OperationType.Head, collectionLink, ResourceType.DocumentCollection);
        } else {
            barrierLsnRequest = RxDocumentServiceRequest.create(OperationType.Head, ResourceId.parse(request.getResourceId()).getDocumentCollectionId().toString(), ResourceType.DocumentCollection, null);
        }
        barrierLsnRequest.getHeaders().put("x-ms-date", Utils.nowAsRFC1123());
        if (targetLsn != null && targetLsn > 0L) {
            barrierLsnRequest.getHeaders().put("x-ms-target-lsn", targetLsn.toString());
        }
        if (targetGlobalCommittedLsn != null && targetGlobalCommittedLsn > 0L) {
            barrierLsnRequest.getHeaders().put("x-ms-target-global-committed-lsn", targetGlobalCommittedLsn.toString());
        }
        switch (originalRequestTokenType) {
            case PrimaryMasterKey: 
            case PrimaryReadonlyMasterKey: 
            case SecondaryMasterKey: 
            case SecondaryReadonlyMasterKey: {
                authorizationToken = authorizationTokenProvider.getUserAuthorizationToken(barrierLsnRequest.getResourceAddress(), isCollectionHeadRequest ? ResourceType.DocumentCollection : ResourceType.Database, "HEAD", barrierLsnRequest.getHeaders(), originalRequestTokenType, request.properties);
                break;
            }
            case ResourceToken: {
                authorizationToken = request.getHeaders().get("authorization");
                break;
            }
            default: {
                String unknownAuthToken = "Unknown authorization token kind for read request";
                assert (false) : unknownAuthToken;
                logger.error(unknownAuthToken);
                throw Exceptions.propagate((Throwable)new InternalServerErrorException("Unknown server error occurred when processing this request."));
            }
        }
        barrierLsnRequest.getHeaders().put("authorization", authorizationToken);
        barrierLsnRequest.requestContext = request.requestContext.clone();
        if (request.getPartitionKeyRangeIdentity() != null) {
            barrierLsnRequest.routeTo(request.getPartitionKeyRangeIdentity());
        }
        if (request.getHeaders().get("x-ms-documentdb-partitionkey") != null) {
            barrierLsnRequest.getHeaders().put("x-ms-documentdb-partitionkey", request.getHeaders().get("x-ms-documentdb-partitionkey"));
        }
        if (request.getHeaders().get("x-ms-documentdb-collection-rid") != null) {
            barrierLsnRequest.getHeaders().put("x-ms-documentdb-collection-rid", request.getHeaders().get("x-ms-documentdb-collection-rid"));
        }
        return Mono.just((Object)barrierLsnRequest);
    }

    static boolean isCollectionHeadBarrierRequest(ResourceType resourceType, OperationType operationType) {
        switch (resourceType) {
            case Attachment: 
            case Document: 
            case Conflict: 
            case StoredProcedure: 
            case UserDefinedFunction: 
            case Trigger: {
                return true;
            }
            case DocumentCollection: {
                return operationType != OperationType.ReadFeed && operationType != OperationType.Query && operationType != OperationType.SqlQuery;
            }
            case PartitionKeyRange: {
                return false;
            }
        }
        return false;
    }
}

