/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity;

import com.azure.data.cosmos.ConnectionPolicy;
import com.azure.data.cosmos.internal.DocumentCollection;
import com.azure.data.cosmos.internal.GlobalEndpointManager;
import com.azure.data.cosmos.internal.IAuthorizationTokenProvider;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.UserAgentContainer;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.caches.RxCollectionCache;
import com.azure.data.cosmos.internal.caches.RxPartitionKeyRangeCache;
import com.azure.data.cosmos.internal.directconnectivity.AddressInformation;
import com.azure.data.cosmos.internal.directconnectivity.AddressResolver;
import com.azure.data.cosmos.internal.directconnectivity.GatewayAddressCache;
import com.azure.data.cosmos.internal.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.data.cosmos.internal.directconnectivity.IAddressResolver;
import com.azure.data.cosmos.internal.directconnectivity.Protocol;
import com.azure.data.cosmos.internal.http.HttpClient;
import com.azure.data.cosmos.internal.routing.CollectionRoutingMap;
import com.azure.data.cosmos.internal.routing.PartitionKeyRangeIdentity;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.concurrent.Queues;

public class GlobalAddressResolver
implements IAddressResolver {
    private static final int MaxBackupReadRegions = 3;
    private final GlobalEndpointManager endpointManager;
    private final Protocol protocol;
    private final IAuthorizationTokenProvider tokenProvider;
    private final UserAgentContainer userAgentContainer;
    private final RxCollectionCache collectionCache;
    private final RxPartitionKeyRangeCache routingMapProvider;
    private final int maxEndpoints;
    private final GatewayServiceConfigurationReader serviceConfigReader;
    final Map<URL, EndpointCache> addressCacheByEndpoint;
    private GatewayAddressCache gatewayAddressCache;
    private AddressResolver addressResolver;
    private HttpClient httpClient;

    public GlobalAddressResolver(HttpClient httpClient, GlobalEndpointManager endpointManager, Protocol protocol, IAuthorizationTokenProvider tokenProvider, RxCollectionCache collectionCache, RxPartitionKeyRangeCache routingMapProvider, UserAgentContainer userAgentContainer, GatewayServiceConfigurationReader serviceConfigReader, ConnectionPolicy connectionPolicy) {
        this.httpClient = httpClient;
        this.endpointManager = endpointManager;
        this.protocol = protocol;
        this.tokenProvider = tokenProvider;
        this.userAgentContainer = userAgentContainer;
        this.collectionCache = collectionCache;
        this.routingMapProvider = routingMapProvider;
        this.serviceConfigReader = serviceConfigReader;
        int maxBackupReadEndpoints = connectionPolicy.enableReadRequestsFallback() == null || connectionPolicy.enableReadRequestsFallback() != false ? 3 : 0;
        this.maxEndpoints = maxBackupReadEndpoints + 2;
        this.addressCacheByEndpoint = new ConcurrentHashMap<URL, EndpointCache>();
        for (URL endpoint : endpointManager.getWriteEndpoints()) {
            this.getOrAddEndpoint(endpoint);
        }
        for (URL endpoint : endpointManager.getReadEndpoints()) {
            this.getOrAddEndpoint(endpoint);
        }
    }

    Mono<Void> openAsync(DocumentCollection collection) {
        Mono<Utils.ValueHolder<CollectionRoutingMap>> routingMap = this.routingMapProvider.tryLookupAsync(collection.id(), null, null);
        return routingMap.flatMap(collectionRoutingMap -> {
            if (collectionRoutingMap.v == null) {
                return Mono.empty();
            }
            List<PartitionKeyRangeIdentity> ranges = ((CollectionRoutingMap)collectionRoutingMap.v).getOrderedPartitionKeyRanges().stream().map(range -> new PartitionKeyRangeIdentity(collection.resourceId(), range.id())).collect(Collectors.toList());
            ArrayList<Mono<Void>> tasks = new ArrayList<Mono<Void>>();
            Mono[] array = new Mono[this.addressCacheByEndpoint.values().size()];
            for (EndpointCache endpointCache : this.addressCacheByEndpoint.values()) {
                tasks.add(endpointCache.addressCache.openAsync(collection, ranges));
            }
            return Flux.mergeDelayError((int)Queues.SMALL_BUFFER_SIZE, (Publisher[])((Publisher[])tasks.toArray(array))).then();
        });
    }

    @Override
    public Mono<AddressInformation[]> resolveAsync(RxDocumentServiceRequest request, boolean forceRefresh) {
        IAddressResolver resolver = this.getAddressResolver(request);
        return resolver.resolveAsync(request, forceRefresh);
    }

    public void dispose() {
        for (EndpointCache endpointCache : this.addressCacheByEndpoint.values()) {
            endpointCache.addressCache.dispose();
        }
    }

    private IAddressResolver getAddressResolver(RxDocumentServiceRequest rxDocumentServiceRequest) {
        URL endpoint = this.endpointManager.resolveServiceEndpoint(rxDocumentServiceRequest);
        return this.getOrAddEndpoint((URL)endpoint).addressResolver;
    }

    private EndpointCache getOrAddEndpoint(URL endpoint) {
        EndpointCache endpointCache = this.addressCacheByEndpoint.computeIfAbsent(endpoint, key -> {
            GatewayAddressCache gatewayAddressCache = new GatewayAddressCache(endpoint, this.protocol, this.tokenProvider, this.userAgentContainer, this.httpClient);
            AddressResolver addressResolver = new AddressResolver();
            addressResolver.initializeCaches(this.collectionCache, this.routingMapProvider, gatewayAddressCache);
            EndpointCache cache = new EndpointCache();
            cache.addressCache = gatewayAddressCache;
            cache.addressResolver = addressResolver;
            return cache;
        });
        if (this.addressCacheByEndpoint.size() > this.maxEndpoints) {
            ArrayList<URL> allEndpoints = new ArrayList<URL>((Collection<URL>)this.endpointManager.getWriteEndpoints());
            allEndpoints.addAll((Collection<URL>)this.endpointManager.getReadEndpoints());
            Collections.reverse(allEndpoints);
            LinkedList<URL> endpoints = new LinkedList<URL>(allEndpoints);
            while (this.addressCacheByEndpoint.size() > this.maxEndpoints && endpoints.size() > 0) {
                URL dequeueEnpoint = endpoints.pop();
                if (this.addressCacheByEndpoint.get(dequeueEnpoint) == null) continue;
                this.addressCacheByEndpoint.remove(dequeueEnpoint);
            }
        }
        return endpointCache;
    }

    static class EndpointCache {
        GatewayAddressCache addressCache;
        AddressResolver addressResolver;

        EndpointCache() {
        }
    }
}

