/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.routing;

import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class LocationHelper {
    public static URL getLocationEndpoint(URL serviceEndpoint, String location) {
        String host;
        CharSequence[] hostParts = StringUtils.split((String)serviceEndpoint.getHost(), (String)".", (int)2);
        if (hostParts.length != 0) {
            hostParts[0] = hostParts[0] + "-" + LocationHelper.dataCenterToUriPostfix(location);
            host = String.join((CharSequence)".", hostParts);
        } else {
            host = serviceEndpoint.getHost();
        }
        try {
            return new URL(serviceEndpoint.getProtocol(), host, serviceEndpoint.getPort(), serviceEndpoint.getFile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String dataCenterToUriPostfix(String dataCenter) {
        return dataCenter.replace(" ", "");
    }
}

