/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.sync;

import com.azure.data.cosmos.CosmosClient;
import com.azure.data.cosmos.CosmosClientBuilder;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosDatabaseProperties;
import com.azure.data.cosmos.CosmosDatabaseRequestOptions;
import com.azure.data.cosmos.CosmosDatabaseResponse;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.sync.CosmosSyncDatabase;
import com.azure.data.cosmos.sync.CosmosSyncDatabaseResponse;
import java.util.Iterator;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosSyncClient
implements AutoCloseable {
    private final CosmosClient asyncClientWrapper;

    public CosmosSyncClient(CosmosClientBuilder builder) {
        this.asyncClientWrapper = builder.build();
    }

    public static CosmosClientBuilder builder() {
        return new CosmosClientBuilder();
    }

    public CosmosSyncDatabaseResponse createDatabaseIfNotExists(CosmosDatabaseProperties databaseProperties) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabaseIfNotExists(databaseProperties));
    }

    public CosmosSyncDatabaseResponse createDatabaseIfNotExists(String id) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabaseIfNotExists(id));
    }

    public CosmosSyncDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(databaseProperties, options));
    }

    public CosmosSyncDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(databaseProperties));
    }

    public CosmosSyncDatabaseResponse createDatabase(String id) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(id));
    }

    public CosmosSyncDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, int throughput, CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(databaseProperties, throughput, options));
    }

    public CosmosSyncDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, int throughput) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(databaseProperties, throughput));
    }

    public CosmosSyncDatabaseResponse createDatabase(String id, int throughput) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(id, throughput));
    }

    CosmosSyncDatabaseResponse mapDatabaseResponseAndBlock(Mono<CosmosDatabaseResponse> databaseMono) throws CosmosClientException {
        try {
            return (CosmosSyncDatabaseResponse)databaseMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    public Iterator<FeedResponse<CosmosDatabaseProperties>> readAllDatabases(FeedOptions options) {
        return this.asyncClientWrapper.readAllDatabases(options).toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosDatabaseProperties>> readAllDatabases() {
        return this.asyncClientWrapper.readAllDatabases().toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosDatabaseProperties>> queryDatabases(String query, FeedOptions options) {
        return this.asyncClientWrapper.queryDatabases(query, options).toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosDatabaseProperties>> queryDatabases(SqlQuerySpec querySpec, FeedOptions options) {
        return this.asyncClientWrapper.queryDatabases(querySpec, options).toIterable().iterator();
    }

    public CosmosSyncDatabase getDatabase(String id) {
        return new CosmosSyncDatabase(id, this, this.asyncClientWrapper.getDatabase(id));
    }

    CosmosSyncDatabaseResponse convertResponse(CosmosDatabaseResponse response) {
        return new CosmosSyncDatabaseResponse(response, this);
    }

    CosmosClient asyncClient() {
        return this.asyncClientWrapper;
    }

    @Override
    public void close() {
        this.asyncClientWrapper.close();
    }
}

