/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmos.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.collect.AbstractIterator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

@Deprecated
public class CosmosFailoverAwareRRPolicy
implements LoadBalancingPolicy {
    private final AtomicInteger index = new AtomicInteger();
    private long lastDnsLookupTime = Long.MIN_VALUE;
    private final String globalContactPoint;
    private final int dnsExpirationInSeconds;
    private Map.Entry<CopyOnWriteArrayList<Host>, CopyOnWriteArrayList<Host>> hosts;
    private InetAddress[] localAddresses = null;

    public CosmosFailoverAwareRRPolicy(String globalContactPoint) {
        this(globalContactPoint, 60);
    }

    public CosmosFailoverAwareRRPolicy(String globalContactPoint, int dnsExpirationInSeconds) {
        this.globalContactPoint = globalContactPoint;
        this.dnsExpirationInSeconds = dnsExpirationInSeconds;
    }

    public void init(Cluster cluster, Collection<Host> hosts) {
        CopyOnWriteArrayList<Host> localDcAddresses = new CopyOnWriteArrayList<Host>();
        CopyOnWriteArrayList<Host> remoteDcAddresses = new CopyOnWriteArrayList<Host>();
        List<InetAddress> localAddressesFromLookup = Arrays.asList(this.getLocalAddresses());
        for (Host host : hosts) {
            if (localAddressesFromLookup.contains(host.getAddress())) {
                localDcAddresses.add(host);
                continue;
            }
            remoteDcAddresses.add(host);
        }
        this.hosts = new AbstractMap.SimpleEntry(localDcAddresses, remoteDcAddresses);
        this.index.set(new Random().nextInt(Math.max(hosts.size(), 1)));
    }

    public HostDistance distance(Host host) {
        if (Arrays.asList(this.getLocalAddresses()).contains(host.getAddress())) {
            return HostDistance.LOCAL;
        }
        return HostDistance.REMOTE;
    }

    public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
        Map.Entry<CopyOnWriteArrayList<Host>, CopyOnWriteArrayList<Host>> allHosts = this.getHosts();
        CopyOnWriteArrayList<Host> localHosts = CosmosFailoverAwareRRPolicy.cloneList(allHosts.getKey());
        CopyOnWriteArrayList<Host> remoteHosts = CosmosFailoverAwareRRPolicy.cloneList(allHosts.getValue());
        int startIdx = this.index.getAndIncrement();
        if (startIdx > 2147473647) {
            this.index.set(0);
        }
        return new HostIterator(startIdx, localHosts, remoteHosts);
    }

    public void onUp(Host host) {
        if (Arrays.asList(this.getLocalAddresses()).contains(host.getAddress())) {
            this.hosts.getKey().addIfAbsent(host);
            return;
        }
        this.hosts.getValue().addIfAbsent(host);
    }

    public void onDown(Host host) {
        if (Arrays.asList(this.getLocalAddresses()).contains(host.getAddress())) {
            this.hosts.getKey().remove(host);
            return;
        }
        this.hosts.getValue().remove(host);
    }

    public void onAdd(Host host) {
        this.onUp(host);
    }

    public void onRemove(Host host) {
        this.onDown(host);
    }

    public void close() {
    }

    private static CopyOnWriteArrayList<Host> cloneList(CopyOnWriteArrayList<Host> list) {
        return (CopyOnWriteArrayList)list.clone();
    }

    private InetAddress[] getLocalAddresses() {
        block3: {
            if (this.localAddresses == null || this.dnsExpired()) {
                try {
                    this.localAddresses = InetAddress.getAllByName(this.globalContactPoint);
                    this.lastDnsLookupTime = System.currentTimeMillis() / 1000L;
                }
                catch (UnknownHostException ex) {
                    if (this.localAddresses != null) break block3;
                    throw new IllegalArgumentException("The DNS could not resolve the globalContactPoint the first time.");
                }
            }
        }
        return this.localAddresses;
    }

    private Map.Entry<CopyOnWriteArrayList<Host>, CopyOnWriteArrayList<Host>> getHosts() {
        if (this.hosts != null && !this.dnsExpired()) {
            return this.hosts;
        }
        if (this.hosts == null) {
            throw new IllegalStateException("expected non-null " + CosmosFailoverAwareRRPolicy.class.getName() + ".hosts");
        }
        CopyOnWriteArrayList<Host> oldLocalDcHosts = this.hosts.getKey();
        CopyOnWriteArrayList<Host> newLocalDcHosts = this.hosts.getValue();
        List<InetAddress> localAddresses = Arrays.asList(this.getLocalAddresses());
        CopyOnWriteArrayList<Host> localDcHosts = new CopyOnWriteArrayList<Host>();
        CopyOnWriteArrayList<Host> remoteDcHosts = new CopyOnWriteArrayList<Host>();
        for (Host host : oldLocalDcHosts) {
            if (localAddresses.contains(host.getAddress())) {
                localDcHosts.addIfAbsent(host);
                continue;
            }
            remoteDcHosts.addIfAbsent(host);
        }
        for (Host host : newLocalDcHosts) {
            if (localAddresses.contains(host.getAddress())) {
                localDcHosts.addIfAbsent(host);
                continue;
            }
            remoteDcHosts.addIfAbsent(host);
        }
        this.hosts = new AbstractMap.SimpleEntry(localDcHosts, remoteDcHosts);
        return this.hosts;
    }

    private boolean dnsExpired() {
        return System.currentTimeMillis() / 1000L > this.lastDnsLookupTime + (long)this.dnsExpirationInSeconds;
    }

    private static class HostIterator
    extends AbstractIterator<Host> {
        private final List<? extends Host> localHosts;
        private final List<? extends Host> remoteHosts;
        private int idx;
        private int remainingLocal;
        private int remainingRemote;

        HostIterator(int startIdx, List<? extends Host> localHosts, List<? extends Host> remoteHosts) {
            this.localHosts = localHosts;
            this.remoteHosts = remoteHosts;
            this.idx = startIdx;
            this.remainingLocal = localHosts.size();
            this.remainingRemote = remoteHosts.size();
        }

        protected Host computeNext() {
            if (this.remainingLocal > 0) {
                --this.remainingLocal;
                return this.localHosts.get(this.idx++ % this.localHosts.size());
            }
            if (this.remainingRemote > 0) {
                --this.remainingRemote;
                return this.remoteHosts.get(this.idx++ % this.remoteHosts.size());
            }
            return (Host)this.endOfData();
        }
    }
}

