/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmos.cassandra;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.google.common.collect.AbstractIterator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CosmosLoadBalancingPolicy
implements LoadBalancingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(CosmosLoadBalancingPolicy.class);
    private final int dnsExpirationInSeconds;
    private final String globalEndpoint;
    private final AtomicInteger index;
    private final String readDatacenter;
    private final String writeDatacenter;
    private long lastDnsLookupTime;
    private InetAddress[] localAddresses;
    private CopyOnWriteArrayList<Host> readLocalDCHosts;
    private CopyOnWriteArrayList<Host> remoteDcHosts;
    private CopyOnWriteArrayList<Host> writeLocalDcHosts;

    private CosmosLoadBalancingPolicy(String readDatacenter, String writeDatacenter, String globalEndpoint, int dnsExpirationInSeconds) {
        LOG.debug("globalEndpoint: '{}', readDatacenter: '{}', writeDatacenter: '{}', dnsExpirationInSeconds: '{}'", new Object[]{globalEndpoint, readDatacenter, writeDatacenter, dnsExpirationInSeconds});
        this.globalEndpoint = globalEndpoint;
        this.readDatacenter = readDatacenter;
        this.writeDatacenter = writeDatacenter;
        this.dnsExpirationInSeconds = dnsExpirationInSeconds;
        this.index = new AtomicInteger();
        this.lastDnsLookupTime = Long.MIN_VALUE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void close() {
    }

    public HostDistance distance(Host host) {
        if (!this.writeDatacenter.isEmpty() ? host.getDatacenter().equals(this.writeDatacenter) : Arrays.asList(this.getLocalAddresses()).contains(host.getEndPoint().resolve().getAddress())) {
            return HostDistance.LOCAL;
        }
        return HostDistance.REMOTE;
    }

    public void init(Cluster cluster, Collection<Host> hosts) {
        CopyOnWriteArrayList<Host> readLocalDCAddresses = new CopyOnWriteArrayList<Host>();
        CopyOnWriteArrayList<Host> writeLocalDCAddresses = new CopyOnWriteArrayList<Host>();
        CopyOnWriteArrayList<Host> remoteDCAddresses = new CopyOnWriteArrayList<Host>();
        List dnsLookupAddresses = this.globalEndpoint.isEmpty() ? Collections.emptyList() : Arrays.asList(this.getLocalAddresses());
        for (Host host : hosts) {
            if (!this.readDatacenter.isEmpty() && host.getDatacenter().equals(this.readDatacenter)) {
                readLocalDCAddresses.add(host);
            }
            if (!this.writeDatacenter.isEmpty() && host.getDatacenter().equals(this.writeDatacenter) || dnsLookupAddresses.contains(host.getEndPoint().resolve().getAddress())) {
                writeLocalDCAddresses.add(host);
                continue;
            }
            remoteDCAddresses.add(host);
        }
        this.readLocalDCHosts = readLocalDCAddresses;
        this.writeLocalDcHosts = writeLocalDCAddresses;
        this.remoteDcHosts = remoteDCAddresses;
        this.index.set(new Random().nextInt(Math.max(hosts.size(), 1)));
    }

    public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
        this.refreshHostsIfDnsExpired();
        CopyOnWriteArrayList<Host> readHosts = CosmosLoadBalancingPolicy.cloneList(this.readLocalDCHosts);
        CopyOnWriteArrayList<Host> writeHosts = CosmosLoadBalancingPolicy.cloneList(this.writeLocalDcHosts);
        CopyOnWriteArrayList<Host> remoteHosts = CosmosLoadBalancingPolicy.cloneList(this.remoteDcHosts);
        int startIdx = this.index.getAndIncrement();
        if (startIdx > 2147473647) {
            this.index.set(0);
        }
        return new HostIterator(readHosts, writeHosts, startIdx, remoteHosts, statement);
    }

    public void onAdd(Host host) {
        this.onUp(host);
    }

    public void onDown(Host host) {
        if (host == null || host.getDatacenter() == null) {
            return;
        }
        if (!this.readDatacenter.isEmpty() && host.getDatacenter().equals(this.readDatacenter)) {
            this.readLocalDCHosts.remove(host);
        }
        if (!this.writeDatacenter.isEmpty()) {
            if (host.getDatacenter().equals(this.writeDatacenter)) {
                this.writeLocalDcHosts.remove(host);
            }
        } else if (Arrays.asList(this.getLocalAddresses()).contains(host.getEndPoint().resolve().getAddress())) {
            this.writeLocalDcHosts.remove(host);
        } else {
            this.remoteDcHosts.remove(host);
        }
    }

    public void onRemove(Host host) {
        this.onDown(host);
    }

    public void onUp(Host host) {
        if (host == null || host.getDatacenter() == null) {
            return;
        }
        if (!this.readDatacenter.isEmpty() && host.getDatacenter().equals(this.readDatacenter)) {
            this.readLocalDCHosts.addIfAbsent(host);
        }
        if (!this.writeDatacenter.isEmpty()) {
            if (host.getDatacenter().equals(this.writeDatacenter)) {
                this.writeLocalDcHosts.addIfAbsent(host);
            }
        } else if (Arrays.asList(this.getLocalAddresses()).contains(host.getEndPoint().resolve().getAddress())) {
            this.writeLocalDcHosts.addIfAbsent(host);
        } else {
            this.remoteDcHosts.addIfAbsent(host);
        }
    }

    private InetAddress[] getLocalAddresses() {
        block3: {
            if (this.localAddresses == null || this.dnsExpired()) {
                try {
                    this.localAddresses = InetAddress.getAllByName(this.globalEndpoint);
                    this.lastDnsLookupTime = System.currentTimeMillis() / 1000L;
                }
                catch (UnknownHostException ex) {
                    if (this.localAddresses != null) break block3;
                    throw new IllegalArgumentException("The DNS could not resolve the globalContactPoint the first time.");
                }
            }
        }
        return this.localAddresses;
    }

    private static CosmosLoadBalancingPolicy buildFrom(Builder builder) {
        return new CosmosLoadBalancingPolicy(builder.readDC, builder.writeDC, builder.globalEndpoint, builder.dnsExpirationInSeconds);
    }

    private static CopyOnWriteArrayList<Host> cloneList(CopyOnWriteArrayList<Host> list) {
        return (CopyOnWriteArrayList)list.clone();
    }

    private boolean dnsExpired() {
        return System.currentTimeMillis() / 1000L > this.lastDnsLookupTime + (long)this.dnsExpirationInSeconds;
    }

    private static boolean isReadRequest(String query) {
        return query.toLowerCase(Locale.ROOT).startsWith("select");
    }

    private static boolean isReadRequest(Statement statement) {
        if (statement instanceof RegularStatement) {
            if (statement instanceof SimpleStatement) {
                SimpleStatement simpleStatement = (SimpleStatement)statement;
                return CosmosLoadBalancingPolicy.isReadRequest(simpleStatement.getQueryString());
            }
            if (statement instanceof BuiltStatement) {
                BuiltStatement builtStatement = (BuiltStatement)statement;
                return CosmosLoadBalancingPolicy.isReadRequest(builtStatement.getQueryString());
            }
        } else {
            if (statement instanceof BoundStatement) {
                BoundStatement boundStatement = (BoundStatement)statement;
                return CosmosLoadBalancingPolicy.isReadRequest(boundStatement.preparedStatement().getQueryString());
            }
            if (statement instanceof BatchStatement) {
                return false;
            }
        }
        return false;
    }

    private void refreshHostsIfDnsExpired() {
        if (this.globalEndpoint.isEmpty() || this.writeLocalDcHosts != null && !this.dnsExpired()) {
            return;
        }
        CopyOnWriteArrayList<Host> oldLocalDcHosts = this.writeLocalDcHosts;
        CopyOnWriteArrayList<Host> oldRemoteDcHosts = this.remoteDcHosts;
        List<InetAddress> localAddresses = Arrays.asList(this.getLocalAddresses());
        CopyOnWriteArrayList<Host> localDcHosts = new CopyOnWriteArrayList<Host>();
        CopyOnWriteArrayList<Host> remoteDcHosts = new CopyOnWriteArrayList<Host>();
        if (this.writeLocalDcHosts != null) {
            for (Host host : oldLocalDcHosts) {
                if (localAddresses.contains(host.getEndPoint().resolve().getAddress())) {
                    localDcHosts.addIfAbsent(host);
                    continue;
                }
                remoteDcHosts.addIfAbsent(host);
            }
        }
        for (Host host : oldRemoteDcHosts) {
            if (localAddresses.contains(host.getEndPoint().resolve().getAddress())) {
                localDcHosts.addIfAbsent(host);
                continue;
            }
            remoteDcHosts.addIfAbsent(host);
        }
        this.writeLocalDcHosts = localDcHosts;
        this.remoteDcHosts = remoteDcHosts;
    }

    private static void validate(Builder builder) {
        if (builder.globalEndpoint.isEmpty()) {
            if (builder.writeDC.isEmpty() || builder.readDC.isEmpty()) {
                throw new IllegalArgumentException("When the globalEndpoint is not specified, you need to provide both readDC and writeDC.");
            }
        } else if (!builder.writeDC.isEmpty()) {
            throw new IllegalArgumentException("When the globalEndpoint is specified, you can't provide writeDC. Writes will go to the default write region when the globalEndpoint is specified.");
        }
    }

    private static class HostIterator
    extends AbstractIterator<Host> {
        private final List<? extends Host> readHosts;
        private final List<? extends Host> remoteHosts;
        private final Statement statement;
        private final List<? extends Host> writeHosts;
        private int remainingRead;
        private int remainingWrite;
        private int idx;
        private int remainingRemote;

        HostIterator(List<? extends Host> readHosts, List<? extends Host> writeHosts, int startIdx, List<? extends Host> remoteHosts, Statement statement) {
            this.readHosts = readHosts;
            this.writeHosts = writeHosts;
            this.remoteHosts = remoteHosts;
            this.statement = statement;
            this.remainingRead = readHosts.size();
            this.remainingWrite = writeHosts.size();
            this.idx = startIdx;
            this.remainingRemote = remoteHosts.size();
        }

        protected Host computeNext() {
            boolean readRequest = CosmosLoadBalancingPolicy.isReadRequest(this.statement);
            if (this.remainingRead > 0 && readRequest) {
                --this.remainingRead;
                Host host = this.readHosts.get(this.idx++ % this.readHosts.size());
                LOG.debug("offering host {} for read request in read datacenter", (Object)host);
                return host;
            }
            if (this.remainingWrite > 0) {
                --this.remainingWrite;
                Host host = this.writeHosts.get(this.idx++ % this.writeHosts.size());
                LOG.debug("offering host {} for {} request in write datacenter", (Object)host, (Object)(readRequest ? "read" : "write"));
                return host;
            }
            if (this.remainingRemote > 0) {
                --this.remainingRemote;
                Host host = this.remoteHosts.get(this.idx++ % this.remoteHosts.size());
                LOG.debug("offering host {} for {} request in remote datacenter", (Object)host, (Object)(readRequest ? "read" : "write"));
                return host;
            }
            return (Host)this.endOfData();
        }
    }

    public static class Builder {
        private int dnsExpirationInSeconds = 60;
        private String globalEndpoint = "";
        private String readDC = "";
        private String writeDC = "";

        public CosmosLoadBalancingPolicy build() {
            CosmosLoadBalancingPolicy.validate(this);
            return CosmosLoadBalancingPolicy.buildFrom(this);
        }

        public Builder withDnsExpirationInSeconds(int dnsExpirationInSeconds) {
            this.dnsExpirationInSeconds = dnsExpirationInSeconds;
            return this;
        }

        public Builder withGlobalEndpoint(String globalEndpoint) {
            int index = globalEndpoint.lastIndexOf(58);
            this.globalEndpoint = index == -1 ? globalEndpoint : globalEndpoint.substring(0, index);
            return this;
        }

        public Builder withReadDC(String readDC) {
            this.readDC = readDC;
            return this;
        }

        public Builder withWriteDC(String writeDC) {
            this.writeDC = writeDC;
            return this;
        }
    }
}

