/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmos.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.ConnectionException;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.OverloadedException;
import com.datastax.driver.core.exceptions.WriteFailureException;
import com.datastax.driver.core.policies.RetryPolicy;
import java.util.Random;

public final class CosmosRetryPolicy
implements RetryPolicy {
    private static final Random RANDOM = new Random();
    private final int fixedBackOffTimeMillis;
    private final int growingBackOffTimeMillis;
    private final int maxRetryCount;

    private CosmosRetryPolicy(Builder builder) {
        this.maxRetryCount = builder.maxRetryCount;
        this.fixedBackOffTimeMillis = builder.fixedBackOffTimeInMillis;
        this.growingBackOffTimeMillis = builder.growingBackOffTimeMillis;
    }

    @Deprecated
    public CosmosRetryPolicy(int maxRetryCount) {
        this(maxRetryCount, 5000, 1000);
    }

    @Deprecated
    public CosmosRetryPolicy(int maxRetryCount, int fixedBackOffTimeMillis, int growingBackOffTimeMillis) {
        this.maxRetryCount = maxRetryCount;
        this.fixedBackOffTimeMillis = fixedBackOffTimeMillis;
        this.growingBackOffTimeMillis = growingBackOffTimeMillis;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void close() {
    }

    public void init(Cluster cluster) {
    }

    public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel consistencyLevel, int requiredResponses, int receivedResponses, boolean dataRetrieved, int retryNumber) {
        return this.retryManyTimesOrThrow(retryNumber);
    }

    public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel consistencyLevel, DriverException driverException, int retryNumber) {
        RetryPolicy.RetryDecision retryDecision;
        try {
            if (driverException instanceof ConnectionException) {
                return this.retryManyTimesOrThrow(retryNumber);
            }
            if (driverException instanceof OverloadedException || driverException instanceof WriteFailureException) {
                if (this.maxRetryCount == -1 || retryNumber < this.maxRetryCount) {
                    int retryMillis = CosmosRetryPolicy.getRetryAfterMs(driverException.toString());
                    if (retryMillis == -1) {
                        int growingBackOffSaltMillis = 2000;
                        retryMillis = this.maxRetryCount == -1 ? this.fixedBackOffTimeMillis : this.growingBackOffTimeMillis * retryNumber + RANDOM.nextInt(2000);
                    }
                    Thread.sleep(retryMillis);
                    retryDecision = RetryPolicy.RetryDecision.retry(null);
                } else {
                    retryDecision = RetryPolicy.RetryDecision.rethrow();
                }
            } else {
                retryDecision = RetryPolicy.RetryDecision.rethrow();
            }
        }
        catch (InterruptedException exception) {
            retryDecision = RetryPolicy.RetryDecision.rethrow();
        }
        return retryDecision;
    }

    public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel consistencyLevel, int requiredReplica, int aliveReplica, int retryNumber) {
        return this.retryManyTimesOrThrow(retryNumber);
    }

    public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel consistencyLevel, WriteType writeType, int requiredAcks, int receivedAcks, int retryNumber) {
        return this.retryManyTimesOrThrow(retryNumber);
    }

    private static int getRetryAfterMs(String exceptionString) {
        String[] tokens;
        for (String token : tokens = exceptionString.split(",")) {
            String[] kvp = token.split("=");
            if (kvp.length != 2 || !"RetryAfterMs".equals(kvp[0].trim())) continue;
            String value = kvp[1];
            return Integer.parseInt(value);
        }
        return -1;
    }

    private RetryPolicy.RetryDecision retryManyTimesOrThrow(int retryNumber) {
        return this.maxRetryCount == -1 || retryNumber < this.maxRetryCount ? RetryPolicy.RetryDecision.retry(null) : RetryPolicy.RetryDecision.rethrow();
    }

    public static final class Builder {
        private int fixedBackOffTimeInMillis = 5000;
        private int growingBackOffTimeMillis = 1000;
        private int maxRetryCount = 5;

        public CosmosRetryPolicy build() {
            return new CosmosRetryPolicy(this);
        }

        public Builder withFixedBackOffTimeInMillis(int value) {
            this.fixedBackOffTimeInMillis = value;
            return this;
        }

        public Builder withGrowingBackOffTimeInMillis(int value) {
            this.growingBackOffTimeMillis = value;
            return this;
        }

        public Builder withMaxRetryCount(int value) {
            this.maxRetryCount = value;
            return this;
        }
    }
}

