/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.Helper;
import com.microsoft.azure.documentdb.ResourceType;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

final class AuthorizationHelper {
    AuthorizationHelper() {
    }

    public static String GenerateKeyAuthorizationSignature(String verb, String resourceId, ResourceType resourceType, Map<String, String> headers, String masterKey) {
        if (verb == null || verb.isEmpty()) {
            throw new IllegalArgumentException("verb");
        }
        if (resourceId == null) {
            resourceId = "";
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("resourceType");
        }
        if (headers == null) {
            throw new IllegalArgumentException("headers");
        }
        if (masterKey == null || masterKey.isEmpty()) {
            throw new IllegalArgumentException("masterKey");
        }
        byte[] decodedBytes = Base64.decodeBase64((byte[])masterKey.getBytes());
        SecretKeySpec signingKey = new SecretKeySpec(decodedBytes, "HMACSHA256");
        String text = String.format("%s\n%s\n%s\n", verb, AuthorizationHelper.getResourceSegement(resourceType), resourceId.toLowerCase());
        if (headers.containsKey("x-ms-date")) {
            text = text + headers.get("x-ms-date");
        }
        text = text + '\n';
        if (headers.containsKey("date")) {
            text = text + headers.get("date");
        }
        text = text + '\n';
        String body = text.toLowerCase();
        Mac mac = null;
        try {
            mac = Mac.getInstance("HMACSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to get an instance of HMACSHA256.", e);
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("Failed to initialize the Mac.", e);
        }
        byte[] digest = mac.doFinal(body.getBytes());
        String auth = Helper.encodeBase64String(digest);
        String authtoken = "type=master&ver=1.0&sig=" + auth;
        return authtoken;
    }

    public static String GetAuthorizationTokenUsingResourceTokens(Map<String, String> resourceTokens, String path, String resourceId) {
        if (resourceTokens == null) {
            throw new IllegalArgumentException("resourceTokens");
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("path");
        }
        if (resourceId == null || resourceId.isEmpty()) {
            throw new IllegalArgumentException("resourceId");
        }
        if (resourceTokens.containsKey(resourceId) && resourceTokens.get(resourceId) != null) {
            return resourceTokens.get(resourceId);
        }
        String[] pathParts = path.split("/");
        String[] resourceTypes = new String[]{"dbs", "colls", "docs", "sprocs", "udfs", "triggers", "users", "permissions", "attachments", "media", "conflicts"};
        HashSet<String> resourceTypesSet = new HashSet<String>();
        for (String resourceType : resourceTypes) {
            resourceTypesSet.add(resourceType);
        }
        for (int i = pathParts.length - 1; i >= 0; --i) {
            if (resourceTypesSet.contains(pathParts[i]) || !resourceTokens.containsKey(pathParts[i])) continue;
            return resourceTokens.get(pathParts[i]);
        }
        return null;
    }

    private static String getResourceSegement(ResourceType resourceType) {
        switch (resourceType) {
            case Attachment: {
                return "attachments";
            }
            case Database: {
                return "dbs";
            }
            case Conflict: {
                return "conflicts";
            }
            case Document: {
                return "docs";
            }
            case DocumentCollection: {
                return "colls";
            }
            case Permission: {
                return "permissions";
            }
            case StoredProcedure: {
                return "sprocs";
            }
            case Trigger: {
                return "triggers";
            }
            case UserDefinedFunction: {
                return "udfs";
            }
            case User: {
                return "users";
            }
            case Media: {
                return "media";
            }
            case DatabaseAccount: {
                return "";
            }
        }
        return null;
    }
}

