/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.BackoffRetryUtilityDelegate;
import com.microsoft.azure.documentdb.ResourceThrottleRetryPolicy;

class BackoffRetryUtility {
    BackoffRetryUtility() {
    }

    public static void execute(BackoffRetryUtilityDelegate delegate, ResourceThrottleRetryPolicy retryPolicy) {
        while (true) {
            try {
                delegate.apply();
            }
            catch (Exception e) {
                boolean retry = retryPolicy.shouldRetry(e);
                if (!retry) {
                    e.printStackTrace();
                    throw new IllegalStateException("Exception not retriable", e);
                }
                BackoffRetryUtility.delayForRetry(retryPolicy);
                continue;
            }
            break;
        }
    }

    private static void delayForRetry(ResourceThrottleRetryPolicy retryPolicy) {
        long delay = retryPolicy.getRetryAfterInMilliseconds();
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

