/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.JsonSerializable;
import org.apache.commons.lang3.text.WordUtils;
import org.json.JSONObject;

public final class ConsistencyPolicy
extends JsonSerializable {
    private static final ConsistencyLevel DEFAULT_DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.Session;
    private static final int DEFAULT_MAX_STALENESS_INTERVAL = 5;
    private static final int DEFAULT_MAX_STALENESS_PREFIX = 100;

    ConsistencyPolicy() {
    }

    public ConsistencyPolicy(String jsonString) {
        super(jsonString);
    }

    public ConsistencyPolicy(JSONObject jsonObject) {
        super(jsonObject);
    }

    public ConsistencyLevel getDefaultConsistencyLevel() {
        ConsistencyLevel result = DEFAULT_DEFAULT_CONSISTENCY_LEVEL;
        try {
            result = ConsistencyLevel.valueOf(WordUtils.capitalize((String)super.getString("defaultConsistencyLevel")));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void setDefaultConsistencyLevel(ConsistencyLevel level) {
        super.set("defaultConsistencyLevel", level.name());
    }

    public int getMaxStalenessPrefix() {
        Integer value = super.getInt("maxStalenessPrefix");
        if (value == null) {
            return 100;
        }
        return value;
    }

    public void setMaxStalenessPrefix(int maxStalenessPrefix) {
        super.set("maxStalenessPrefix", maxStalenessPrefix);
    }

    public int getMaxStalenessIntervalInSeconds() {
        Integer value = super.getInt("maxIntervalInSeconds");
        if (value == null) {
            return 5;
        }
        return value;
    }

    public void setMaxStalenessIntervalInSeconds(int maxStalenessIntervalInSeconds) {
        super.set("maxIntervalInSeconds", maxStalenessIntervalInSeconds);
    }

    void Validate() {
    }
}

