/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.ConsistencyPolicy;
import com.microsoft.azure.documentdb.Resource;
import org.json.JSONObject;

public class DatabaseAccount
extends Resource {
    private ConsistencyPolicy consistencyPolicy;
    private long maxMediaStorageUsageInMB;
    private long mediaStorageUsageInMB;
    private long capacityUnitsConsumed;
    private long capacityUnitsProvisioned;
    private long consumedDocumentStorageInMB;
    private long reservedDocumentStorageInMB;
    private long provisionedDocumentStorageInMB;

    DatabaseAccount() {
        this.setSelfLink("");
    }

    public DatabaseAccount(String jsonString) {
        super(jsonString);
    }

    public DatabaseAccount(JSONObject jsonObject) {
        super(jsonObject);
    }

    public String getDatabasesLink() {
        return super.getString("_dbs");
    }

    void setDatabasesLink(String databasesLink) {
        super.set("_dbs", databasesLink);
    }

    public String getMediaLink() {
        return super.getString("media");
    }

    void setMediaLink(String medialink) {
        super.set("media", medialink);
    }

    public String getAddressesLink() {
        return super.getString("addresses");
    }

    void setAddressesLink(String addresseslink) {
        super.set("addresses", addresseslink);
    }

    public long getMaxMediaStorageUsageInMB() {
        return this.maxMediaStorageUsageInMB;
    }

    void setMaxMediaStorageUsageInMB(long value) {
        this.maxMediaStorageUsageInMB = value;
    }

    public long getMediaStorageUsageInMB() {
        return this.mediaStorageUsageInMB;
    }

    void setMediaStorageUsageInMB(long value) {
        this.mediaStorageUsageInMB = value;
    }

    public long getCapacityUnitsConsumed() {
        return this.capacityUnitsConsumed;
    }

    void setCapacityUnitsConsumed(long value) {
        this.capacityUnitsConsumed = value;
    }

    public long getCapacityUnitsProvisioned() {
        return this.capacityUnitsProvisioned;
    }

    void setCapacityUnitsProvisioned(long value) {
        this.capacityUnitsProvisioned = value;
    }

    public long getConsumedDocumentStorageInMB() {
        return this.consumedDocumentStorageInMB;
    }

    void setConsumedDocumentStorageInMB(long value) {
        this.consumedDocumentStorageInMB = value;
    }

    public long getReservedDocumentStorageInMB() {
        return this.reservedDocumentStorageInMB;
    }

    void setReservedDocumentStorageInMB(long value) {
        this.reservedDocumentStorageInMB = value;
    }

    public long getProvisionedDocumentStorageInMB() {
        return this.provisionedDocumentStorageInMB;
    }

    void setProvisionedDocumentStorageInMB(long value) {
        this.provisionedDocumentStorageInMB = value;
    }

    public ConsistencyPolicy getConsistencyPolicy() {
        if (this.consistencyPolicy == null) {
            this.consistencyPolicy = (ConsistencyPolicy)super.getObject("userConsistencyPolicy", ConsistencyPolicy.class);
            if (this.consistencyPolicy == null) {
                this.consistencyPolicy = new ConsistencyPolicy();
            }
        }
        return this.consistencyPolicy;
    }

    @Override
    public void onSave() {
        if (this.consistencyPolicy != null) {
            this.consistencyPolicy.onSave();
            super.set("userConsistencyPolicy", this.consistencyPolicy);
        }
    }
}

