/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.AccessConditionType;
import com.microsoft.azure.documentdb.Attachment;
import com.microsoft.azure.documentdb.Conflict;
import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.Database;
import com.microsoft.azure.documentdb.DatabaseAccount;
import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.DocumentServiceRequest;
import com.microsoft.azure.documentdb.DocumentServiceResponse;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.FeedResponse;
import com.microsoft.azure.documentdb.GatewayProxy;
import com.microsoft.azure.documentdb.JsonSerializable;
import com.microsoft.azure.documentdb.MediaOptions;
import com.microsoft.azure.documentdb.MediaReadMode;
import com.microsoft.azure.documentdb.MediaResponse;
import com.microsoft.azure.documentdb.Permission;
import com.microsoft.azure.documentdb.QueryIterable;
import com.microsoft.azure.documentdb.ReadType;
import com.microsoft.azure.documentdb.RequestOptions;
import com.microsoft.azure.documentdb.ResourceId;
import com.microsoft.azure.documentdb.ResourceResponse;
import com.microsoft.azure.documentdb.ResourceType;
import com.microsoft.azure.documentdb.RetryPolicy;
import com.microsoft.azure.documentdb.SessionContainer;
import com.microsoft.azure.documentdb.StoredProcedure;
import com.microsoft.azure.documentdb.StoredProcedureResponse;
import com.microsoft.azure.documentdb.Trigger;
import com.microsoft.azure.documentdb.User;
import com.microsoft.azure.documentdb.UserDefinedFunction;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONObject;

public final class DocumentClient {
    private URI serviceEndpoint;
    private String masterKey;
    private Map<String, String> resourceTokens;
    private ConnectionPolicy connectionPolicy;
    private GatewayProxy gatewayProxy;
    private SessionContainer sessionContainer;
    private ConsistencyLevel desiredConsistencyLevel;
    private RetryPolicy retryPolicy;

    public DocumentClient(String serviceEndpoint, String masterKey, ConnectionPolicy connectionPolicy, ConsistencyLevel desiredConsistencyLevel) {
        URI uri = null;
        try {
            uri = new URI(serviceEndpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid serviceEndPoint.", e);
        }
        this.masterKey = masterKey;
        this.initialize(uri, connectionPolicy, desiredConsistencyLevel);
    }

    public DocumentClient(String serviceEndpoint, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel desiredConsistencyLevel) {
        URI uri = null;
        try {
            uri = new URI(serviceEndpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid serviceEndPoint.", e);
        }
        this.resourceTokens = new HashMap<String, String>();
        for (Permission permission : permissionFeed) {
            String[] segments = permission.getResourceLink().split("/");
            if (segments.length <= 0) {
                throw new IllegalArgumentException("link");
            }
            String resourceId = segments[segments.length - 1];
            this.resourceTokens.put(resourceId, permission.getToken());
        }
        this.initialize(uri, connectionPolicy, desiredConsistencyLevel);
    }

    private void initialize(URI serviceEndpoint, ConnectionPolicy connectionPolicy, ConsistencyLevel desiredConsistencyLevel) {
        this.serviceEndpoint = serviceEndpoint;
        this.connectionPolicy = connectionPolicy != null ? connectionPolicy : new ConnectionPolicy();
        this.retryPolicy = RetryPolicy.getDefault();
        this.sessionContainer = new SessionContainer(this.serviceEndpoint.getHost());
        this.desiredConsistencyLevel = desiredConsistencyLevel;
        this.gatewayProxy = new GatewayProxy(this.serviceEndpoint, this.connectionPolicy, desiredConsistencyLevel, this.masterKey, this.resourceTokens);
    }

    RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public ResourceResponse<Database> createDatabase(Database database, RequestOptions options) throws DocumentClientException {
        if (database == null) {
            throw new IllegalArgumentException("Database");
        }
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Database, "/dbs", database, requestHeaders);
        return new ResourceResponse<Database>(this.doCreate(request), Database.class);
    }

    public ResourceResponse<Database> replaceDatabase(Database database, RequestOptions options) throws DocumentClientException {
        if (database == null) {
            throw new IllegalArgumentException("Database");
        }
        String path = DocumentClient.joinPath(database.getSelfLink(), null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Database, path, database, requestHeaders);
        return new ResourceResponse<Database>(this.doReplace(request), Database.class);
    }

    public ResourceResponse<Database> deleteDatabase(String databaseLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        String path = DocumentClient.joinPath(databaseLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Database, path, requestHeaders);
        return new ResourceResponse<Database>(this.doDelete(request), Database.class);
    }

    public ResourceResponse<Database> readDatabase(String databaseLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        String path = DocumentClient.joinPath(databaseLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Database, path, requestHeaders);
        return new ResourceResponse<Database>(this.doRead(request), Database.class);
    }

    public FeedResponse<Database> readDatabases(FeedOptions options) {
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Database, "/dbs", requestHeaders);
        return new FeedResponse<Database>(new QueryIterable<Database>(this, request, ReadType.Feed, Database.class));
    }

    public FeedResponse<Database> queryDatabases(String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Database, "/dbs", query, requestHeaders);
        return new FeedResponse<Database>(new QueryIterable<Database>(this, request, ReadType.Query, Database.class));
    }

    public ResourceResponse<DocumentCollection> createCollection(String databaseLink, DocumentCollection collection, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (collection == null) {
            throw new IllegalArgumentException("collection");
        }
        String path = DocumentClient.joinPath(databaseLink, "colls");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.DocumentCollection, path, collection, requestHeaders);
        return new ResourceResponse<DocumentCollection>(this.doCreate(request), DocumentCollection.class);
    }

    public ResourceResponse<DocumentCollection> deleteCollection(String collectionLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        String path = DocumentClient.joinPath(collectionLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.DocumentCollection, path, requestHeaders);
        return new ResourceResponse<DocumentCollection>(this.doDelete(request), DocumentCollection.class);
    }

    public ResourceResponse<DocumentCollection> readCollection(String collectionLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        String path = DocumentClient.joinPath(collectionLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.DocumentCollection, path, requestHeaders);
        return new ResourceResponse<DocumentCollection>(this.doRead(request), DocumentCollection.class);
    }

    public FeedResponse<DocumentCollection> readCollections(String databaseLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        String path = DocumentClient.joinPath(databaseLink, "colls");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.DocumentCollection, path, requestHeaders);
        return new FeedResponse<DocumentCollection>(new QueryIterable<DocumentCollection>(this, request, ReadType.Feed, DocumentCollection.class));
    }

    public FeedResponse<DocumentCollection> queryCollections(String databaseLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        String path = DocumentClient.joinPath(databaseLink, "colls");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.DocumentCollection, path, query, requestHeaders);
        return new FeedResponse<DocumentCollection>(new QueryIterable<DocumentCollection>(this, request, ReadType.Query, DocumentCollection.class));
    }

    public ResourceResponse<Document> createDocument(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        Document typedDocument = Document.FromObject(document);
        if (typedDocument.getId() == null && !disableAutomaticIdGeneration) {
            typedDocument.setId(UUID.randomUUID().toString());
        }
        String path = DocumentClient.joinPath(collectionLink, "docs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Document, path, typedDocument, requestHeaders);
        return new ResourceResponse<Document>(this.doCreate(request), Document.class);
    }

    public ResourceResponse<Document> replaceDocument(String documentLink, Object document, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        String path = DocumentClient.joinPath(documentLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        Document typedDocument = Document.FromObject(document);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Document, path, typedDocument, requestHeaders);
        return new ResourceResponse<Document>(this.doReplace(request), Document.class);
    }

    public ResourceResponse<Document> replaceDocument(Document document, RequestOptions options) throws DocumentClientException {
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        String path = DocumentClient.joinPath(document.getSelfLink(), null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Document, path, document, requestHeaders);
        return new ResourceResponse<Document>(this.doReplace(request), Document.class);
    }

    public ResourceResponse<Document> deleteDocument(String documentLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        String path = DocumentClient.joinPath(documentLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Document, path, requestHeaders);
        return new ResourceResponse<Document>(this.doDelete(request), Document.class);
    }

    public ResourceResponse<Document> readDocument(String documentLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        String path = DocumentClient.joinPath(documentLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Document, path, requestHeaders);
        return new ResourceResponse<Document>(this.doRead(request), Document.class);
    }

    public FeedResponse<Document> readDocuments(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        String path = DocumentClient.joinPath(collectionLink, "docs");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Document, path, requestHeaders);
        return new FeedResponse<Document>(new QueryIterable<Document>(this, request, ReadType.Feed, Document.class));
    }

    public FeedResponse<Document> queryDocuments(String collectionLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        String path = DocumentClient.joinPath(collectionLink, "docs");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Document, path, query, requestHeaders);
        return new FeedResponse<Document>(new QueryIterable<Document>(this, request, ReadType.Query, Document.class));
    }

    public ResourceResponse<StoredProcedure> createStoredProcedure(String collectionLink, StoredProcedure storedProcedure, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (storedProcedure == null) {
            throw new IllegalArgumentException("storedProcedure");
        }
        String path = DocumentClient.joinPath(collectionLink, "sprocs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.StoredProcedure, path, storedProcedure, requestHeaders);
        return new ResourceResponse<StoredProcedure>(this.doCreate(request), StoredProcedure.class);
    }

    public ResourceResponse<StoredProcedure> replaceStoredProcedure(StoredProcedure storedProcedure, RequestOptions options) throws DocumentClientException {
        if (storedProcedure == null) {
            throw new IllegalArgumentException("storedProcedure");
        }
        String path = DocumentClient.joinPath(storedProcedure.getSelfLink(), null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.StoredProcedure, path, storedProcedure, requestHeaders);
        return new ResourceResponse<StoredProcedure>(this.doReplace(request), StoredProcedure.class);
    }

    public ResourceResponse<StoredProcedure> deleteStoredProcedure(String storedProcedureLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)storedProcedureLink)) {
            throw new IllegalArgumentException("storedProcedureLink");
        }
        String path = DocumentClient.joinPath(storedProcedureLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.StoredProcedure, path, requestHeaders);
        return new ResourceResponse<StoredProcedure>(this.doDelete(request), StoredProcedure.class);
    }

    public ResourceResponse<StoredProcedure> readStoredProcedure(String storedProcedureLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)storedProcedureLink)) {
            throw new IllegalArgumentException("storedProcedureLink");
        }
        String path = DocumentClient.joinPath(storedProcedureLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.StoredProcedure, path, requestHeaders);
        return new ResourceResponse<StoredProcedure>(this.doRead(request), StoredProcedure.class);
    }

    public FeedResponse<StoredProcedure> readStoredProcedures(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        String path = DocumentClient.joinPath(collectionLink, "sprocs");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.StoredProcedure, path, requestHeaders);
        return new FeedResponse<StoredProcedure>(new QueryIterable<StoredProcedure>(this, request, ReadType.Feed, StoredProcedure.class));
    }

    public FeedResponse<StoredProcedure> queryStoredProcedures(String collectionLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        String path = DocumentClient.joinPath(collectionLink, "sprocs");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.StoredProcedure, path, query, requestHeaders);
        return new FeedResponse<StoredProcedure>(new QueryIterable<StoredProcedure>(this, request, ReadType.Query, StoredProcedure.class));
    }

    public StoredProcedureResponse executeStoredProcedure(String storedProcedureLink, Object[] procedureParams) throws DocumentClientException {
        String path = DocumentClient.joinPath(storedProcedureLink, null);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Accept", "application/json");
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.StoredProcedure, path, procedureParams != null ? DocumentClient.serializeProcedureParams(procedureParams) : "", null);
        return new StoredProcedureResponse(this.doCreate(request));
    }

    public ResourceResponse<Trigger> createTrigger(String collectionLink, Trigger trigger, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (trigger == null) {
            throw new IllegalArgumentException("trigger");
        }
        String path = DocumentClient.joinPath(collectionLink, "triggers");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Trigger, path, trigger, requestHeaders);
        return new ResourceResponse<Trigger>(this.doCreate(request), Trigger.class);
    }

    public ResourceResponse<Trigger> replaceTrigger(Trigger trigger, RequestOptions options) throws DocumentClientException {
        if (trigger == null) {
            throw new IllegalArgumentException("trigger");
        }
        String path = DocumentClient.joinPath(trigger.getSelfLink(), null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Trigger, path, trigger, requestHeaders);
        return new ResourceResponse<Trigger>(this.doReplace(request), Trigger.class);
    }

    public ResourceResponse<Trigger> deleteTrigger(String triggerLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)triggerLink)) {
            throw new IllegalArgumentException("triggerLink");
        }
        String path = DocumentClient.joinPath(triggerLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Trigger, path, requestHeaders);
        return new ResourceResponse<Trigger>(this.doDelete(request), Trigger.class);
    }

    public ResourceResponse<Trigger> readTrigger(String triggerLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)triggerLink)) {
            throw new IllegalArgumentException("triggerLink");
        }
        String path = DocumentClient.joinPath(triggerLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Trigger, path, requestHeaders);
        return new ResourceResponse<Trigger>(this.gatewayProxy.doRead(request), Trigger.class);
    }

    public FeedResponse<Trigger> readTriggers(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        String path = DocumentClient.joinPath(collectionLink, "triggers");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Trigger, path, requestHeaders);
        return new FeedResponse<Trigger>(new QueryIterable<Trigger>(this, request, ReadType.Feed, Trigger.class));
    }

    public FeedResponse<Trigger> queryTriggers(String collectionLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        String path = DocumentClient.joinPath(collectionLink, "triggers");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Trigger, path, query, requestHeaders);
        return new FeedResponse<Trigger>(new QueryIterable<Trigger>(this, request, ReadType.Query, Trigger.class));
    }

    public ResourceResponse<UserDefinedFunction> createUserDefinedFunction(String collectionLink, UserDefinedFunction udf, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (udf == null) {
            throw new IllegalArgumentException("udf");
        }
        String path = DocumentClient.joinPath(collectionLink, "udfs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.UserDefinedFunction, path, udf, requestHeaders);
        return new ResourceResponse<UserDefinedFunction>(this.doCreate(request), UserDefinedFunction.class);
    }

    public ResourceResponse<UserDefinedFunction> replaceUserDefinedFunction(UserDefinedFunction udf, RequestOptions options) throws DocumentClientException {
        if (udf == null) {
            throw new IllegalArgumentException("udf");
        }
        String path = DocumentClient.joinPath(udf.getSelfLink(), null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.UserDefinedFunction, path, udf, requestHeaders);
        return new ResourceResponse<UserDefinedFunction>(this.doReplace(request), UserDefinedFunction.class);
    }

    public ResourceResponse<UserDefinedFunction> deleteUserDefinedFunction(String udfLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)udfLink)) {
            throw new IllegalArgumentException("udfLink");
        }
        String path = DocumentClient.joinPath(udfLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.UserDefinedFunction, path, requestHeaders);
        return new ResourceResponse<UserDefinedFunction>(this.doDelete(request), UserDefinedFunction.class);
    }

    public ResourceResponse<UserDefinedFunction> readUserDefinedFunction(String udfLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)udfLink)) {
            throw new IllegalArgumentException("udfLink");
        }
        String path = DocumentClient.joinPath(udfLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.UserDefinedFunction, path, requestHeaders);
        return new ResourceResponse<UserDefinedFunction>(this.doRead(request), UserDefinedFunction.class);
    }

    public FeedResponse<UserDefinedFunction> readUserDefinedFunctions(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        String path = DocumentClient.joinPath(collectionLink, "udfs");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.UserDefinedFunction, path, requestHeaders);
        return new FeedResponse<UserDefinedFunction>(new QueryIterable<UserDefinedFunction>(this, request, ReadType.Feed, UserDefinedFunction.class));
    }

    public FeedResponse<UserDefinedFunction> queryUserDefinedFunctions(String collectionLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        String path = DocumentClient.joinPath(collectionLink, "udfs");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.UserDefinedFunction, path, query, requestHeaders);
        return new FeedResponse<UserDefinedFunction>(new QueryIterable<UserDefinedFunction>(this, request, ReadType.Query, UserDefinedFunction.class));
    }

    public ResourceResponse<Attachment> createAttachment(String documentLink, Attachment attachment, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        if (attachment == null) {
            throw new IllegalArgumentException("attachment");
        }
        String path = DocumentClient.joinPath(documentLink, "attachments");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Attachment, path, attachment, requestHeaders);
        return new ResourceResponse<Attachment>(this.doCreate(request), Attachment.class);
    }

    public ResourceResponse<Attachment> replaceAttachment(Attachment attachment, RequestOptions options) throws DocumentClientException {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment");
        }
        String path = DocumentClient.joinPath(attachment.getSelfLink(), null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Attachment, path, attachment, requestHeaders);
        return new ResourceResponse<Attachment>(this.doReplace(request), Attachment.class);
    }

    public ResourceResponse<Attachment> deleteAttachment(String attachmentLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)attachmentLink)) {
            throw new IllegalArgumentException("attachmentLink");
        }
        String path = DocumentClient.joinPath(attachmentLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Attachment, path, requestHeaders);
        return new ResourceResponse<Attachment>(this.doDelete(request), Attachment.class);
    }

    public ResourceResponse<Attachment> readAttachment(String attachmentLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)attachmentLink)) {
            throw new IllegalArgumentException("attachmentLink");
        }
        String path = DocumentClient.joinPath(attachmentLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Attachment, path, requestHeaders);
        return new ResourceResponse<Attachment>(this.doRead(request), Attachment.class);
    }

    public FeedResponse<Attachment> readAttachments(String documentLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        String path = DocumentClient.joinPath(documentLink, "attachments");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Attachment, path, requestHeaders);
        return new FeedResponse<Attachment>(new QueryIterable<Attachment>(this, request, ReadType.Feed, Attachment.class));
    }

    public FeedResponse<Attachment> queryAttachments(String documentLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        String path = DocumentClient.joinPath(documentLink, "attachments");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Attachment, path, query, requestHeaders);
        return new FeedResponse<Attachment>(new QueryIterable<Attachment>(this, request, ReadType.Query, Attachment.class));
    }

    public ResourceResponse<Attachment> createAttachment(String documentLink, InputStream mediaStream, MediaOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        if (mediaStream == null) {
            throw new IllegalArgumentException("mediaStream");
        }
        String path = DocumentClient.joinPath(documentLink, "attachments");
        Map<String, String> requestHeaders = this.getMediaHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Attachment, path, mediaStream, requestHeaders);
        request.setIsMedia(true);
        return new ResourceResponse<Attachment>(this.doCreate(request), Attachment.class);
    }

    public MediaResponse readMedia(String mediaLink) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)mediaLink)) {
            throw new IllegalArgumentException("mediaLink");
        }
        String path = DocumentClient.joinPath(mediaLink, null);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Media, path, null);
        request.setIsMedia(true);
        return new MediaResponse(this.doRead(request), this.connectionPolicy.getMediaReadMode() == MediaReadMode.Buffered);
    }

    public MediaResponse updateMedia(String mediaLink, InputStream mediaStream, MediaOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)mediaLink)) {
            throw new IllegalArgumentException("mediaLink");
        }
        if (mediaStream == null) {
            throw new IllegalArgumentException("mediaStream");
        }
        String path = DocumentClient.joinPath(mediaLink, null);
        Map<String, String> requestHeaders = this.getMediaHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Media, path, mediaStream, requestHeaders);
        request.setIsMedia(true);
        return new MediaResponse(this.doReplace(request), this.connectionPolicy.getMediaReadMode() == MediaReadMode.Buffered);
    }

    public ResourceResponse<Conflict> readConflict(String conflictLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)conflictLink)) {
            throw new IllegalArgumentException("conflictLink");
        }
        String path = DocumentClient.joinPath(conflictLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Conflict, path, requestHeaders);
        return new ResourceResponse<Conflict>(this.doRead(request), Conflict.class);
    }

    public FeedResponse<Conflict> readConflicts(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        String path = DocumentClient.joinPath(collectionLink, "conflicts");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Conflict, path, requestHeaders);
        return new FeedResponse<Conflict>(new QueryIterable<Conflict>(this, request, ReadType.Feed, Conflict.class));
    }

    public ResourceResponse<Conflict> deleteConflict(String conflictLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)conflictLink)) {
            throw new IllegalArgumentException("conflictLink");
        }
        String path = DocumentClient.joinPath(conflictLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Conflict, path, requestHeaders);
        return new ResourceResponse<Conflict>(this.doDelete(request), Conflict.class);
    }

    public ResourceResponse<User> createUser(String databaseLink, User user, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (user == null) {
            throw new IllegalArgumentException("user");
        }
        String path = DocumentClient.joinPath(databaseLink, "users");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.User, path, user, requestHeaders);
        return new ResourceResponse<User>(this.doCreate(request), User.class);
    }

    public ResourceResponse<User> replaceUser(User user, RequestOptions options) throws DocumentClientException {
        if (user == null) {
            throw new IllegalArgumentException("user");
        }
        String path = DocumentClient.joinPath(user.getSelfLink(), null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.User, path, user, requestHeaders);
        return new ResourceResponse<User>(this.doReplace(request), User.class);
    }

    public ResourceResponse<User> deleteUser(String userLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        String path = DocumentClient.joinPath(userLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.User, path, requestHeaders);
        return new ResourceResponse<User>(this.doDelete(request), User.class);
    }

    public ResourceResponse<User> readUser(String userLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        String path = DocumentClient.joinPath(userLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.User, path, requestHeaders);
        return new ResourceResponse<User>(this.doRead(request), User.class);
    }

    public FeedResponse<User> readUsers(String databaseLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        String path = DocumentClient.joinPath(databaseLink, "users");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.User, path, requestHeaders);
        return new FeedResponse<User>(new QueryIterable<User>(this, request, ReadType.Feed, User.class));
    }

    public FeedResponse<User> queryUsers(String databaseLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        String path = DocumentClient.joinPath(databaseLink, "users");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.User, path, query, requestHeaders);
        return new FeedResponse<User>(new QueryIterable<User>(this, request, ReadType.Query, User.class));
    }

    public ResourceResponse<Permission> createPermission(String userLink, Permission permission, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        if (permission == null) {
            throw new IllegalArgumentException("permission");
        }
        String path = DocumentClient.joinPath(userLink, "permissions");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Permission, path, permission, requestHeaders);
        return new ResourceResponse<Permission>(this.doCreate(request), Permission.class);
    }

    public ResourceResponse<Permission> replacePermission(Permission permission, RequestOptions options) throws DocumentClientException {
        if (permission == null) {
            throw new IllegalArgumentException("permission");
        }
        String path = DocumentClient.joinPath(permission.getSelfLink(), null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Permission, path, permission, requestHeaders);
        return new ResourceResponse<Permission>(this.doReplace(request), Permission.class);
    }

    public ResourceResponse<Permission> deletePermission(String permissionLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)permissionLink)) {
            throw new IllegalArgumentException("permissionLink");
        }
        String path = DocumentClient.joinPath(permissionLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Permission, path, requestHeaders);
        return new ResourceResponse<Permission>(this.doDelete(request), Permission.class);
    }

    public ResourceResponse<Permission> readPermission(String permissionLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)permissionLink)) {
            throw new IllegalArgumentException("permissionLink");
        }
        String path = DocumentClient.joinPath(permissionLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Permission, path, requestHeaders);
        return new ResourceResponse<Permission>(this.doRead(request), Permission.class);
    }

    public FeedResponse<Permission> readPermissions(String permissionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)permissionLink)) {
            throw new IllegalArgumentException("permissionLink");
        }
        String path = DocumentClient.joinPath(permissionLink, "permissions");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Permission, path, requestHeaders);
        return new FeedResponse<Permission>(new QueryIterable<Permission>(this, request, ReadType.Feed, Permission.class));
    }

    public FeedResponse<Permission> queryPermissions(String permissionLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)permissionLink)) {
            throw new IllegalArgumentException("permissionLink");
        }
        String path = DocumentClient.joinPath(permissionLink, "permissions");
        Map<String, String> requestHeaders = this.getFeedHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Permission, path, query, requestHeaders);
        return new FeedResponse<Permission>(new QueryIterable<Permission>(this, request, ReadType.Query, Permission.class));
    }

    public DatabaseAccount getDatabaseAccount() throws DocumentClientException {
        DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.DatabaseAccount, "", null);
        DocumentServiceResponse response = this.doRead(request);
        DatabaseAccount account = response.getResource(DatabaseAccount.class);
        Map<String, String> responseHeader = response.getResponseHeaders();
        account.setCapacityUnitsConsumed(Long.valueOf(responseHeader.get("x-ms-database-capacity-units-consumed")));
        account.setCapacityUnitsProvisioned(Long.valueOf(responseHeader.get("x-ms-database-capacity-units-provisioned")));
        account.setMaxMediaStorageUsageInMB(Long.valueOf(responseHeader.get("x-ms-max-media-storage-usage-mb")));
        account.setMediaStorageUsageInMB(Long.valueOf(responseHeader.get("x-ms-media-storage-usage-mb")));
        account.setConsumedDocumentStorageInMB(Long.valueOf(responseHeader.get("x-ms-databaseaccount-consumed-mb")));
        account.setReservedDocumentStorageInMB(Long.valueOf(responseHeader.get("x-ms-databaseaccount-reserved-mb")));
        account.setProvisionedDocumentStorageInMB(Long.valueOf(responseHeader.get("x-ms-databaseaccount-provisioned-mb")));
        return account;
    }

    private DocumentServiceResponse doCreate(DocumentServiceRequest request) throws DocumentClientException {
        this.ApplySessionToken(request);
        DocumentServiceResponse response = this.gatewayProxy.doCreate(request);
        this.CaptureSessionToken(request, response);
        return response;
    }

    private DocumentServiceResponse doReplace(DocumentServiceRequest request) throws DocumentClientException {
        this.ApplySessionToken(request);
        DocumentServiceResponse response = this.gatewayProxy.doReplace(request);
        this.CaptureSessionToken(request, response);
        return response;
    }

    private DocumentServiceResponse doDelete(DocumentServiceRequest request) throws DocumentClientException {
        this.ApplySessionToken(request);
        DocumentServiceResponse response = this.gatewayProxy.doDelete(request);
        if (request.getResourceType() != ResourceType.DocumentCollection) {
            this.CaptureSessionToken(request, response);
        } else {
            this.ClearToken(ResourceId.parse(request.getResourceId()));
        }
        return response;
    }

    private DocumentServiceResponse doRead(DocumentServiceRequest request) throws DocumentClientException {
        this.ApplySessionToken(request);
        DocumentServiceResponse response = this.gatewayProxy.doRead(request);
        this.CaptureSessionToken(request, response);
        return response;
    }

    DocumentServiceResponse doReadFeed(DocumentServiceRequest request) throws DocumentClientException {
        this.ApplySessionToken(request);
        DocumentServiceResponse response = this.gatewayProxy.doReadFeed(request);
        this.CaptureSessionToken(request, response);
        return response;
    }

    DocumentServiceResponse doQuery(DocumentServiceRequest request) throws DocumentClientException {
        this.ApplySessionToken(request);
        DocumentServiceResponse response = this.gatewayProxy.doSQLQuery(request);
        this.CaptureSessionToken(request, response);
        return response;
    }

    private void ApplySessionToken(DocumentServiceRequest request) throws DocumentClientException {
        String sessionToken;
        Map<String, String> headers = request.getHeaders();
        if (headers != null && !StringUtils.isEmpty((CharSequence)headers.get("x-ms-session-token"))) {
            return;
        }
        if (this.desiredConsistencyLevel != ConsistencyLevel.Session) {
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)request.getResourceId()) && !StringUtils.isEmpty((CharSequence)(sessionToken = this.sessionContainer.resolveSessionToken(ResourceId.parse(request.getResourceId()))))) {
            headers.put("x-ms-session-token", sessionToken);
        }
    }

    private void CaptureSessionToken(DocumentServiceRequest request, DocumentServiceResponse response) throws DocumentClientException {
        String sessionToken = response.getResponseHeaders().get("x-ms-session-token");
        if (!StringUtils.isEmpty((CharSequence)sessionToken) && !StringUtils.isEmpty((CharSequence)request.getResourceId())) {
            this.sessionContainer.setSessionToken(ResourceId.parse(request.getResourceId()), sessionToken);
        }
    }

    private void ClearToken(ResourceId resourceId) {
        this.sessionContainer.clearToken(resourceId);
    }

    private Map<String, String> getRequestHeaders(RequestOptions options) {
        if (options == null) {
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (options.getAccessCondition() != null) {
            if (options.getAccessCondition().getType() == AccessConditionType.IfMatch) {
                headers.put("If-Match", options.getAccessCondition().getCondition());
            } else {
                headers.put("If-None-Match", options.getAccessCondition().getCondition());
            }
        }
        if (options.getConsistencyLevel() != null) {
            headers.put("x-ms-consistency-level", options.getConsistencyLevel().name());
        }
        if (options.getIndexingDirective() != null) {
            headers.put("x-ms-indexing-directive", options.getIndexingDirective().name());
        }
        if (options.getPostTriggerInclude() != null && options.getPostTriggerInclude().size() > 0) {
            String postTriggerInclude = StringUtils.join(options.getPostTriggerInclude(), (String)",");
            headers.put("x-ms-documentdb-post-trigger-include", postTriggerInclude);
        }
        if (options.getPreTriggerInclude() != null && options.getPreTriggerInclude().size() > 0) {
            String preTriggerInclude = StringUtils.join(options.getPreTriggerInclude(), (String)",");
            headers.put("x-ms-documentdb-pre-trigger-include", preTriggerInclude);
        }
        if (options.getSessionToken() != null && !options.getSessionToken().isEmpty()) {
            headers.put("x-ms-session-token", options.getSessionToken());
        }
        if (options.getResourceTokenExpirySeconds() != null) {
            headers.put("x-ms-documentdb-expiry-seconds", String.valueOf(options.getResourceTokenExpirySeconds()));
        }
        return headers;
    }

    private Map<String, String> getFeedHeaders(FeedOptions options) {
        if (options == null) {
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (options.getPageSize() != null) {
            headers.put("x-ms-max-item-count", options.getPageSize().toString());
        }
        if (options.getRequestContinuation() != null) {
            headers.put("x-ms-continuation", options.getRequestContinuation());
        }
        if (options.getSessionToken() != null) {
            headers.put("x-ms-session-token", options.getSessionToken());
        }
        if (options.getEnableScanInQuery() != null) {
            headers.put("x-ms-documentdb-query-enable-scan", options.getEnableScanInQuery().toString());
        }
        if (options.getEmitVerboseTracesInQuery() != null) {
            headers.put("x-ms-documentdb-query-emit-traces", options.getEmitVerboseTracesInQuery().toString());
        }
        return headers;
    }

    private Map<String, String> getMediaHeaders(MediaOptions options) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (options == null || options.getContentType().isEmpty()) {
            requestHeaders.put("Content-Type", "application/octet-stream");
        }
        if (options != null) {
            if (!options.getContentType().isEmpty()) {
                requestHeaders.put("Content-Type", options.getContentType());
            }
            if (!options.getSlug().isEmpty()) {
                requestHeaders.put("Slug", options.getSlug());
            }
        }
        return requestHeaders;
    }

    private static String joinPath(String path1, String path2) {
        path1 = DocumentClient.trimBeginingAndEndingSlashes(path1);
        String result = "/" + path1 + "/";
        if (path2 != null && !path2.isEmpty()) {
            path2 = DocumentClient.trimBeginingAndEndingSlashes(path2);
            result = result + path2 + "/";
        }
        return result;
    }

    private static String trimBeginingAndEndingSlashes(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static String serializeProcedureParams(Object[] objectArray) {
        ObjectMapper mapper = null;
        Object[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof JsonSerializable || object instanceof JSONObject) {
                stringArray[i] = object.toString();
                continue;
            }
            if (mapper == null) {
                mapper = new ObjectMapper();
            }
            try {
                stringArray[i] = mapper.writeValueAsString(object);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
        return String.format("[%s]", StringUtils.join((Object[])stringArray, (String)","));
    }
}

