/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.Error;
import java.util.Map;

public class DocumentClientException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Error error;
    private int statusCode;
    private Map<String, String> responseHeaders;

    public DocumentClientException(int statusCode, Error errorResource, Map<String, String> responseHeaders) {
        super(errorResource.getMessage());
        this.statusCode = statusCode;
        this.error = errorResource;
        this.responseHeaders = responseHeaders;
    }

    public String getActivityId() {
        if (this.responseHeaders != null) {
            return this.responseHeaders.get("x-ms-activity-id");
        }
        return null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Error getError() {
        return this.error;
    }

    public long getRetryAfterInMilliseconds() {
        String header;
        if (this.responseHeaders != null && !(header = this.responseHeaders.get("x-ms-retry-after-ms")).isEmpty()) {
            long retryIntervalInMilliseconds = Long.valueOf(header);
            return retryIntervalInMilliseconds;
        }
        return 0L;
    }
}

