/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.IndexingPolicy;
import com.microsoft.azure.documentdb.Resource;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public final class DocumentCollection
extends Resource {
    private IndexingPolicy indexingPolicy = null;

    public DocumentCollection() {
    }

    public DocumentCollection(String jsonString) {
        super(jsonString);
    }

    public DocumentCollection(JSONObject jsonObject) {
        super(jsonObject);
    }

    public void setIndexingPolicy(IndexingPolicy indexingPolicy) {
        this.indexingPolicy = indexingPolicy;
    }

    public IndexingPolicy getIndexingPolicy() {
        if (this.indexingPolicy == null) {
            this.indexingPolicy = super.has("indexingPolicy") ? (IndexingPolicy)super.getObject("indexingPolicy", IndexingPolicy.class) : new IndexingPolicy();
        }
        return this.indexingPolicy;
    }

    public String getDocumentsLink() {
        return String.format("%s/%s", StringUtils.stripEnd((String)super.getSelfLink(), (String)"/"), super.getString("_docs"));
    }

    public String getStoredProceduresLink() {
        return String.format("%s/%s", StringUtils.stripEnd((String)super.getSelfLink(), (String)"/"), super.getString("_sprocs"));
    }

    public String getTriggersLink() {
        return StringUtils.removeEnd((String)this.getSelfLink(), (String)"/") + "/" + super.getString("_triggers");
    }

    public String getUserDefinedFunctionsLink() {
        return StringUtils.removeEnd((String)this.getSelfLink(), (String)"/") + "/" + super.getString("_udfs");
    }

    public String getConflictsLink() {
        return StringUtils.removeEnd((String)this.getSelfLink(), (String)"/") + "/" + super.getString("_conflicts");
    }

    @Override
    public void onSave() {
        if (this.indexingPolicy != null) {
            this.indexingPolicy.onSave();
            super.set("indexingPolicy", this.indexingPolicy);
        }
    }
}

