/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.Helper;
import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.ResourceType;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;

final class DocumentServiceRequest {
    private String resourceId;
    private ResourceType resourceType;
    private String path;
    private String queryString;
    private HttpEntity body;
    private Map<String, String> headers;
    private String continuation;
    private boolean isMedia = false;

    private DocumentServiceRequest(ResourceType resourceType, String path, HttpEntity body, Map<String, String> headers) {
        this.resourceType = resourceType;
        this.path = path;
        this.resourceId = DocumentServiceRequest.extractIdFromUri(path);
        if (resourceType == ResourceType.Media) {
            this.resourceId = DocumentServiceRequest.getAttachmentIdFromMediaId(this.resourceId);
        }
        this.body = body;
        this.headers = headers != null ? headers : new HashMap();
    }

    public static DocumentServiceRequest create(ResourceType resourceType, String relativePath, InputStream stream, Map<String, String> headers) {
        InputStreamEntity body = new InputStreamEntity(stream, -1L);
        return new DocumentServiceRequest(resourceType, relativePath, (HttpEntity)body, headers);
    }

    public static DocumentServiceRequest create(ResourceType resourceType, String relativePath, Resource resource, Map<String, String> headers) {
        try {
            StringEntity body = new StringEntity(resource.toString());
            return new DocumentServiceRequest(resourceType, relativePath, (HttpEntity)body, headers);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Failed to get HttpEntity from resource.", e);
        }
    }

    public static DocumentServiceRequest create(ResourceType resourceType, String relativePath, String query, Map<String, String> headers) {
        try {
            StringEntity body = new StringEntity(query);
            return new DocumentServiceRequest(resourceType, relativePath, (HttpEntity)body, headers);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Failed to get HttpEntity from resource.", e);
        }
    }

    public static DocumentServiceRequest create(ResourceType resourceType, String relativePath, Map<String, String> headers) {
        return new DocumentServiceRequest(resourceType, relativePath, null, headers);
    }

    static String extractIdFromUri(String path) {
        String[] pathParts;
        if (path.length() == 0) {
            return path;
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        if (path.charAt(0) != '/') {
            path = '/' + path;
        }
        if ((pathParts = (path = path + '=').split("/")).length % 2 == 0) {
            return pathParts[pathParts.length - 2];
        }
        return pathParts[pathParts.length - 3];
    }

    static String getAttachmentIdFromMediaId(String mediaId) {
        String attachmentId;
        byte[] buffer = Base64.decodeBase64((byte[])mediaId.replace('-', '/').getBytes());
        int resoureIdLength = 20;
        if (buffer.length > 20) {
            byte[] newBuffer = new byte[20];
            System.arraycopy(buffer, 0, newBuffer, 0, 20);
            attachmentId = Helper.encodeBase64String(newBuffer).replace('/', '-');
        } else {
            attachmentId = mediaId;
        }
        return attachmentId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public HttpEntity getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getContinuation() {
        return this.continuation;
    }

    public void setContinuation(String continuation) {
        this.continuation = continuation;
    }

    public void setIsMedia(boolean isMedia) {
        this.isMedia = isMedia;
    }

    public boolean getIsMedia() {
        return this.isMedia;
    }
}

