/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.Attachment;
import com.microsoft.azure.documentdb.Database;
import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.Permission;
import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.StoredProcedure;
import com.microsoft.azure.documentdb.Trigger;
import com.microsoft.azure.documentdb.User;
import com.microsoft.azure.documentdb.UserDefinedFunction;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

final class DocumentServiceResponse
implements AutoCloseable {
    private int statusCode;
    private Map<String, String> headersMap = new HashMap<String, String>();
    private HttpEntity httpEntity;

    DocumentServiceResponse(HttpResponse httpResponse) {
        this.statusCode = httpResponse.getStatusLine().getStatusCode();
        for (Header header : httpResponse.getAllHeaders()) {
            this.headersMap.put(header.getName(), header.getValue());
        }
        this.httpEntity = httpResponse.getEntity();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, String> getResponseHeaders() {
        return this.headersMap;
    }

    public String getReponseBodyAsString() {
        try {
            String responseBody;
            String string = responseBody = EntityUtils.toString((HttpEntity)this.httpEntity, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException | ParseException e) {
            throw new IllegalStateException("Failed to get UTF-8 string from http entity.", e);
        }
        finally {
            this.close();
        }
    }

    public <T extends Resource> T getResource(Class<T> c) {
        String responseBody = null;
        try {
            responseBody = EntityUtils.toString((HttpEntity)this.httpEntity, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException | ParseException e) {
            throw new IllegalStateException("Failed to get UTF-8 string from http entity.", e);
        }
        finally {
            this.close();
        }
        try {
            return (T)((Resource)c.getConstructor(String.class).newInstance(responseBody));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to instantiate class object.", e);
        }
    }

    public <T extends Resource> List<T> getQueryResponse(Class<T> c) {
        String responseBody = null;
        try {
            responseBody = EntityUtils.toString((HttpEntity)this.httpEntity, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException | ParseException e) {
            throw new IllegalStateException("Failed to get UTF-8 string from http entity.", e);
        }
        finally {
            this.close();
        }
        JSONObject jobject = new JSONObject(responseBody);
        String resourceKey = DocumentServiceResponse.getResourceKey(c);
        JSONArray jTokenArray = jobject.getJSONArray(resourceKey);
        ArrayList<Resource> queryResults = new ArrayList<Resource>();
        if (jTokenArray != null) {
            for (int i = 0; i < jTokenArray.length(); ++i) {
                JSONObject jToken = jTokenArray.getJSONObject(i);
                Resource resource = null;
                try {
                    resource = (Resource)c.getConstructor(String.class).newInstance(jToken.toString());
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalStateException("Failed to instantiate class object.", e);
                }
                queryResults.add(resource);
            }
        }
        return queryResults;
    }

    public InputStream getContentStream() {
        if (this.httpEntity == null) {
            return null;
        }
        try {
            if (this.httpEntity.isStreaming()) {
                return this.httpEntity.getContent();
            }
            byte[] responseBodyBytes = EntityUtils.toByteArray((HttpEntity)this.httpEntity);
            this.close();
            return new ByteArrayInputStream(responseBodyBytes);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get stream from http entity.", e);
        }
    }

    public static <T extends Resource> String getResourceKey(Class<T> c) {
        if (c.equals(Attachment.class)) {
            return "Attachments";
        }
        if (c.equals(Database.class)) {
            return "Databases";
        }
        if (c.equals(Document.class)) {
            return "Documents";
        }
        if (c.equals(DocumentCollection.class)) {
            return "DocumentCollections";
        }
        if (c.equals(Permission.class)) {
            return "Permissions";
        }
        if (c.equals(Trigger.class)) {
            return "Triggers";
        }
        if (c.equals(StoredProcedure.class)) {
            return "StoredProcedures";
        }
        if (c.equals(User.class)) {
            return "Users";
        }
        if (c.equals(UserDefinedFunction.class)) {
            return "UserDefinedFunctions";
        }
        throw new IllegalArgumentException("c");
    }

    @Override
    public void close() {
        if (this.httpEntity != null) {
            try {
                EntityUtils.consume((HttpEntity)this.httpEntity);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        }
    }
}

