/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.AuthorizationHelper;
import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentServiceRequest;
import com.microsoft.azure.documentdb.DocumentServiceResponse;
import com.microsoft.azure.documentdb.Error;
import com.microsoft.azure.documentdb.HttpConstants;
import com.microsoft.azure.documentdb.ResourceType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

final class GatewayProxy {
    private URI serviceEndpoint;
    private Map<String, String> defaultHeaders;
    private String masterKey;
    private Map<String, String> resourceTokens;
    private ConnectionPolicy connectionPolicy;
    private HttpClient httpClient;
    private HttpClient mediaHttpClient;
    private PoolingClientConnectionManager connectionManager;

    public GatewayProxy(URI serviceEndpoint, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, String masterKey, Map<String, String> resourceTokens) {
        this.serviceEndpoint = serviceEndpoint;
        this.defaultHeaders = new HashMap<String, String>();
        this.defaultHeaders.put("Cache-Control", "no-cache");
        this.defaultHeaders.put("x-ms-version", HttpConstants.Versions.CURRENT_VERSION);
        this.defaultHeaders.put("User-Agent", HttpConstants.Versions.USER_AGENT);
        if (consistencyLevel != null) {
            this.defaultHeaders.put("x-ms-consistency-level", consistencyLevel.toString());
        }
        this.connectionPolicy = connectionPolicy;
        this.masterKey = masterKey;
        this.resourceTokens = resourceTokens;
        this.connectionManager = new PoolingClientConnectionManager(SchemeRegistryFactory.createDefault());
        this.connectionManager.setMaxTotal(this.connectionPolicy.getMaxPoolSize());
        this.connectionManager.setDefaultMaxPerRoute(this.connectionPolicy.getMaxPoolSize());
        this.connectionManager.closeIdleConnections((long)this.connectionPolicy.getIdleConnectionTimeout(), TimeUnit.SECONDS);
    }

    public DocumentServiceResponse doCreate(DocumentServiceRequest request) throws DocumentClientException {
        return this.performPostRequest(request);
    }

    public DocumentServiceResponse doRead(DocumentServiceRequest request) throws DocumentClientException {
        return this.performGetRequest(request);
    }

    public DocumentServiceResponse doReplace(DocumentServiceRequest request) throws DocumentClientException {
        return this.performPutRequest(request);
    }

    public DocumentServiceResponse doDelete(DocumentServiceRequest request) throws DocumentClientException {
        return this.performDeleteRequest(request);
    }

    public DocumentServiceResponse doExecute(DocumentServiceRequest request) throws DocumentClientException {
        return this.performPostRequest(request);
    }

    public DocumentServiceResponse doReadFeed(DocumentServiceRequest request) throws DocumentClientException {
        return this.performGetRequest(request);
    }

    public DocumentServiceResponse doSQLQuery(DocumentServiceRequest request) throws DocumentClientException {
        request.getHeaders().put("x-ms-documentdb-isquery", "true");
        request.getHeaders().put("Content-Type", "application/sql");
        return this.performPostRequest(request);
    }

    private HttpClient getHttpClient(boolean isForMedia) {
        if (isForMedia) {
            if (this.mediaHttpClient == null) {
                this.mediaHttpClient = this.createHttpClient(isForMedia);
            }
            return this.mediaHttpClient;
        }
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient(isForMedia);
        }
        return this.httpClient;
    }

    private HttpClient createHttpClient(boolean isForMedia) {
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)this.connectionManager);
        HttpParams httpParams = httpClient.getParams();
        if (isForMedia) {
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)(this.connectionPolicy.getMediaRequestTimeout() * 1000));
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)(this.connectionPolicy.getMediaRequestTimeout() * 1000));
        } else {
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)(this.connectionPolicy.getRequestTimeout() * 1000));
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)(this.connectionPolicy.getRequestTimeout() * 1000));
        }
        return httpClient;
    }

    private void putMoreContentIntoDocumentServiceRequest(DocumentServiceRequest request, String httpMethod) {
        if (this.masterKey != null) {
            Date currentTime = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("E, dd MMM YYY HH:mm:ss z");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            String xDate = sdf.format(currentTime);
            request.getHeaders().put("x-ms-date", xDate);
        }
        if (this.masterKey != null || this.resourceTokens != null) {
            String authorization = this.getAuthorizationToken(request.getResourceId(), request.getPath(), request.getResourceType(), httpMethod, request.getHeaders(), this.masterKey, this.resourceTokens);
            try {
                authorization = URLEncoder.encode(authorization, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Failed to encode authtoken.", e);
            }
            request.getHeaders().put("authorization", authorization);
        }
        if (!(httpMethod != "POST" && httpMethod != "PUT" || request.getHeaders().containsKey("Content-Type"))) {
            request.getHeaders().put("Content-Type", "application/json");
        }
        if (!request.getHeaders().containsKey("Accept")) {
            request.getHeaders().put("Accept", "application/json");
        }
    }

    private void fillHttpRequestBaseWithHeaders(Map<String, String> headers, HttpRequestBase httpBase) {
        for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
            httpBase.setHeader(entry.getKey(), entry.getValue());
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpBase.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private void maybeThrowException(HttpResponse response) throws DocumentClientException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= HttpConstants.StatusCodes.MINIMUM_STATUSCODE_AS_ERROR_GATEWAY) {
            HttpEntity httpEntity = response.getEntity();
            String body = "";
            if (httpEntity != null) {
                try {
                    body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException | ParseException e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to get content from the http response", e);
                }
            }
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                responseHeaders.put(header.getName(), header.getValue());
            }
            throw new DocumentClientException(statusCode, new Error(body), responseHeaders);
        }
    }

    private DocumentServiceResponse performDeleteRequest(DocumentServiceRequest request) throws DocumentClientException {
        URI uri;
        this.putMoreContentIntoDocumentServiceRequest(request, "DELETE");
        try {
            uri = new URI("https", null, this.serviceEndpoint.getHost(), this.serviceEndpoint.getPort(), request.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Incorrect uri from request.", e);
        }
        HttpDelete httpDelete = new HttpDelete(uri);
        this.fillHttpRequestBaseWithHeaders(request.getHeaders(), (HttpRequestBase)httpDelete);
        HttpResponse response = null;
        try {
            response = this.getHttpClient(request.getIsMedia()).execute((HttpUriRequest)httpDelete);
        }
        catch (IOException e) {
            httpDelete.releaseConnection();
            throw new IllegalStateException("Http client execution failed.", e);
        }
        this.maybeThrowException(response);
        httpDelete.releaseConnection();
        return new DocumentServiceResponse(response);
    }

    private DocumentServiceResponse performGetRequest(DocumentServiceRequest request) throws DocumentClientException {
        URI uri;
        this.putMoreContentIntoDocumentServiceRequest(request, "GET");
        try {
            uri = new URI("https", null, this.serviceEndpoint.getHost(), this.serviceEndpoint.getPort(), request.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Incorrect uri from request.", e);
        }
        HttpGet httpGet = new HttpGet(uri);
        this.fillHttpRequestBaseWithHeaders(request.getHeaders(), (HttpRequestBase)httpGet);
        HttpResponse response = null;
        try {
            response = this.getHttpClient(request.getIsMedia()).execute((HttpUriRequest)httpGet);
        }
        catch (IOException e) {
            httpGet.releaseConnection();
            throw new IllegalStateException("Http client execution failed.", e);
        }
        this.maybeThrowException(response);
        return new DocumentServiceResponse(response);
    }

    private DocumentServiceResponse performPostRequest(DocumentServiceRequest request) throws DocumentClientException {
        URI uri;
        this.putMoreContentIntoDocumentServiceRequest(request, "POST");
        try {
            uri = new URI("https", null, this.serviceEndpoint.getHost(), this.serviceEndpoint.getPort(), request.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Incorrect uri from request.", e);
        }
        HttpPost httpPost = new HttpPost(uri);
        this.fillHttpRequestBaseWithHeaders(request.getHeaders(), (HttpRequestBase)httpPost);
        httpPost.setEntity(request.getBody());
        HttpResponse response = null;
        try {
            response = this.getHttpClient(request.getIsMedia()).execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            httpPost.releaseConnection();
            throw new IllegalStateException("Http client execution failed.", e);
        }
        this.maybeThrowException(response);
        return new DocumentServiceResponse(response);
    }

    private DocumentServiceResponse performPutRequest(DocumentServiceRequest request) throws DocumentClientException {
        URI uri;
        this.putMoreContentIntoDocumentServiceRequest(request, "PUT");
        try {
            uri = new URI("https", null, this.serviceEndpoint.getHost(), this.serviceEndpoint.getPort(), request.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Incorrect uri from request.", e);
        }
        HttpPut httpPut = new HttpPut(uri);
        this.fillHttpRequestBaseWithHeaders(request.getHeaders(), (HttpRequestBase)httpPut);
        httpPut.setEntity(request.getBody());
        HttpResponse response = null;
        try {
            httpPut.releaseConnection();
            response = this.getHttpClient(request.getIsMedia()).execute((HttpUriRequest)httpPut);
        }
        catch (IOException e) {
            throw new IllegalStateException("Http client execution failed.", e);
        }
        this.maybeThrowException(response);
        return new DocumentServiceResponse(response);
    }

    private String getAuthorizationToken(String resourceOrOwnerId, String path, ResourceType resourceType, String requestVerb, Map<String, String> headers, String masterKey, Map<String, String> resourceTokens) {
        if (masterKey != null) {
            return AuthorizationHelper.GenerateKeyAuthorizationSignature(requestVerb, resourceOrOwnerId, resourceType, headers, masterKey);
        }
        if (resourceTokens != null) {
            return AuthorizationHelper.GetAuthorizationTokenUsingResourceTokens(resourceTokens, path, resourceOrOwnerId);
        }
        return null;
    }
}

