/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.IndexingMode;
import com.microsoft.azure.documentdb.IndexingPath;
import com.microsoft.azure.documentdb.JsonSerializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.text.WordUtils;
import org.json.JSONObject;

public final class IndexingPolicy
extends JsonSerializable {
    private Collection<IndexingPath> included;
    private Collection<String> excluded;

    public IndexingPolicy() {
        this.setAutomatic(true);
        this.setIndexingMode(IndexingMode.Consistent);
    }

    public IndexingPolicy(String jsonString) {
        super(jsonString);
    }

    public IndexingPolicy(JSONObject jsonObject) {
        super(jsonObject);
    }

    public void setAutomatic(boolean automatic) {
        super.set("automatic", automatic);
    }

    public Boolean getAutomatic() {
        return super.getBoolean("automatic");
    }

    public void setIndexingMode(IndexingMode indexingMode) {
        super.set("indexingMode", indexingMode.name());
    }

    public IndexingMode getIndexingMode() {
        IndexingMode result = IndexingMode.Lazy;
        try {
            result = IndexingMode.valueOf(WordUtils.capitalize((String)super.getString("indexingMode")));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Collection<IndexingPath> getIncludedPaths() {
        if (this.included == null) {
            this.included = super.getCollection("IncludedPaths", IndexingPath.class);
            if (this.included == null) {
                this.included = new ArrayList<IndexingPath>();
            }
        }
        return this.included;
    }

    public Collection<String> getExcludedPaths() {
        if (this.excluded == null) {
            this.excluded = super.getCollection("ExcludedPaths", String.class);
            if (this.excluded == null) {
                this.excluded = new ArrayList<String>();
            }
        }
        return this.excluded;
    }

    @Override
    void onSave() {
        boolean bDefaultPaths;
        boolean bl = bDefaultPaths = this.included != null && this.included.size() == 0 && this.excluded != null && this.excluded.size() == 0;
        if (bDefaultPaths) {
            return;
        }
        if (this.included != null) {
            super.set("IncludedPaths", this.included);
        }
        if (this.excluded != null) {
            super.set("ExcludedPaths", this.excluded);
        }
    }
}

