/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class JsonSerializable {
    JSONObject propertyBag = null;

    JsonSerializable() {
        this.propertyBag = new JSONObject();
    }

    JsonSerializable(String jsonString) {
        this.propertyBag = new JSONObject(jsonString);
    }

    JsonSerializable(JSONObject jsonObject) {
        this.propertyBag = new JSONObject((Object)jsonObject);
    }

    public HashMap<String, Object> getHashMap() {
        return JsonSerializable.toMap(this.propertyBag);
    }

    private static HashMap<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = JsonSerializable.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonSerializable.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    private static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = JsonSerializable.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonSerializable.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    public boolean has(String propertyName) {
        return this.propertyBag.has(propertyName);
    }

    public void remove(String propertyName) {
        this.propertyBag.remove(propertyName);
    }

    public <T> void set(String propertyName, T value) {
        if (value == null) {
            this.propertyBag.put(propertyName, JSONObject.NULL);
        } else if (value instanceof Collection) {
            JSONArray jsonArray = new JSONArray();
            this.internalSetCollection(propertyName, (Collection)value, jsonArray);
            this.propertyBag.put(propertyName, (Object)jsonArray);
        } else if (value instanceof Number || value instanceof Boolean || value instanceof String || value instanceof JSONObject) {
            this.propertyBag.put(propertyName, value);
        } else if (value instanceof JsonSerializable) {
            JsonSerializable castedValue = (JsonSerializable)value;
            if (castedValue != null) {
                castedValue.onSave();
            }
            this.propertyBag.put(propertyName, (Object)(castedValue != null ? castedValue.propertyBag : null));
        } else {
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.propertyBag.put(propertyName, (Object)new JSONObject(mapper.writeValueAsString(value)));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
    }

    private <T> void internalSetCollection(String propertyName, Collection<T> collection, JSONArray targetArray) {
        ObjectMapper mapper = null;
        for (T childValue : collection) {
            if (childValue == null) {
                targetArray.put(JSONObject.NULL);
                continue;
            }
            if (childValue instanceof Collection) {
                JSONArray childArray = new JSONArray();
                this.internalSetCollection(propertyName, (Collection)childValue, childArray);
                targetArray.put((Object)childArray);
                continue;
            }
            if (childValue instanceof Number || childValue instanceof Boolean || childValue instanceof String || childValue instanceof JSONObject) {
                targetArray.put(childValue);
                continue;
            }
            if (childValue instanceof JsonSerializable) {
                JsonSerializable castedValue = (JsonSerializable)childValue;
                castedValue.onSave();
                targetArray.put((Object)(castedValue.propertyBag != null ? castedValue.propertyBag : new JSONObject()));
                continue;
            }
            if (mapper == null) {
                mapper = new ObjectMapper();
            }
            try {
                targetArray.put((Object)new JSONObject(mapper.writeValueAsString(childValue)));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
    }

    public String getString(String propertyName) {
        if (this.has(propertyName)) {
            return this.propertyBag.getString(propertyName);
        }
        return null;
    }

    public Boolean getBoolean(String propertyName) {
        if (this.has(propertyName)) {
            return new Boolean(this.propertyBag.getBoolean(propertyName));
        }
        return null;
    }

    public Integer getInt(String propertyName) {
        if (this.has(propertyName)) {
            return new Integer(this.propertyBag.getInt(propertyName));
        }
        return null;
    }

    public Long getLong(String propertyName) {
        if (this.has(propertyName)) {
            return new Long(this.propertyBag.getLong(propertyName));
        }
        return null;
    }

    public Double getDouble(String propertyName) {
        if (this.has(propertyName)) {
            return new Double(this.propertyBag.getDouble(propertyName));
        }
        return null;
    }

    public <T> T getObject(String propertyName, Class<T> c) {
        if (this.propertyBag.has(propertyName)) {
            JSONObject jsonObj = this.propertyBag.getJSONObject(propertyName);
            if (Number.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c)) {
                return c.cast(jsonObj);
            }
            if (JsonSerializable.class.isAssignableFrom(c)) {
                try {
                    return c.getConstructor(String.class).newInstance(jsonObj.toString());
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalStateException("Failed to instantiate class object.", e);
                }
            }
            if (!c.isMemberClass() || !Modifier.isStatic(c.getModifiers())) {
                throw new IllegalArgumentException("c must be a member (not an anonymous or local) and static class.");
            }
            try {
                return (T)new ObjectMapper().readValue(jsonObj.toString(), c);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalStateException("Failed to get POJO.", e);
            }
        }
        return null;
    }

    public <T> Collection<T> getCollection(String propertyName, Class<T> c) {
        if (this.propertyBag != null && this.propertyBag.has(propertyName)) {
            JSONArray jsonArray = this.propertyBag.getJSONArray(propertyName);
            ArrayList<Object> result = new ArrayList<Object>();
            ObjectMapper mapper = null;
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject;
                if (Number.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c)) {
                    result.add(c.cast(jsonArray.get(i)));
                    continue;
                }
                if (JsonSerializable.class.isAssignableFrom(c)) {
                    jsonObject = jsonArray.getJSONObject(i);
                    try {
                        result.add(c.getConstructor(String.class).newInstance(jsonObject.toString()));
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new IllegalStateException("Failed to instantiate class object.", e);
                    }
                }
                jsonObject = jsonArray.getJSONObject(i);
                if (mapper == null) {
                    mapper = new ObjectMapper();
                    if (!c.isMemberClass() || !Modifier.isStatic(c.getModifiers())) {
                        throw new IllegalArgumentException("c must be a member (not an anonymous or local) and static class.");
                    }
                }
                try {
                    result.add(mapper.readValue(jsonObject.toString(), c));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to get POJO.", e);
                }
            }
            return result;
        }
        return null;
    }

    public JSONObject getObject(String propertyName) {
        if (this.propertyBag.has(propertyName)) {
            JSONObject jsonObj = this.propertyBag.getJSONObject(propertyName);
            return jsonObj;
        }
        return null;
    }

    public Collection<JSONObject> getCollection(String propertyName) {
        ArrayList<JSONObject> result = null;
        if (this.propertyBag != null && this.propertyBag.has(propertyName)) {
            result = new ArrayList<JSONObject>();
            JSONArray jsonArray = this.propertyBag.getJSONArray(propertyName);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                result.add(jsonObject);
            }
        }
        return result;
    }

    void onSave() {
    }

    public <T> T toObject(Class<T> c) {
        if (JsonSerializable.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Number.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("c can only be a POJO class or JSONObject");
        }
        if (JSONObject.class.isAssignableFrom(c)) {
            if (JSONObject.class != c) {
                throw new IllegalArgumentException("We support JSONObject but not its sub-classes.");
            }
            return c.cast(this.propertyBag);
        }
        if (!c.isMemberClass() || !Modifier.isStatic(c.getModifiers())) {
            throw new IllegalArgumentException("c must be a member (not an anonymous or local) and static class.");
        }
        try {
            return (T)new ObjectMapper().readValue(this.toString(), c);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to get POJO.", e);
        }
    }

    public String toString() {
        this.onSave();
        return this.propertyBag.toString();
    }

    public String toString(int indentFactor) throws JSONException {
        this.onSave();
        return this.propertyBag.toString(indentFactor);
    }
}

