/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.BackoffRetryUtility;
import com.microsoft.azure.documentdb.BackoffRetryUtilityDelegate;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentServiceRequest;
import com.microsoft.azure.documentdb.DocumentServiceResponse;
import com.microsoft.azure.documentdb.ReadType;
import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.ResourceThrottleRetryPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class QueryIterable<T extends Resource>
implements Iterable<T> {
    private DocumentClient client = null;
    private ResourceThrottleRetryPolicy retryPolicy = null;
    private DocumentServiceRequest request = null;
    private ReadType readType;
    private Class<T> classT;
    private String continuation = null;
    private boolean hasStarted = false;
    private List<T> items = new ArrayList<T>();
    private Map<String, String> responseHeaders;

    QueryIterable(DocumentClient client, DocumentServiceRequest request, ReadType readType, Class<T> classT) {
        this.client = client;
        this.retryPolicy = new ResourceThrottleRetryPolicy(client.getRetryPolicy().getMaxRetryAttemptsOnQuery());
        this.request = request;
        this.readType = readType;
        this.classT = classT;
    }

    Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator it = new Iterator<T>(){
            private int currentIndex = 0;
            private boolean hasNext = true;
            private BackoffRetryUtilityDelegate delegate = new BackoffRetryUtilityDelegate(){

                @Override
                public void apply() throws Exception {
                    if (QueryIterable.this.fetchNextBlock() <= 0) {
                        hasNext = false;
                    }
                }
            };

            @Override
            public boolean hasNext() {
                if (this.currentIndex >= QueryIterable.this.items.size() && this.hasNext) {
                    BackoffRetryUtility.execute(this.delegate, QueryIterable.this.retryPolicy);
                }
                return this.hasNext;
            }

            @Override
            public T next() {
                if (this.currentIndex >= QueryIterable.this.items.size() && this.hasNext) {
                    BackoffRetryUtility.execute(this.delegate, QueryIterable.this.retryPolicy);
                }
                if (!this.hasNext) {
                    return null;
                }
                return (Resource)QueryIterable.this.items.get(this.currentIndex++);
            }

            @Override
            public void remove() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.currentIndex < QueryIterable.this.items.size() - 1) {
                    QueryIterable.this.items.remove(this.currentIndex);
                }
            }
        };
        return it;
    }

    public List<T> toList() {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (Resource t : this) {
            list.add(t);
        }
        return list;
    }

    private int fetchNextBlock() throws DocumentClientException {
        DocumentServiceResponse response = null;
        List<T> fetchedItems = null;
        while (!this.isNullEmptyOrFalse(this.continuation) || !this.hasStarted) {
            if (!this.isNullEmptyOrFalse(this.continuation)) {
                this.request.getHeaders().put("x-ms-continuation", this.continuation);
            }
            response = this.readType == ReadType.Feed ? this.client.doReadFeed(this.request) : this.client.doQuery(this.request);
            if (!this.hasStarted) {
                this.hasStarted = true;
            }
            this.responseHeaders = response.getResponseHeaders();
            this.continuation = this.responseHeaders.get("x-ms-continuation");
            fetchedItems = response.getQueryResponse(this.classT);
            this.items.addAll(fetchedItems);
            if (fetchedItems == null || fetchedItems.size() <= 0) continue;
        }
        return fetchedItems != null ? fetchedItems.size() : 0;
    }

    private boolean isNullEmptyOrFalse(String s) {
        return s == null || s.isEmpty() || s == "false" || s == "False";
    }
}

