/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.DocumentClientException;
import java.util.logging.Logger;

final class ResourceThrottleRetryPolicy {
    private final long defaultRetryInSeconds = 5L;
    private int maxAttemptCount;
    private int currentAttemptCount = 0;
    private long retryAfterInMilliseconds = 0L;
    private final Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    public ResourceThrottleRetryPolicy(int maxRetryCount) {
        this.maxAttemptCount = maxRetryCount;
    }

    public long getRetryAfterInMilliseconds() {
        return this.retryAfterInMilliseconds;
    }

    public boolean shouldRetry(Exception exception) {
        this.retryAfterInMilliseconds = 0L;
        if (this.currentAttemptCount < this.maxAttemptCount && this.CheckIfRetryNeeded(exception)) {
            ++this.currentAttemptCount;
            this.logger.info(String.format("Operation will be retried after %d milliseconds. Exception: %s", this.retryAfterInMilliseconds, exception.getMessage()));
            return true;
        }
        this.logger.warning(String.format("Operation will NOT be retried. Exception: %s", exception.getMessage()));
        return false;
    }

    private boolean CheckIfRetryNeeded(Exception exception) {
        DocumentClientException dce;
        this.retryAfterInMilliseconds = 0L;
        if (exception instanceof DocumentClientException && (dce = (DocumentClientException)exception).getStatusCode() == 429) {
            this.retryAfterInMilliseconds = dce.getRetryAfterInMilliseconds();
            if (this.retryAfterInMilliseconds == 0L) {
                this.retryAfterInMilliseconds = this.defaultRetryInSeconds;
            }
            return true;
        }
        return false;
    }
}

