/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.ResourceId;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

final class SessionContainer {
    private final ConcurrentHashMap<Long, String> sessionTokens;
    private final String hostName;

    public SessionContainer(String hostName) {
        this.hostName = hostName;
        this.sessionTokens = new ConcurrentHashMap();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String resolveSessionToken(ResourceId resourceId) {
        if (resourceId.getDocumentCollection() != 0) {
            return this.sessionTokens.get(resourceId.getUniqueDocumentCollectionId());
        }
        return null;
    }

    public void clearToken(ResourceId resourceId) {
        if (resourceId.getDocumentCollection() != 0) {
            this.sessionTokens.remove(resourceId.getUniqueDocumentCollectionId());
        }
    }

    public void setSessionToken(ResourceId resourceId, String token) {
        if (resourceId.getDocumentCollection() != 0) {
            long currentTokenValue = !StringUtils.isEmpty((CharSequence)token) ? Long.parseLong(token) : 0L;
            String oldToken = this.sessionTokens.get(resourceId.getUniqueDocumentCollectionId());
            if (oldToken == null) {
                this.sessionTokens.putIfAbsent(resourceId.getUniqueDocumentCollectionId(), token);
            } else {
                long existingValue = Long.parseLong(oldToken);
                if (existingValue < currentTokenValue) {
                    this.sessionTokens.put(resourceId.getUniqueDocumentCollectionId(), token);
                }
            }
        }
    }
}

