/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.Attachment;
import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentServiceResponse;
import java.util.Map;

public final class StoredProcedureResponse {
    private DocumentServiceResponse response;

    StoredProcedureResponse(DocumentServiceResponse response) {
        this.response = response;
    }

    public String getActivityId() {
        return this.response.getResponseHeaders().get("x-ms-activity-id");
    }

    public String getSessionToken() {
        return this.response.getResponseHeaders().get("x-ms-session-token");
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    public String getMaxResourceQuota() {
        return this.response.getResponseHeaders().get("x-ms-resource-quota");
    }

    public String getCurrentResourceQuotaUsage() {
        return this.response.getResponseHeaders().get("x-ms-resource-usage");
    }

    public double getRequestCharge() {
        String value = this.response.getResponseHeaders().get("x-ms-request-charge");
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public Map<String, String> getResponseHeaders() {
        return this.response.getResponseHeaders();
    }

    public Document getResponseAsDocument() {
        return this.response.getResource(Document.class);
    }

    public Attachment getResponseAsAttachment() {
        return this.response.getResource(Attachment.class);
    }

    public String getResponseAsString() {
        return this.response.getReponseBodyAsString();
    }
}

