/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.test;

import com.microsoft.azure.documentdb.AccessCondition;
import com.microsoft.azure.documentdb.AccessConditionType;
import com.microsoft.azure.documentdb.Attachment;
import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.Database;
import com.microsoft.azure.documentdb.DatabaseAccount;
import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.IndexType;
import com.microsoft.azure.documentdb.IndexingMode;
import com.microsoft.azure.documentdb.MediaOptions;
import com.microsoft.azure.documentdb.MediaReadMode;
import com.microsoft.azure.documentdb.Permission;
import com.microsoft.azure.documentdb.PermissionMode;
import com.microsoft.azure.documentdb.RequestOptions;
import com.microsoft.azure.documentdb.ResourceResponse;
import com.microsoft.azure.documentdb.StoredProcedure;
import com.microsoft.azure.documentdb.Trigger;
import com.microsoft.azure.documentdb.TriggerOperation;
import com.microsoft.azure.documentdb.TriggerType;
import com.microsoft.azure.documentdb.User;
import com.microsoft.azure.documentdb.UserDefinedFunction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class GatewayTests {
    static final String HOST = "[YOUR_ENDPOINT_HERE]";
    static final String MASTER_KEY = "[YOUR_KEY_HERE]";
    private Database databaseForTest;
    private DocumentCollection collectionForTest;

    @Before
    public void setUp() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        Database databaseDefinition = new Database();
        databaseDefinition.setId(GatewayTests.getUID());
        this.databaseForTest = client.createDatabase(databaseDefinition, null).getResource();
        DocumentCollection collectionDefinition = new DocumentCollection();
        collectionDefinition.setId(GatewayTests.getUID());
        this.collectionForTest = client.createCollection(this.databaseForTest.getSelfLink(), collectionDefinition, null).getResource();
    }

    @After
    public void tearDown() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        client.deleteDatabase(this.databaseForTest.getSelfLink(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromInputStream(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    @Test
    public void testJsonSerialization() throws DocumentClientException {
        Document document = new Document();
        document.set("prop0", (Object)null);
        document.set("prop1", "abc");
        Document childDocument = new Document("{'child1Prop1': 500}");
        document.set("child1", childDocument);
        document.set("child2", new JSONObject("{'child2Prop1': '800'}"));
        document.set("child3", new StaticPOJOForTest());
        ArrayList<Integer> collection1 = new ArrayList<Integer>();
        collection1.add(101);
        collection1.add(102);
        document.set("collection1", collection1);
        ArrayList<Document> collection2 = new ArrayList<Document>();
        collection2.add(new Document("{'foo': 'bar'}"));
        document.set("collection2", collection2);
        ArrayList<StaticPOJOForTest> collection3 = new ArrayList<StaticPOJOForTest>();
        collection3.add(new StaticPOJOForTest());
        document.set("collection3", collection3);
        ArrayList collection4 = new ArrayList();
        ArrayList collection5 = new ArrayList();
        ArrayList<String> collection6 = new ArrayList<String>();
        collection6.add("ABCD");
        collection5.add(collection6);
        collection4.add(collection5);
        document.set("collection4", collection4);
        Document expectedDocument = new Document("{  'prop0': null,  'prop1': 'abc',  'child1': {    'child1Prop1': 500  },  'child2': {    'child2Prop1': '800'  },  'child3': {    'pojoProp': '456'  },  'collection1': [101, 102],  'collection2': [{'foo': 'bar'}],  'collection3': [{'pojoProp': '456'}],  'collection4': [[['ABCD']]]}");
        Assert.assertEquals((Object)expectedDocument.toString(), (Object)document.toString());
        Assert.assertEquals((Object)"456", (Object)((StaticPOJOForTest)document.getObject((String)"child3", StaticPOJOForTest.class)).pojoProp);
        Assert.assertEquals((Object)"456", (Object)((StaticPOJOForTest)document.getCollection((String)"collection3", StaticPOJOForTest.class).iterator().next()).pojoProp);
        document = new Document("{'pojoProp': '654'}");
        StaticPOJOForTest pojo = (StaticPOJOForTest)document.toObject(StaticPOJOForTest.class);
        Assert.assertEquals((Object)"654", (Object)pojo.pojoProp);
        JSONObject jsonObject = (JSONObject)document.toObject(JSONObject.class);
        Assert.assertEquals((Object)"654", (Object)jsonObject.getString("pojoProp"));
    }

    @Test
    public void testDatabaseCrud() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        List<Database> databases = client.readDatabases(null).getQueryIterable().toList();
        int beforeCreateDatabasesCount = databases.size();
        Database databaseDefinition = new Database();
        databaseDefinition.setId(GatewayTests.getUID());
        Database createdDb = client.createDatabase(databaseDefinition, null).getResource();
        Assert.assertEquals((Object)databaseDefinition.getId(), (Object)createdDb.getId());
        databases = client.readDatabases(null).getQueryIterable().toList();
        Assert.assertEquals((long)(beforeCreateDatabasesCount + 1), (long)databases.size());
        databases = client.queryDatabases(String.format("SELECT * FROM root r WHERE r.id='%s'", databaseDefinition.getId()), null).getQueryIterable().toList();
        Assert.assertTrue((databases.size() > 0 ? 1 : 0) != 0);
        String alternativeDatabaseId = GatewayTests.getUID();
        createdDb.setId(alternativeDatabaseId);
        Database replacedDb = client.replaceDatabase(createdDb, null).getResource();
        Assert.assertEquals((Object)alternativeDatabaseId, (Object)replacedDb.getId());
        Database oneDbFromRead = client.readDatabase(replacedDb.getSelfLink(), null).getResource();
        Assert.assertEquals((Object)replacedDb.getId(), (Object)oneDbFromRead.getId());
        client.deleteDatabase(replacedDb.getSelfLink(), null);
        try {
            client.readDatabase(createdDb.getSelfLink(), null);
            Assert.fail((String)"Exception didn't happen.");
        }
        catch (DocumentClientException e) {
            Assert.assertEquals((long)404L, (long)e.getStatusCode());
            Assert.assertEquals((Object)"NotFound", (Object)e.getError().getCode());
        }
    }

    @Test
    public void testCollectionCrud() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        List<DocumentCollection> collections = client.readCollections(this.databaseForTest.getSelfLink(), null).getQueryIterable().toList();
        int beforeCreateCollectionsCount = collections.size();
        DocumentCollection collectionDefinition = new DocumentCollection();
        collectionDefinition.setId(GatewayTests.getUID());
        DocumentCollection createdCollection = client.createCollection(this.databaseForTest.getSelfLink(), collectionDefinition, null).getResource();
        Assert.assertEquals((Object)createdCollection.getId(), (Object)collectionDefinition.getId());
        collections = client.readCollections(this.databaseForTest.getSelfLink(), null).getQueryIterable().toList();
        Assert.assertEquals((long)collections.size(), (long)(beforeCreateCollectionsCount + 1));
        collections = client.queryCollections(this.databaseForTest.getSelfLink(), String.format("SELECT * FROM root r WHERE r.id='%s'", collectionDefinition.getId()), null).getQueryIterable().toList();
        Assert.assertTrue((collections.size() > 0 ? 1 : 0) != 0);
        client.deleteCollection(createdCollection.getSelfLink(), null);
        try {
            client.readCollection(createdCollection.getSelfLink(), null);
            Assert.fail((String)"Exception didn't happen.");
        }
        catch (DocumentClientException e) {
            Assert.assertEquals((long)404L, (long)e.getStatusCode());
            Assert.assertEquals((Object)"NotFound", (Object)e.getError().getCode());
        }
    }

    @Test
    public void testQueryIterableCrud() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        List<Document> documents = client.readDocuments(this.collectionForTest.getSelfLink(), null).getQueryIterable().toList();
        int beforeCreateDocumentsCount = documents.size();
        for (int i = 0; i < 20; ++i) {
            Document documentDefinition = new Document("{ 'name': 'For test' }");
            client.createDocument(this.collectionForTest.getSelfLink(), documentDefinition, null, false);
        }
        FeedOptions fo = new FeedOptions();
        fo.setPageSize(1);
        documents = client.readDocuments(this.collectionForTest.getSelfLink(), null).getQueryIterable().toList();
        Assert.assertEquals((long)(beforeCreateDocumentsCount + 20), (long)documents.size());
    }

    @Test
    public void testCollectionIndexingPolicy() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        Assert.assertEquals((Object)((Object)IndexingMode.Consistent), (Object)((Object)this.collectionForTest.getIndexingPolicy().getIndexingMode()));
        DocumentCollection lazyCollectionDefinition = new DocumentCollection("{  'id': 'lazy collection',  'indexingPolicy': {    'indexingMode': 'Lazy'  }}");
        client.deleteCollection(this.collectionForTest.getSelfLink(), null);
        DocumentCollection lazyCollection = client.createCollection(this.databaseForTest.getSelfLink(), lazyCollectionDefinition, null).getResource();
        Assert.assertEquals((Object)((Object)IndexingMode.Lazy), (Object)((Object)lazyCollection.getIndexingPolicy().getIndexingMode()));
        DocumentCollection consistentCollectionDefinition = new DocumentCollection("{  'id': 'lazy collection',  'indexingPolicy': {    'indexingMode': 'Consistent'  }}");
        client.deleteCollection(lazyCollection.getSelfLink(), null);
        DocumentCollection consistentCollection = client.createCollection(this.databaseForTest.getSelfLink(), consistentCollectionDefinition, null).getResource();
        Assert.assertEquals((Object)((Object)this.collectionForTest.getIndexingPolicy().getIndexingMode()), (Object)((Object)IndexingMode.Consistent));
        DocumentCollection collectionDefinition = new DocumentCollection("{  'id': 'CollectionWithIndexingPolicy',  'indexingPolicy': {    'automatic': true,    'indexingMode': 'Consistent',    'IncludedPaths': [      {        'IndexType': 'Hash',        'Path': '/'      }    ],    'ExcludedPaths': [      '/\"systemMetadata\"/*'    ]  }}");
        client.deleteCollection(consistentCollection.getSelfLink(), null);
        DocumentCollection collectionWithSecondaryIndex = client.createCollection(this.databaseForTest.getSelfLink(), collectionDefinition, null).getResource();
        Assert.assertEquals((long)2L, (long)collectionWithSecondaryIndex.getIndexingPolicy().getIncludedPaths().size());
        Assert.assertEquals((Object)((Object)IndexType.Hash), (Object)((Object)collectionWithSecondaryIndex.getIndexingPolicy().getIncludedPaths().iterator().next().getIndexType()));
        Assert.assertEquals((long)1L, (long)collectionWithSecondaryIndex.getIndexingPolicy().getExcludedPaths().size());
    }

    @Test
    public void testDocumentCrud() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        List<Document> documents = client.readDocuments(this.collectionForTest.getSelfLink(), null).getQueryIterable().toList();
        Assert.assertEquals((long)0L, (long)documents.size());
        Document documentDefinition = new Document("{  'name': 'sample document',  'foo': 'bar',  'key': 'value'}");
        try {
            client.createDocument(this.collectionForTest.getSelfLink(), documentDefinition, null, true);
            Assert.fail((String)"Exception didn't happen.");
        }
        catch (DocumentClientException e) {
            Assert.assertEquals((long)400L, (long)e.getStatusCode());
            Assert.assertEquals((Object)"BadRequest", (Object)e.getError().getCode());
        }
        Document document = client.createDocument(this.collectionForTest.getSelfLink(), documentDefinition, null, false).getResource();
        Assert.assertEquals((Object)documentDefinition.getString("name"), (Object)document.getString("name"));
        Assert.assertNotNull((Object)document.getId());
        documents = client.readDocuments(this.collectionForTest.getSelfLink(), null).getQueryIterable().toList();
        Assert.assertEquals((long)1L, (long)documents.size());
        documents = client.queryDocuments(this.collectionForTest.getSelfLink(), String.format("SELECT * FROM root r WHERE r.name='%s'", documentDefinition.getString("name")), null).getQueryIterable().toList();
        Assert.assertEquals((long)1L, (long)documents.size());
        document.set("name", "replaced document");
        document.set("foo", "not bar");
        Document replacedDocument = client.replaceDocument(document, null).getResource();
        Assert.assertEquals((Object)"replaced document", (Object)replacedDocument.getString("name"));
        Assert.assertEquals((Object)"not bar", (Object)replacedDocument.getString("foo"));
        Assert.assertEquals((Object)document.getId(), (Object)replacedDocument.getId());
        Document oneDocumentFromRead = client.readDocument(replacedDocument.getSelfLink(), null).getResource();
        Assert.assertEquals((Object)replacedDocument.getId(), (Object)oneDocumentFromRead.getId());
        AccessCondition accessCondition = new AccessCondition();
        accessCondition.setCondition(oneDocumentFromRead.getETag());
        accessCondition.setType(AccessConditionType.IfNoneMatch);
        RequestOptions options = new RequestOptions();
        options.setAccessCondition(accessCondition);
        ResourceResponse<Document> rr = client.readDocument(oneDocumentFromRead.getSelfLink(), options);
        Assert.assertEquals((long)rr.getStatusCode(), (long)304L);
        client.deleteDocument(replacedDocument.getSelfLink(), null);
        try {
            client.readDocument(replacedDocument.getSelfLink(), null);
            Assert.fail((String)"Exception didn't happen.");
        }
        catch (DocumentClientException e) {
            Assert.assertEquals((long)404L, (long)e.getStatusCode());
            Assert.assertEquals((Object)"NotFound", (Object)e.getError().getCode());
        }
    }

    @Test
    public void testPOJODocumentCrud() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        TestPOJO testPojo = new TestPOJO(10);
        testPojo.id = "MyPojoObejct" + GatewayTests.getUID();
        testPojo.stringProperty = "testString";
        testPojo.objectProperty = new TestPOJOInner(100);
        testPojo.setPrivateStringProperty("testStringAccess");
        Document document = client.createDocument(this.collectionForTest.getSelfLink(), testPojo, null, false).getResource();
        Assert.assertEquals((long)document.getInt("intProperty").intValue(), (long)testPojo.intProperty);
        Assert.assertEquals((Object)document.getString("stringProperty"), (Object)testPojo.stringProperty);
        Assert.assertEquals((Object)document.getString("privateStringProperty"), (Object)testPojo.getPrivateStringProperty());
        JSONObject jObject = document.getObject("objectProperty");
        Assert.assertEquals((long)jObject.getInt("intProperty"), (long)testPojo.objectProperty.intProperty);
        Collection coll1 = document.getCollection("stringList", String.class);
        Assert.assertEquals((long)coll1.size(), (long)testPojo.stringList.size());
        Assert.assertEquals(coll1.iterator().next(), (Object)testPojo.stringList.get(0));
        Collection coll2 = document.getCollection("stringArray", String.class);
        Assert.assertEquals((long)coll2.size(), (long)testPojo.stringArray.length);
        Assert.assertEquals(coll2.iterator().next(), (Object)testPojo.stringArray[0]);
        testPojo.stringProperty = "updatedTestString";
        document = client.replaceDocument(document.getSelfLink(), testPojo, null).getResource();
        Assert.assertEquals((Object)document.getString("stringProperty"), (Object)testPojo.stringProperty);
    }

    @Test
    public void testAttachmentCrud() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        Document documentDefinition = new Document("{  'id': 'sample document',  'foo': 'bar',  'key': 'value'}");
        Document document = client.createDocument(this.collectionForTest.getSelfLink(), documentDefinition, null, false).getResource();
        List<Attachment> attachments = client.readAttachments(document.getSelfLink(), null).getQueryIterable().toList();
        Assert.assertEquals((long)0L, (long)attachments.size());
        MediaOptions validMediaOptions = new MediaOptions();
        validMediaOptions.setSlug("attachment id");
        validMediaOptions.setContentType("application/text");
        MediaOptions invalidMediaOptions = new MediaOptions();
        invalidMediaOptions.setSlug("attachment id");
        invalidMediaOptions.setContentType("junt/test");
        class ReadableStream
        extends InputStream {
            byte[] bytes;
            int index;

            ReadableStream(String content) {
                this.bytes = content.getBytes();
                this.index = 0;
            }

            @Override
            public int read() throws IOException {
                if (this.index < this.bytes.length) {
                    return this.bytes[this.index++];
                }
                return -1;
            }
        }
        ReadableStream mediaStream = new ReadableStream("stream content.");
        try {
            client.createAttachment(document.getSelfLink(), mediaStream, invalidMediaOptions);
            Assert.assertTrue((boolean)false);
        }
        catch (DocumentClientException e) {
            Assert.assertEquals((long)400L, (long)e.getStatusCode());
            Assert.assertEquals((Object)"BadRequest", (Object)e.getError().getCode());
        }
        mediaStream = new ReadableStream("stream content.");
        Attachment validAttachment = client.createAttachment(document.getSelfLink(), mediaStream, validMediaOptions).getResource();
        Assert.assertEquals((Object)"attachment id", (Object)validAttachment.getId());
        mediaStream = new ReadableStream("stream content");
        try {
            client.createAttachment(document.getSelfLink(), mediaStream, validMediaOptions);
            Assert.fail((String)"Exception didn't happen.");
        }
        catch (DocumentClientException e) {
            Assert.assertEquals((long)409L, (long)e.getStatusCode());
            Assert.assertEquals((Object)"Conflict", (Object)e.getError().getCode());
        }
        Attachment attachmentDefinition = new Attachment("{  'id': 'dynamic attachment',  'media': 'http://xstore.',  'MediaType': 'Book',  'Author': 'My Book Author',  'Title': 'My Book Title',  'contentType': 'application/text'}");
        Attachment attachment = client.createAttachment(document.getSelfLink(), attachmentDefinition, null).getResource();
        Assert.assertEquals((Object)"Book", (Object)attachment.getString("MediaType"));
        Assert.assertEquals((Object)"My Book Author", (Object)attachment.getString("Author"));
        FeedOptions fo = new FeedOptions();
        fo.setPageSize(1);
        attachments = client.readAttachments(document.getSelfLink(), fo).getQueryIterable().toList();
        Assert.assertEquals((long)2L, (long)attachments.size());
        attachment.set("Author", "new author");
        client.replaceAttachment(attachment, null);
        Assert.assertEquals((Object)"Book", (Object)attachment.getString("MediaType"));
        Assert.assertEquals((Object)"new author", (Object)attachment.getString("Author"));
        InputStream mediaResponse = client.readMedia(validAttachment.getMediaLink()).getMedia();
        Assert.assertEquals((Object)"stream content.", (Object)GatewayTests.getStringFromInputStream(mediaResponse));
        mediaStream = new ReadableStream("updated stream content");
        client.updateMedia(validAttachment.getMediaLink(), mediaStream, validMediaOptions);
        mediaResponse = client.readMedia(validAttachment.getMediaLink()).getMedia();
        Assert.assertEquals((Object)"updated stream content", (Object)GatewayTests.getStringFromInputStream(mediaResponse));
        ConnectionPolicy streamPolicy = new ConnectionPolicy();
        streamPolicy.setMediaReadMode(MediaReadMode.Streamed);
        client = new DocumentClient(HOST, MASTER_KEY, streamPolicy, ConsistencyLevel.Session);
        mediaResponse = client.readMedia(validAttachment.getMediaLink()).getMedia();
        Assert.assertEquals((Object)"updated stream content", (Object)GatewayTests.getStringFromInputStream(mediaResponse));
        documentDefinition = new Document("{'id': 'document 2'}");
        document = client.createDocument(this.collectionForTest.getSelfLink(), documentDefinition, null, false).getResource();
        String secondAttachmentJson = String.format("{  'id': '%s',  'contentType': '%s',  'media': '%s', }", validAttachment.getId(), validAttachment.getContentType(), validAttachment.getMediaLink());
        Attachment secondAttachmentDefinition = new Attachment(secondAttachmentJson);
        attachment = client.createAttachment(document.getSelfLink(), secondAttachmentDefinition, null).getResource();
        Assert.assertEquals((Object)validAttachment.getId(), (Object)attachment.getId());
        Assert.assertEquals((Object)validAttachment.getMediaLink(), (Object)attachment.getMediaLink());
        Assert.assertEquals((Object)validAttachment.getContentType(), (Object)attachment.getContentType());
        client.deleteAttachment(attachment.getSelfLink(), null);
        attachments = client.readAttachments(document.getSelfLink(), null).getQueryIterable().toList();
        Assert.assertEquals((long)0L, (long)attachments.size());
    }

    @Test
    public void testTriggerCrud() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        Trigger triggerDef = new Trigger();
        triggerDef.setId(GatewayTests.getUID());
        triggerDef.setTriggerType(TriggerType.Pre);
        triggerDef.setTriggerOperation(TriggerOperation.All);
        triggerDef.setBody("function() {var x = 10;}");
        Trigger newTrigger = client.createTrigger(this.collectionForTest.getSelfLink(), triggerDef, null).getResource();
        Assert.assertNotNull((Object)newTrigger.getBody());
        Assert.assertNotNull((Object)newTrigger.getETag());
        RequestOptions options = new RequestOptions();
        ArrayList<String> preTriggerInclude = new ArrayList<String>();
        preTriggerInclude.add(newTrigger.getId());
        options.setPreTriggerInclude(preTriggerInclude);
        Document document = new Document();
        document.setId("noname");
        client.createDocument(this.collectionForTest.getSelfLink(), document, options, false);
        String id = GatewayTests.getUID();
        newTrigger.setId(id);
        newTrigger = client.replaceTrigger(newTrigger, null).getResource();
        Assert.assertEquals((Object)newTrigger.getId(), (Object)id);
        newTrigger = client.readTrigger(newTrigger.getSelfLink(), null).getResource();
        List<Trigger> triggers = client.readTriggers(this.collectionForTest.getSelfLink(), null).getQueryIterable().toList();
        if (triggers.size() <= 0) {
            Assert.fail((String)"Readfeeds fail to find trigger");
        }
        triggers = client.queryTriggers(this.collectionForTest.getSelfLink(), String.format("SELECT * FROM root r WHERE r.id='%s'", newTrigger.getId()), null).getQueryIterable().toList();
        if (triggers.size() <= 0) {
            Assert.fail((String)"Query fail to find trigger");
        }
        client.deleteTrigger(newTrigger.getSelfLink(), null);
    }

    @Test
    public void testStoredProcedureCrud() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        StoredProcedure storedProcedureDef = new StoredProcedure();
        storedProcedureDef.setId(GatewayTests.getUID());
        storedProcedureDef.setBody("function() {var x = 10;}");
        StoredProcedure newStoredProcedure = client.createStoredProcedure(this.collectionForTest.getSelfLink(), storedProcedureDef, null).getResource();
        Assert.assertNotNull((Object)newStoredProcedure.getBody());
        Assert.assertNotNull((Object)newStoredProcedure.getETag());
        String id = GatewayTests.getUID();
        newStoredProcedure.setId(id);
        newStoredProcedure = client.replaceStoredProcedure(newStoredProcedure, null).getResource();
        Assert.assertEquals((Object)newStoredProcedure.getId(), (Object)id);
        newStoredProcedure = client.readStoredProcedure(newStoredProcedure.getSelfLink(), null).getResource();
        List<StoredProcedure> storedProcedures = client.readStoredProcedures(this.collectionForTest.getSelfLink(), null).getQueryIterable().toList();
        if (storedProcedures.size() <= 0) {
            Assert.fail((String)"Readfeeds fail to find StoredProcedure");
        }
        storedProcedures = client.queryStoredProcedures(this.collectionForTest.getSelfLink(), String.format("SELECT * FROM root r WHERE r.id='%s'", newStoredProcedure.getId()), null).getQueryIterable().toList();
        if (storedProcedures.size() <= 0) {
            Assert.fail((String)"Query fail to find StoredProcedure");
        }
        client.deleteStoredProcedure(newStoredProcedure.getSelfLink(), null);
    }

    @Test
    public void testStoredProcedureFunctionality() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        StoredProcedure sproc1 = new StoredProcedure("{  'id': 'storedProcedure1',  'body':    'function () {      for (var i = 0; i < 1000; i++) {        var item = getContext().getResponse().getBody();        if (i > 0 && item != i - 1) throw \"body mismatch\";        getContext().getResponse().setBody(i);      }    }'}");
        StoredProcedure retrievedSproc = client.createStoredProcedure(this.collectionForTest.getSelfLink(), sproc1, null).getResource();
        String result = client.executeStoredProcedure(retrievedSproc.getSelfLink(), null).getResponseAsString();
        Assert.assertEquals((Object)"999", (Object)result);
        StoredProcedure sproc2 = new StoredProcedure("{  'id': 'storedProcedure2',  'body':    'function () {      for (var i = 0; i < 10; i++) {        getContext().getResponse().appendValue(\"Body\", i);      }    }'}");
        StoredProcedure retrievedSproc2 = client.createStoredProcedure(this.collectionForTest.getSelfLink(), sproc2, null).getResource();
        result = client.executeStoredProcedure(retrievedSproc2.getSelfLink(), null).getResponseAsString();
        Assert.assertEquals((Object)"\"0123456789\"", (Object)result);
        StoredProcedure sproc3 = new StoredProcedure("{  'id': 'storedProcedure3',  'body':    'function (value, num) {      getContext().getResponse().setBody(          \"a\" + value + num * 2);    }'}");
        StoredProcedure retrievedSproc3 = client.createStoredProcedure(this.collectionForTest.getSelfLink(), sproc3, null).getResource();
        result = client.executeStoredProcedure(retrievedSproc3.getSelfLink(), new Object[]{"so", 123}).getResponseAsString();
        Assert.assertEquals((Object)"\"aso246\"", (Object)result);
        class TempPOJO {
            public String temp = "so2";

            TempPOJO() {
            }
        }
        TempPOJO tempPOJO = new TempPOJO();
        StoredProcedure sproc4 = new StoredProcedure("{  'id': 'storedProcedure4',  'body':    'function (value) {      getContext().getResponse().setBody(          \"a\" + value.temp);    }'}");
        StoredProcedure retrievedSproc4 = client.createStoredProcedure(this.collectionForTest.getSelfLink(), sproc4, null).getResource();
        result = client.executeStoredProcedure(retrievedSproc4.getSelfLink(), new Object[]{tempPOJO}).getResponseAsString();
        Assert.assertEquals((Object)"\"aso2\"", (Object)result);
        JSONObject jsonObject = new JSONObject("{'temp': 'so3'}");
        result = client.executeStoredProcedure(retrievedSproc4.getSelfLink(), new Object[]{jsonObject}).getResponseAsString();
        Assert.assertEquals((Object)"\"aso3\"", (Object)result);
        Document document = new Document("{'temp': 'so4'}");
        result = client.executeStoredProcedure(retrievedSproc4.getSelfLink(), new Object[]{document}).getResponseAsString();
        Assert.assertEquals((Object)"\"aso4\"", (Object)result);
    }

    @Test
    public void testUserDefinedFunctionCrud() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        UserDefinedFunction udfDef = new UserDefinedFunction();
        udfDef.setId(GatewayTests.getUID());
        udfDef.setBody("function() {var x = 10;}");
        UserDefinedFunction newUdf = client.createUserDefinedFunction(this.collectionForTest.getSelfLink(), udfDef, null).getResource();
        Assert.assertNotNull((Object)newUdf.getBody());
        Assert.assertNotNull((Object)newUdf.getETag());
        String id = GatewayTests.getUID();
        newUdf.setId(id);
        newUdf = client.replaceUserDefinedFunction(newUdf, null).getResource();
        Assert.assertEquals((Object)newUdf.getId(), (Object)id);
        newUdf = client.readUserDefinedFunction(newUdf.getSelfLink(), null).getResource();
        Assert.assertEquals((Object)newUdf.getId(), (Object)id);
        List<UserDefinedFunction> udfs = client.readUserDefinedFunctions(this.collectionForTest.getSelfLink(), null).getQueryIterable().toList();
        if (udfs.size() <= 0) {
            Assert.fail((String)"Readfeeds fail to find UserDefinedFunction");
        }
        udfs = client.queryUserDefinedFunctions(this.collectionForTest.getSelfLink(), String.format("SELECT * FROM root r WHERE r.id='%s'", newUdf.getId()), null).getQueryIterable().toList();
        if (udfs.size() <= 0) {
            Assert.fail((String)"Query fail to find UserDefinedFunction");
        }
        client.deleteUserDefinedFunction(newUdf.getSelfLink(), null);
    }

    @Test
    public void testUserCrud() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        List<User> users = client.readUsers(this.databaseForTest.getSelfLink(), null).getQueryIterable().toList();
        int beforeCreateCount = users.size();
        User user = client.createUser(this.databaseForTest.getSelfLink(), new User("{ 'id': 'new user' }"), null).getResource();
        Assert.assertEquals((Object)"new user", (Object)user.getId());
        users = client.readUsers(this.databaseForTest.getSelfLink(), null).getQueryIterable().toList();
        Assert.assertEquals((long)(beforeCreateCount + 1), (long)users.size());
        users = client.queryUsers(this.databaseForTest.getSelfLink(), "SELECT * FROM root r WHERE r.id='new user'", null).getQueryIterable().toList();
        Assert.assertEquals((long)1L, (long)users.size());
        user.setId("replaced user");
        User replacedUser = client.replaceUser(user, null).getResource();
        Assert.assertEquals((Object)"replaced user", (Object)replacedUser.getId());
        Assert.assertEquals((Object)user.getId(), (Object)replacedUser.getId());
        user = client.readUser(replacedUser.getSelfLink(), null).getResource();
        Assert.assertEquals((Object)replacedUser.getId(), (Object)user.getId());
        client.deleteUser(user.getSelfLink(), null);
        try {
            client.readUser(user.getSelfLink(), null);
            Assert.fail((String)"Exception didn't happen.");
        }
        catch (DocumentClientException e) {
            Assert.assertEquals((long)404L, (long)e.getStatusCode());
            Assert.assertEquals((Object)"NotFound", (Object)e.getError().getCode());
        }
    }

    @Test
    public void testPermissionCrud() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        User user = client.createUser(this.databaseForTest.getSelfLink(), new User("{ 'id': 'new user' }"), null).getResource();
        List<Permission> permissions = client.readPermissions(user.getSelfLink(), null).getQueryIterable().toList();
        int beforeCreateCount = permissions.size();
        Permission permissionDefinition = new Permission();
        permissionDefinition.setId("new permission");
        permissionDefinition.setPermissionMode(PermissionMode.Read);
        permissionDefinition.setResourceLink("dbs/AQAAAA==/colls/AQAAAJ0fgTc=");
        Permission permission = client.createPermission(user.getSelfLink(), permissionDefinition, null).getResource();
        Assert.assertEquals((Object)"new permission", (Object)permission.getId());
        permissions = client.readPermissions(user.getSelfLink(), null).getQueryIterable().toList();
        Assert.assertEquals((long)(beforeCreateCount + 1), (long)permissions.size());
        permissions = client.queryPermissions(user.getSelfLink(), String.format("SELECT * FROM root r WHERE r.id='%s'", permission.getId()), null).getQueryIterable().toList();
        Assert.assertEquals((long)1L, (long)permissions.size());
        permission.setId("replaced permission");
        Permission replacedPermission = client.replacePermission(permission, null).getResource();
        Assert.assertEquals((Object)"replaced permission", (Object)replacedPermission.getId());
        Assert.assertEquals((Object)permission.getId(), (Object)replacedPermission.getId());
        permission = client.readPermission(replacedPermission.getSelfLink(), null).getResource();
        Assert.assertEquals((Object)replacedPermission.getId(), (Object)permission.getId());
        client.deletePermission(replacedPermission.getSelfLink(), null);
        try {
            client.readPermission(permission.getSelfLink(), null);
            Assert.fail((String)"Exception didn't happen.");
        }
        catch (DocumentClientException e) {
            Assert.assertEquals((long)404L, (long)e.getStatusCode());
            Assert.assertEquals((Object)"NotFound", (Object)e.getError().getCode());
        }
    }

    @Test
    public void testDatabaseAccount() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        DatabaseAccount dba = client.getDatabaseAccount();
        Assert.assertNotNull((String)"dba Address link works", (Object)dba.getAddressesLink());
        Assert.assertTrue((String)"provision storage must larger than 10000MB", (dba.getProvisionedDocumentStorageInMB() > 10000L ? 1 : 0) != 0);
        if (dba.getConsistencyPolicy().getDefaultConsistencyLevel() == ConsistencyLevel.BoundedStaleness) {
            Assert.assertTrue((String)"StaleInternal should be larger than 5 seconds", (dba.getConsistencyPolicy().getMaxStalenessIntervalInSeconds() >= 5 ? 1 : 0) != 0);
            Assert.assertTrue((String)"StaleInternal boundness should be larger than 10", (dba.getConsistencyPolicy().getMaxStalenessPrefix() >= 10 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAuthorization() throws DocumentClientException {
        DocumentClient client = new DocumentClient(HOST, MASTER_KEY, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        Document document1 = client.createDocument(this.collectionForTest.getSelfLink(), new Document("{ 'id': 'coll1doc1', 'spam': 'eggs', 'key': 'value' }"), null, false).getResource();
        Document document2 = client.createDocument(this.collectionForTest.getSelfLink(), new Document("{ 'id': 'coll1doc2', 'spam': 'eggs2', 'key': 'value2' }"), null, false).getResource();
        DocumentCollection anotherCollectionForTest = client.createCollection(this.databaseForTest.getSelfLink(), new DocumentCollection("{ 'id': 'sample collection2' }"), null).getResource();
        User user1 = client.createUser(this.databaseForTest.getSelfLink(), new User("{ 'id': 'user1' }"), null).getResource();
        Permission permission1Definition = new Permission(String.format("{  'id': 'permission On Coll1',  'permissionMode': 'Read',  'resource': '%s'}", this.collectionForTest.getSelfLink()));
        Permission permission1 = client.createPermission(user1.getSelfLink(), permission1Definition, null).getResource();
        User user2 = client.createUser(this.databaseForTest.getSelfLink(), new User("{ 'id': 'user2' }"), null).getResource();
        Permission permission2Definition = new Permission(String.format("{  'id': 'permission On coll2',  'permissionMode': 'All',  'resource': '%s'}", anotherCollectionForTest.getSelfLink()));
        Permission permission2 = client.createPermission(user2.getSelfLink(), permission2Definition, null).getResource();
        DocumentClient badClient = new DocumentClient(HOST, "", ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        try {
            badClient.readDatabases(null).getQueryIterable().toList();
            Assert.fail((String)"Exception didn't happen.");
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<Permission> resourceTokens1 = new ArrayList<Permission>();
        resourceTokens1.add(permission1);
        DocumentClient clientForCollection1 = new DocumentClient(HOST, resourceTokens1, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        DocumentCollection obtainedCollection1 = clientForCollection1.readCollection(this.collectionForTest.getSelfLink(), null).getResource();
        try {
            clientForCollection1.deleteCollection(obtainedCollection1.getSelfLink(), null);
            Assert.fail((String)"Exception didn't happen.");
        }
        catch (DocumentClientException e) {
            Assert.assertEquals((long)403L, (long)e.getStatusCode());
            Assert.assertEquals((Object)"Forbidden", (Object)e.getError().getCode());
        }
        Assert.assertEquals((String)"Expected 2 Documents to be succesfully read", (long)2L, (long)clientForCollection1.readDocuments(obtainedCollection1.getSelfLink(), null).getQueryIterable().toList().size());
        Document successDoc = clientForCollection1.readDocument(document1.getSelfLink(), null).getResource();
        Assert.assertEquals((String)"Expected to read children using parent permissions", (Object)document1.getId(), (Object)successDoc.getId());
        ArrayList<Permission> resourceTokens2 = new ArrayList<Permission>();
        resourceTokens2.add(permission2);
        DocumentClient clientForCollection2 = new DocumentClient(HOST, resourceTokens2, ConnectionPolicy.GetDefault(), ConsistencyLevel.Session);
        Document newDocument2 = new Document(String.format("{  'CustomProperty1': 'BBBBBB',  'customProperty2': 1000,  'id': '%s'}", document2.getId()));
        successDoc = clientForCollection2.createDocument(anotherCollectionForTest.getSelfLink(), newDocument2, null, true).getResource();
        Assert.assertEquals((String)"document should have been created successfully", (Object)"BBBBBB", (Object)successDoc.getString("CustomProperty1"));
    }

    private static String getUID() {
        UUID u = UUID.randomUUID();
        return "" + u.getMostSignificantBits() + Math.abs(u.getLeastSignificantBits());
    }

    class TestPOJO {
        private String privateStringProperty;
        public String id;
        public int intProperty;
        public String stringProperty;
        public TestPOJOInner objectProperty;
        public List<String> stringList;
        public String[] stringArray;

        public TestPOJO(int i) {
            this.intProperty = i;
            this.stringList = new ArrayList<String>();
            this.stringList.add("ONE");
            this.stringList.add("TWO");
            this.stringList.add("THREE");
            this.stringArray = new String[]{"One", "Two", "Three"};
        }

        public String getPrivateStringProperty() {
            return this.privateStringProperty;
        }

        public void setPrivateStringProperty(String value) {
            this.privateStringProperty = value;
        }
    }

    class TestPOJOInner {
        public int intProperty;

        public TestPOJOInner(int i) {
            this.intProperty = i;
        }
    }

    static class StaticPOJOForTest {
        public String pojoProp = "456";

        StaticPOJOForTest() {
        }
    }
}

