/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.ClientConstants;
import com.microsoft.azure.servicebus.ClientEntity;
import com.microsoft.azure.servicebus.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.ExceptionUtil;
import com.microsoft.azure.servicebus.IConnectionFactory;
import com.microsoft.azure.servicebus.ITimeoutErrorHandler;
import com.microsoft.azure.servicebus.RetryPolicy;
import com.microsoft.azure.servicebus.ServiceBusException;
import com.microsoft.azure.servicebus.StringUtil;
import com.microsoft.azure.servicebus.TimeoutException;
import com.microsoft.azure.servicebus.TimeoutTracker;
import com.microsoft.azure.servicebus.Timer;
import com.microsoft.azure.servicebus.TimerType;
import com.microsoft.azure.servicebus.amqp.BaseLinkHandler;
import com.microsoft.azure.servicebus.amqp.ConnectionHandler;
import com.microsoft.azure.servicebus.amqp.IAmqpConnection;
import com.microsoft.azure.servicebus.amqp.ProtonUtil;
import com.microsoft.azure.servicebus.amqp.ReactorHandler;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.HandlerException;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.reactor.Reactor;

public class MessagingFactory
extends ClientEntity
implements IAmqpConnection,
IConnectionFactory,
ITimeoutErrorHandler {
    public static final Duration DefaultOperationTimeout = Duration.ofSeconds(60L);
    private static final Logger TRACE_LOGGER = Logger.getLogger("servicebus.trace");
    private static final int TIMEOUT_ERROR_THRESHOLD_IN_SECS = 100000;
    private final Object connectionLock = new Object();
    private final String hostName;
    private final CompletableFuture<Void> closeTask;
    private final ConnectionHandler connectionHandler;
    private final ReactorHandler reactorHandler;
    private final LinkedList<Link> registeredLinks;
    private Reactor reactor;
    private Thread reactorThread;
    private Connection connection;
    private boolean waitingConnectionOpen;
    private Duration operationTimeout;
    private RetryPolicy retryPolicy;
    private CompletableFuture<MessagingFactory> open;
    private CompletableFuture<Connection> openConnection;
    private TimeoutTracker connectionCreateTracker;
    private Instant timeoutErrorStart;
    private Object resetConnectionSync;

    MessagingFactory(ConnectionStringBuilder builder) {
        super("MessagingFactory".concat(StringUtil.getRandomString()), null);
        Timer.register(this.getClientId());
        this.hostName = builder.getEndpoint().getHost();
        this.timeoutErrorStart = Instant.MAX;
        this.operationTimeout = builder.getOperationTimeout();
        this.retryPolicy = builder.getRetryPolicy();
        this.registeredLinks = new LinkedList();
        this.resetConnectionSync = new Object();
        this.closeTask = new CompletableFuture();
        this.connectionHandler = new ConnectionHandler(this, builder.getEndpoint().getHost(), builder.getSasKeyName(), builder.getSasKey());
        this.reactorHandler = new ReactorHandler(){

            @Override
            public void onReactorInit(Event e) {
                super.onReactorInit(e);
                Reactor reactor = e.getReactor();
                MessagingFactory.this.connection = reactor.connection((Handler)MessagingFactory.this.connectionHandler);
            }
        };
    }

    String getHostName() {
        return this.hostName;
    }

    private void createConnection(ConnectionStringBuilder builder) throws IOException {
        this.open = new CompletableFuture();
        this.waitingConnectionOpen = true;
        this.startReactor(this.reactorHandler);
    }

    private void startReactor(ReactorHandler reactorHandler) throws IOException {
        this.reactor = ProtonUtil.reactor(reactorHandler);
        this.reactorThread = new Thread(new RunReactor(this.reactor));
        this.reactorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Connection> getConnection() {
        if (this.connection.getLocalState() == EndpointState.CLOSED || this.connectionCreateTracker != null && !this.connectionCreateTracker.remaining().minus(ClientConstants.TIMER_TOLERANCE).isNegative()) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connection.getLocalState() == EndpointState.CLOSED && !this.waitingConnectionOpen || this.connectionCreateTracker != null && !this.connectionCreateTracker.remaining().minus(ClientConstants.TIMER_TOLERANCE).isNegative()) {
                    try {
                        this.startReactor(this.reactorHandler);
                    }
                    catch (IOException e) {
                        this.onReactorError(new ServiceBusException(true, (Throwable)e));
                    }
                    if (this.openConnection != null && !this.openConnection.isDone()) {
                        this.openConnection.completeExceptionally(new TimeoutException(String.format(Locale.US, "Connection creation timedout, %s", ExceptionUtil.getTrackingIDAndTimeToLog())));
                    }
                    this.openConnection = new CompletableFuture();
                    this.connectionCreateTracker = TimeoutTracker.create(this.operationTimeout);
                    this.waitingConnectionOpen = true;
                }
            }
        }
        return this.openConnection == null ? CompletableFuture.completedFuture(this.connection) : this.openConnection;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public static CompletableFuture<MessagingFactory> createFromConnectionString(String connectionString) throws IOException {
        ConnectionStringBuilder builder = new ConnectionStringBuilder(connectionString);
        MessagingFactory messagingFactory = new MessagingFactory(builder);
        messagingFactory.createConnection(builder);
        return messagingFactory.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOpenComplete(Exception exception) {
        Object object = this.connectionLock;
        synchronized (object) {
            this.waitingConnectionOpen = false;
        }
        if (exception == null) {
            this.open.complete(this);
            if (this.openConnection != null) {
                this.openConnection.complete(this.connection);
            }
        } else {
            this.open.completeExceptionally(exception);
            if (this.openConnection != null) {
                this.openConnection.completeExceptionally(exception);
            }
        }
    }

    @Override
    public void onConnectionError(ErrorCondition error) {
        if (this.reactorThread != null && !this.reactorThread.isInterrupted()) {
            this.reactorThread.interrupt();
        }
        if (!this.open.isDone()) {
            this.onOpenComplete(ExceptionUtil.toException(error));
        } else {
            Connection currentConnection = this.connection;
            for (Link link : this.registeredLinks) {
                if (link.getLocalState() == EndpointState.CLOSED) continue;
                link.close();
            }
            if (currentConnection.getLocalState() != EndpointState.CLOSED) {
                currentConnection.close();
            }
            for (Link link : this.registeredLinks) {
                Handler handler = BaseHandler.getHandler((Extendable)link);
                if (handler == null || !(handler instanceof BaseLinkHandler)) continue;
                BaseLinkHandler linkHandler = (BaseLinkHandler)handler;
                linkHandler.processOnClose(link, error);
            }
        }
        if (this.getIsClosingOrClosed() && !this.closeTask.isDone()) {
            this.closeTask.complete(null);
            Timer.unregister(this.getClientId());
        }
    }

    private void onReactorError(Exception cause) {
        if (!this.open.isDone()) {
            this.onOpenComplete(cause);
        } else {
            Connection currentConnection = this.connection;
            for (Link link : this.registeredLinks) {
                if (link.getLocalState() == EndpointState.CLOSED) continue;
                link.close();
            }
            if (currentConnection.getLocalState() != EndpointState.CLOSED) {
                currentConnection.close();
            }
            for (Link link : this.registeredLinks) {
                Handler handler = BaseHandler.getHandler((Extendable)link);
                if (handler == null || !(handler instanceof BaseLinkHandler)) continue;
                BaseLinkHandler linkHandler = (BaseLinkHandler)handler;
                linkHandler.processOnClose(link, cause);
            }
        }
    }

    void resetConnection() {
        this.reactor.free();
        this.onReactorError(new ServiceBusException(true, String.format(Locale.US, "Client invoked connection reset, %s", ExceptionUtil.getTrackingIDAndTimeToLog())));
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        if (!this.getIsClosed() && this.connection != null && this.connection.getRemoteState() != EndpointState.CLOSED) {
            if (this.connection.getLocalState() != EndpointState.CLOSED) {
                this.connection.close();
            }
            Timer.schedule(new Runnable(){

                @Override
                public void run() {
                    if (!MessagingFactory.this.closeTask.isDone()) {
                        MessagingFactory.this.closeTask.completeExceptionally(new TimeoutException("Closing MessagingFactory timed out."));
                    }
                }
            }, this.operationTimeout, TimerType.OneTimeRun);
        }
        return this.closeTask;
    }

    @Override
    public void registerForConnectionError(Link link) {
        this.registeredLinks.add(link);
    }

    @Override
    public void deregisterForConnectionError(Link link) {
        this.registeredLinks.remove(link);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportTimeoutError() {
        if (this.timeoutErrorStart.equals(Instant.MAX)) {
            this.timeoutErrorStart = Instant.now();
        } else if (this.timeoutErrorStart.isBefore(Instant.now().minus(100000L, ChronoUnit.SECONDS))) {
            Object object = this.resetConnectionSync;
            synchronized (object) {
                if (this.timeoutErrorStart.isBefore(Instant.now().minus(100000L, ChronoUnit.SECONDS))) {
                    this.resetTimeoutErrorTracking();
                    this.resetConnection();
                }
            }
        }
    }

    @Override
    public void resetTimeoutErrorTracking() {
        this.timeoutErrorStart = Instant.MAX;
    }

    private class RunReactor
    implements Runnable {
        private final Reactor rctr;

        public RunReactor(Reactor reactor) {
            this.rctr = reactor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                TRACE_LOGGER.log(Level.FINE, "starting reactor instance.");
            }
            try {
                this.rctr.setTimeout(3141L);
                this.rctr.start();
                while (!Thread.interrupted() && this.rctr.process()) {
                }
                this.rctr.stop();
            }
            catch (HandlerException handlerException) {
                HandlerException cause = handlerException;
                if (TRACE_LOGGER.isLoggable(Level.WARNING)) {
                    Throwable innerException;
                    StringBuilder builder = new StringBuilder();
                    builder.append("UnHandled exception while processing events in reactor:");
                    builder.append(System.lineSeparator());
                    builder.append(handlerException.getMessage());
                    if (handlerException.getStackTrace() != null) {
                        for (StackTraceElement ste : handlerException.getStackTrace()) {
                            builder.append(System.lineSeparator());
                            builder.append(ste.toString());
                        }
                    }
                    if ((innerException = handlerException.getCause()) != null) {
                        builder.append("Cause: " + innerException.getMessage());
                        if (innerException.getStackTrace() != null) {
                            for (StackTraceElement ste : innerException.getStackTrace()) {
                                builder.append(System.lineSeparator());
                                builder.append(ste.toString());
                            }
                        }
                    }
                    TRACE_LOGGER.log(Level.WARNING, builder.toString());
                }
                MessagingFactory.this.onReactorError(new ServiceBusException(true, String.format(Locale.US, "%s, %s", StringUtil.isNullOrEmpty(cause.getMessage()) ? "Reactor encountered unrecoverable error" : cause.getMessage(), ExceptionUtil.getTrackingIDAndTimeToLog()), cause));
            }
            finally {
                this.rctr.free();
            }
        }
    }
}

