/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import com.microsoft.azure.servicebus.amqp.IAmqpLink;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;

public class BaseLinkHandler
extends BaseHandler {
    protected static final Logger TRACE_LOGGER = Logger.getLogger("servicebus.trace");
    private final IAmqpLink underlyingEntity;

    public BaseLinkHandler(IAmqpLink amqpLink) {
        this.underlyingEntity = amqpLink;
    }

    public void onLinkLocalClose(Event event) {
        Link link = event.getLink();
        if (link != null && TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, String.format("linkName[%s]", link.getName()));
        }
    }

    public void processOnClose(Link link, ErrorCondition condition) {
        if (condition != null && TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, "linkName[" + link.getName() + (condition != null ? "], ErrorCondition[" + condition.getCondition() + ", " + condition.getDescription() + "]" : "], condition[null]"));
        }
        if (link.getLocalState() != EndpointState.CLOSED) {
            link.close();
        }
        this.underlyingEntity.onClose(condition);
    }

    public void processOnClose(Link link, Exception exception) {
        if (link.getLocalState() != EndpointState.CLOSED) {
            link.close();
        }
        this.underlyingEntity.onError(exception);
    }
}

