/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Session;

public class SessionHandler
extends BaseHandler {
    protected static final Logger TRACE_LOGGER = Logger.getLogger("servicebus.trace");
    private final String name;

    public SessionHandler(String name) {
        this.name = name;
    }

    public void onSessionRemoteOpen(Event e) {
        Session session;
        if (TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, String.format(Locale.US, "entityName[%s], sessionIncCapacity[%s], sessionOutgoingWindow[%s]", this.name, e.getSession().getIncomingCapacity(), e.getSession().getOutgoingWindow()));
        }
        if ((session = e.getSession()) != null && session.getLocalState() == EndpointState.UNINITIALIZED) {
            session.open();
        }
    }

    public void onSessionLocalClose(Event e) {
        if (TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, String.format(Locale.US, "entityName[%s], condition[%s]", this.name, e.getSession().getCondition() == null ? "none" : e.getSession().getCondition().toString()));
        }
    }

    public void onSessionRemoteClose(Event e) {
        Session session;
        if (TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, String.format(Locale.US, "entityName[%s], condition[%s]", this.name, e.getSession().getRemoteCondition() == null ? "none" : e.getSession().getRemoteCondition().toString()));
        }
        if ((session = e.getSession()) != null && session.getLocalState() != EndpointState.CLOSED) {
            session.close();
        }
    }

    public void onSessionFinal(Event e) {
        if (TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, String.format(Locale.US, "entityName[%s]", this.name));
        }
    }
}

