/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.maven.appservice.MavenDockerCredentialProvider;
import com.microsoft.azure.maven.function.DeployMojo;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.ContainerAppFunctionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.FlexConsumptionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.StorageAuthenticationMethod;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeploymentSlotSetting;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.RuntimeConfiguration;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.settings.Settings;

public class ConfigParser {
    private final DeployMojo mojo;

    public ConfigParser(DeployMojo mojo) {
        this.mojo = mojo;
    }

    public FunctionAppConfig parseConfig() {
        return (FunctionAppConfig)new FunctionAppConfig().flexConsumptionConfiguration(this.getFlexConsumptionConfiguration()).disableAppInsights(Boolean.valueOf(this.mojo.isDisableAppInsights())).enableDistributedTracing(this.mojo.getEnableDistributedTracing()).appInsightsKey(this.mojo.getAppInsightsKey()).appInsightsInstance(this.mojo.getAppInsightsInstance()).storageAccountName(this.mojo.getStorageAccountName()).storageAccountResourceGroup((String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.mojo.getStorageAccountResourceGroup(), this.mojo.getResourceGroup()})).environment(this.mojo.getEnvironment()).containerConfiguration(this.getContainerConfiguration()).subscriptionId(this.mojo.getSubscriptionId()).resourceGroup(this.mojo.getResourceGroup()).appName(this.mojo.getAppName()).servicePlanName(this.mojo.getAppServicePlanName()).servicePlanResourceGroup(this.mojo.getAppServicePlanResourceGroup()).deploymentSlotName(this.getDeploymentSlotName()).deploymentSlotConfigurationSource(this.getDeploymentSlotConfigurationSource()).pricingTier(this.getParsedPricingTier()).region(this.getParsedRegion()).runtime(this.getRuntimeConfig()).appSettings(this.mojo.getAppSettings());
    }

    private ContainerAppFunctionConfiguration getContainerConfiguration() {
        return ContainerAppFunctionConfiguration.builder().minReplicas(this.mojo.getMinReplicas()).maxReplicas(this.mojo.getMaxReplicas()).workloadProfileMame(this.mojo.getWorkloadProfileName()).cpu((Double)Optional.ofNullable(this.mojo.getCpu()).filter(StringUtils::isNotBlank).map(Double::valueOf).orElse(null)).memory(this.mojo.getMemory()).build();
    }

    public FlexConsumptionConfiguration getFlexConsumptionConfiguration() {
        return FlexConsumptionConfiguration.builder().alwaysReadyInstances(this.mojo.getAlwaysReadyInstances()).instanceSize(this.mojo.getInstanceMemory()).httpInstanceConcurrency(this.mojo.getHttpInstanceConcurrency()).maximumInstances(this.mojo.getMaximumInstances()).deploymentAccount(this.mojo.getDeploymentStorageAccount()).deploymentResourceGroup(this.mojo.getDeploymentStorageResourceGroup()).deploymentContainer(this.mojo.getDeploymentStorageContainer()).authenticationMethod(StorageAuthenticationMethod.fromString((String)this.mojo.getStorageAuthenticationMethod())).userAssignedIdentityResourceId(this.mojo.getUserAssignedIdentityResourceId()).storageAccountConnectionString(this.mojo.getStorageAccountConnectionString()).build();
    }

    public AppServicePlan getServicePlan() {
        String subscriptionId = this.mojo.getSubscriptionId();
        String servicePlan = this.mojo.getAppServicePlanName();
        String servicePlanGroup = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.mojo.getAppServicePlanResourceGroup(), this.mojo.getResourceGroup()});
        return StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{subscriptionId, servicePlan, servicePlanGroup}) ? null : (AppServicePlan)((AzureAppService)Azure.az(AzureAppService.class)).plans(subscriptionId).get(servicePlan, servicePlanGroup);
    }

    public RuntimeConfig getRuntimeConfig() {
        RuntimeConfiguration runtime = this.mojo.getRuntimeConfiguration();
        if (runtime == null) {
            return null;
        }
        OperatingSystem os = Optional.ofNullable(runtime.getOs()).map(OperatingSystem::fromString).orElseGet(() -> Optional.ofNullable(this.getServicePlan()).map(AppServicePlan::getOperatingSystem).orElse(null));
        String javaVersion = runtime.getJavaVersion();
        RuntimeConfig result = new RuntimeConfig().os(os).javaVersion(javaVersion).image(runtime.getImage()).registryUrl(runtime.getRegistryUrl());
        if (StringUtils.isNotEmpty((CharSequence)runtime.getServerId())) {
            MavenDockerCredentialProvider credentialProvider = MavenDockerCredentialProvider.fromMavenSettings((Settings)this.mojo.getSettings(), (String)runtime.getServerId());
            result.username(credentialProvider.getUsername()).password(credentialProvider.getPassword());
        }
        return result;
    }

    private String getDeploymentSlotName() {
        return Optional.ofNullable(this.mojo.getDeploymentSlotSetting()).map(DeploymentSlotSetting::getName).orElse(null);
    }

    private String getDeploymentSlotConfigurationSource() {
        return Optional.ofNullable(this.mojo.getDeploymentSlotSetting()).map(DeploymentSlotSetting::getConfigurationSource).orElse(null);
    }

    private Region getParsedRegion() {
        return Optional.ofNullable(this.mojo.getRegion()).map(Region::fromName).orElse(null);
    }

    private PricingTier getParsedPricingTier() {
        return Optional.ofNullable(this.mojo.getPricingTier()).map(PricingTier::fromString).orElseGet(() -> Optional.ofNullable(this.getServicePlan()).map(AppServicePlan::getPricingTier).orElse(null));
    }
}

