/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.models;

import java.io.IOException;
import java.util.Date;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class KeyAttributes {
    @JsonProperty(value="nbf")
    private Long notBeforeUnixTime = null;
    @JsonProperty(value="exp")
    private Long expiresUnixTime = null;
    @JsonProperty(value="created")
    private Long createdUnixTime = null;
    @JsonProperty(value="updated")
    private Long updatedUnixTime = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabledValue) {
        this.enabled = enabledValue;
    }

    public Long getNotBeforeUnixTime() {
        return this.notBeforeUnixTime;
    }

    public void setNotBeforeUnixTime(Long notBeforeUnixTime) {
        this.notBeforeUnixTime = notBeforeUnixTime;
    }

    public Date getNotBefore() {
        return KeyAttributes.fromUnixTime(this.notBeforeUnixTime);
    }

    public void setNotBefore(Date notBeforeValue) {
        this.notBeforeUnixTime = KeyAttributes.toUnixTime(notBeforeValue);
    }

    public Long getExpiresUnixTime() {
        return this.expiresUnixTime;
    }

    public void setExpiresUnixTime(Long expiresUnixTime) {
        this.expiresUnixTime = expiresUnixTime;
    }

    public Date getExpires() {
        return KeyAttributes.fromUnixTime(this.expiresUnixTime);
    }

    public void setExpires(Date expiresValue) {
        this.expiresUnixTime = KeyAttributes.toUnixTime(expiresValue);
    }

    public Long getCreatedUnixTime() {
        return this.createdUnixTime;
    }

    public void setCreatedUnixTime(Long createdUnixTime) {
        this.createdUnixTime = createdUnixTime;
    }

    public Date getCreated() {
        return KeyAttributes.fromUnixTime(this.createdUnixTime);
    }

    public Long getUpdatedUnixTime() {
        return this.updatedUnixTime;
    }

    public void setUpdatedUnixTime(Long updatedUnixTime) {
        this.updatedUnixTime = updatedUnixTime;
    }

    public Date getUpdated() {
        return KeyAttributes.fromUnixTime(this.updatedUnixTime);
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Date fromUnixTime(Long unixTime) {
        if (unixTime == null) {
            return null;
        }
        return new Date(unixTime * 1000L);
    }

    private static Long toUnixTime(Date value) {
        if (value == null) {
            return null;
        }
        return value.getTime() / 1000L;
    }
}

