// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator

package com.microsoft.azure.keyvault;

import java.util.List;
import java.util.Map;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.keyvault.models.BackupCertificateResult;
import com.microsoft.azure.keyvault.models.BackupKeyResult;
import com.microsoft.azure.keyvault.models.BackupSecretResult;
import com.microsoft.azure.keyvault.models.BackupStorageResult;
import com.microsoft.azure.keyvault.models.CertificateAttributes;
import com.microsoft.azure.keyvault.models.CertificateBundle;
import com.microsoft.azure.keyvault.models.CertificateIssuerItem;
import com.microsoft.azure.keyvault.models.CertificateItem;
import com.microsoft.azure.keyvault.models.CertificateOperation;
import com.microsoft.azure.keyvault.models.CertificatePolicy;
import com.microsoft.azure.keyvault.models.Contacts;
import com.microsoft.azure.keyvault.models.DeletedCertificateBundle;
import com.microsoft.azure.keyvault.models.DeletedCertificateItem;
import com.microsoft.azure.keyvault.models.DeletedKeyBundle;
import com.microsoft.azure.keyvault.models.DeletedKeyItem;
import com.microsoft.azure.keyvault.models.DeletedSasDefinitionBundle;
import com.microsoft.azure.keyvault.models.DeletedSasDefinitionItem;
import com.microsoft.azure.keyvault.models.DeletedSecretBundle;
import com.microsoft.azure.keyvault.models.DeletedSecretItem;
import com.microsoft.azure.keyvault.models.DeletedStorageAccountItem;
import com.microsoft.azure.keyvault.models.DeletedStorageBundle;
import com.microsoft.azure.keyvault.models.IssuerAttributes;
import com.microsoft.azure.keyvault.models.IssuerBundle;
import com.microsoft.azure.keyvault.models.IssuerCredentials;
import com.microsoft.azure.keyvault.models.JsonWebKeyCurveName;
import com.microsoft.azure.keyvault.models.KeyAttributes;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyItem;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.azure.keyvault.models.KeyVaultErrorException;
import com.microsoft.azure.keyvault.models.KeyVerifyResult;
import com.microsoft.azure.keyvault.models.OrganizationDetails;
import com.microsoft.azure.keyvault.models.SasDefinitionAttributes;
import com.microsoft.azure.keyvault.models.SasDefinitionBundle;
import com.microsoft.azure.keyvault.models.SasDefinitionItem;
import com.microsoft.azure.keyvault.models.SasTokenType;
import com.microsoft.azure.keyvault.models.SecretAttributes;
import com.microsoft.azure.keyvault.models.SecretBundle;
import com.microsoft.azure.keyvault.models.SecretItem;
import com.microsoft.azure.keyvault.models.StorageAccountAttributes;
import com.microsoft.azure.keyvault.models.StorageAccountItem;
import com.microsoft.azure.keyvault.models.StorageBundle;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyEncryptionAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyOperation;
import com.microsoft.azure.keyvault.webkey.JsonWebKeySignatureAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyType;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;

import rx.Observable;

/**
 * The interface for KeyVaultClientBase class.
 */
public interface KeyVaultClientBase {
    /**
     * Gets the REST client.
     *
     * @return the {@link RestClient} object.
    */
    RestClient restClient();

    /**
     * Gets the {@link AzureClient} used for long running operations.
     * @return the azure client;
     */
    AzureClient getAzureClient();

    /**
     * Gets the User-Agent header for the client.
     *
     * @return the user agent string.
     */
    String userAgent();

    /**
     * Gets Client API version..
     *
     * @return the apiVersion value.
     */
    String apiVersion();

    /**
     * Gets Gets or sets the preferred language for the response..
     *
     * @return the acceptLanguage value.
     */
    String acceptLanguage();

    /**
     * Sets Gets or sets the preferred language for the response..
     *
     * @param acceptLanguage the acceptLanguage value.
     * @return the service client itself
     */
    KeyVaultClientBase withAcceptLanguage(String acceptLanguage);

    /**
     * Gets Gets or sets the retry timeout in seconds for Long Running Operations. Default value is 30..
     *
     * @return the longRunningOperationRetryTimeout value.
     */
    int longRunningOperationRetryTimeout();

    /**
     * Sets Gets or sets the retry timeout in seconds for Long Running Operations. Default value is 30..
     *
     * @param longRunningOperationRetryTimeout the longRunningOperationRetryTimeout value.
     * @return the service client itself
     */
    KeyVaultClientBase withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout);

    /**
     * Gets When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true..
     *
     * @return the generateClientRequestId value.
     */
    boolean generateClientRequestId();

    /**
     * Sets When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true..
     *
     * @param generateClientRequestId the generateClientRequestId value.
     * @return the service client itself
     */
    KeyVaultClientBase withGenerateClientRequestId(boolean generateClientRequestId);

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     * The create key operation can be used to create any key type in Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key.
     * @param kty The type of key to create. For valid values, see JsonWebKeyType. Possible values include: 'EC', 'EC-HSM', 'RSA', 'RSA-HSM', 'oct'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyBundle object if successful.
     */
    KeyBundle createKey(String vaultBaseUrl, String keyName, JsonWebKeyType kty);

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     * The create key operation can be used to create any key type in Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key.
     * @param kty The type of key to create. For valid values, see JsonWebKeyType. Possible values include: 'EC', 'EC-HSM', 'RSA', 'RSA-HSM', 'oct'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, final ServiceCallback<KeyBundle> serviceCallback);

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     * The create key operation can be used to create any key type in Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key.
     * @param kty The type of key to create. For valid values, see JsonWebKeyType. Possible values include: 'EC', 'EC-HSM', 'RSA', 'RSA-HSM', 'oct'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty);

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     * The create key operation can be used to create any key type in Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key.
     * @param kty The type of key to create. For valid values, see JsonWebKeyType. Possible values include: 'EC', 'EC-HSM', 'RSA', 'RSA-HSM', 'oct'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<ServiceResponse<KeyBundle>> createKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty);
    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     * The create key operation can be used to create any key type in Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key.
     * @param kty The type of key to create. For valid values, see JsonWebKeyType. Possible values include: 'EC', 'EC-HSM', 'RSA', 'RSA-HSM', 'oct'
     * @param keySize The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * @param keyOps the List&lt;JsonWebKeyOperation&gt; value
     * @param keyAttributes the KeyAttributes value
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param curve Elliptic curve name. For valid values, see JsonWebKeyCurveName. Possible values include: 'P-256', 'P-384', 'P-521', 'P-256K'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyBundle object if successful.
     */
    KeyBundle createKey(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, JsonWebKeyCurveName curve);

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     * The create key operation can be used to create any key type in Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key.
     * @param kty The type of key to create. For valid values, see JsonWebKeyType. Possible values include: 'EC', 'EC-HSM', 'RSA', 'RSA-HSM', 'oct'
     * @param keySize The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * @param keyOps the List&lt;JsonWebKeyOperation&gt; value
     * @param keyAttributes the KeyAttributes value
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param curve Elliptic curve name. For valid values, see JsonWebKeyCurveName. Possible values include: 'P-256', 'P-384', 'P-521', 'P-256K'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, JsonWebKeyCurveName curve, final ServiceCallback<KeyBundle> serviceCallback);

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     * The create key operation can be used to create any key type in Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key.
     * @param kty The type of key to create. For valid values, see JsonWebKeyType. Possible values include: 'EC', 'EC-HSM', 'RSA', 'RSA-HSM', 'oct'
     * @param keySize The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * @param keyOps the List&lt;JsonWebKeyOperation&gt; value
     * @param keyAttributes the KeyAttributes value
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param curve Elliptic curve name. For valid values, see JsonWebKeyCurveName. Possible values include: 'P-256', 'P-384', 'P-521', 'P-256K'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, JsonWebKeyCurveName curve);

    /**
     * Creates a new key, stores it, then returns key parameters and attributes to the client.
     * The create key operation can be used to create any key type in Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. It requires the keys/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name for the new key. The system will generate the version name for the new key.
     * @param kty The type of key to create. For valid values, see JsonWebKeyType. Possible values include: 'EC', 'EC-HSM', 'RSA', 'RSA-HSM', 'oct'
     * @param keySize The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     * @param keyOps the List&lt;JsonWebKeyOperation&gt; value
     * @param keyAttributes the KeyAttributes value
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param curve Elliptic curve name. For valid values, see JsonWebKeyCurveName. Possible values include: 'P-256', 'P-384', 'P-521', 'P-256K'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<ServiceResponse<KeyBundle>> createKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, JsonWebKeyCurveName curve);

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     * The import key operation may be used to import any key type into an Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key.
     * @param key The Json web key
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyBundle object if successful.
     */
    KeyBundle importKey(String vaultBaseUrl, String keyName, JsonWebKey key);

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     * The import key operation may be used to import any key type into an Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key.
     * @param key The Json web key
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key, final ServiceCallback<KeyBundle> serviceCallback);

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     * The import key operation may be used to import any key type into an Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key.
     * @param key The Json web key
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key);

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     * The import key operation may be used to import any key type into an Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key.
     * @param key The Json web key
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<ServiceResponse<KeyBundle>> importKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, JsonWebKey key);
    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     * The import key operation may be used to import any key type into an Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key.
     * @param key The Json web key
     * @param hsm Whether to import as a hardware key (HSM) or software key.
     * @param keyAttributes The key management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyBundle object if successful.
     */
    KeyBundle importKey(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags);

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     * The import key operation may be used to import any key type into an Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key.
     * @param key The Json web key
     * @param hsm Whether to import as a hardware key (HSM) or software key.
     * @param keyAttributes The key management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags, final ServiceCallback<KeyBundle> serviceCallback);

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     * The import key operation may be used to import any key type into an Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key.
     * @param key The Json web key
     * @param hsm Whether to import as a hardware key (HSM) or software key.
     * @param keyAttributes The key management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags);

    /**
     * Imports an externally created key, stores it, and returns key parameters and attributes to the client.
     * The import key operation may be used to import any key type into an Azure Key Vault. If the named key already exists, Azure Key Vault creates a new version of the key. This operation requires the keys/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName Name for the imported key.
     * @param key The Json web key
     * @param hsm Whether to import as a hardware key (HSM) or software key.
     * @param keyAttributes The key management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<ServiceResponse<KeyBundle>> importKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags);

    /**
     * Deletes a key of any type from storage in Azure Key Vault.
     * The delete key operation cannot be used to remove individual versions of a key. This operation removes the cryptographic material associated with the key, which means the key is not usable for Sign/Verify, Wrap/Unwrap or Encrypt/Decrypt operations. This operation requires the keys/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeletedKeyBundle object if successful.
     */
    DeletedKeyBundle deleteKey(String vaultBaseUrl, String keyName);

    /**
     * Deletes a key of any type from storage in Azure Key Vault.
     * The delete key operation cannot be used to remove individual versions of a key. This operation removes the cryptographic material associated with the key, which means the key is not usable for Sign/Verify, Wrap/Unwrap or Encrypt/Decrypt operations. This operation requires the keys/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<DeletedKeyBundle> deleteKeyAsync(String vaultBaseUrl, String keyName, final ServiceCallback<DeletedKeyBundle> serviceCallback);

    /**
     * Deletes a key of any type from storage in Azure Key Vault.
     * The delete key operation cannot be used to remove individual versions of a key. This operation removes the cryptographic material associated with the key, which means the key is not usable for Sign/Verify, Wrap/Unwrap or Encrypt/Decrypt operations. This operation requires the keys/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedKeyBundle object
     */
    Observable<DeletedKeyBundle> deleteKeyAsync(String vaultBaseUrl, String keyName);

    /**
     * Deletes a key of any type from storage in Azure Key Vault.
     * The delete key operation cannot be used to remove individual versions of a key. This operation removes the cryptographic material associated with the key, which means the key is not usable for Sign/Verify, Wrap/Unwrap or Encrypt/Decrypt operations. This operation requires the keys/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedKeyBundle object
     */
    Observable<ServiceResponse<DeletedKeyBundle>> deleteKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName);

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key version stored in Azure Key Vault.
     * In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyBundle object if successful.
     */
    KeyBundle updateKey(String vaultBaseUrl, String keyName, String keyVersion);

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key version stored in Azure Key Vault.
     * In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, final ServiceCallback<KeyBundle> serviceCallback);

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key version stored in Azure Key Vault.
     * In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion);

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key version stored in Azure Key Vault.
     * In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<ServiceResponse<KeyBundle>> updateKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion);
    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key version stored in Azure Key Vault.
     * In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @param keyOps Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
     * @param keyAttributes the KeyAttributes value
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyBundle object if successful.
     */
    KeyBundle updateKey(String vaultBaseUrl, String keyName, String keyVersion, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags);

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key version stored in Azure Key Vault.
     * In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @param keyOps Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
     * @param keyAttributes the KeyAttributes value
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, final ServiceCallback<KeyBundle> serviceCallback);

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key version stored in Azure Key Vault.
     * In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @param keyOps Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
     * @param keyAttributes the KeyAttributes value
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags);

    /**
     * The update key operation changes specified attributes of a stored key and can be applied to any key type and key version stored in Azure Key Vault.
     * In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic material of a key itself cannot be changed. This operation requires the keys/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of key to update.
     * @param keyVersion The version of the key to update.
     * @param keyOps Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
     * @param keyAttributes the KeyAttributes value
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<ServiceResponse<KeyBundle>> updateKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags);

    /**
     * Gets the public part of a stored key.
     * The get key operation is applicable to all key types. If the requested key is symmetric, then no key material is released in the response. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyBundle object if successful.
     */
    KeyBundle getKey(String vaultBaseUrl, String keyName, String keyVersion);

    /**
     * Gets the public part of a stored key.
     * The get key operation is applicable to all key types. If the requested key is symmetric, then no key material is released in the response. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyBundle> getKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, final ServiceCallback<KeyBundle> serviceCallback);

    /**
     * Gets the public part of a stored key.
     * The get key operation is applicable to all key types. If the requested key is symmetric, then no key material is released in the response. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<KeyBundle> getKeyAsync(String vaultBaseUrl, String keyName, String keyVersion);

    /**
     * Gets the public part of a stored key.
     * The get key operation is applicable to all key types. If the requested key is symmetric, then no key material is released in the response. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key to get.
     * @param keyVersion Adding the version parameter retrieves a specific version of a key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<ServiceResponse<KeyBundle>> getKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion);

    /**
     * Retrieves a list of individual key versions with the same key name.
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;KeyItem&gt; object if successful.
     */
    PagedList<KeyItem> getKeyVersions(final String vaultBaseUrl, final String keyName);

    /**
     * Retrieves a list of individual key versions with the same key name.
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<KeyItem>> getKeyVersionsAsync(final String vaultBaseUrl, final String keyName, final ListOperationCallback<KeyItem> serviceCallback);

    /**
     * Retrieves a list of individual key versions with the same key name.
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;KeyItem&gt; object
     */
    Observable<Page<KeyItem>> getKeyVersionsAsync(final String vaultBaseUrl, final String keyName);

    /**
     * Retrieves a list of individual key versions with the same key name.
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;KeyItem&gt; object
     */
    Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsWithServiceResponseAsync(final String vaultBaseUrl, final String keyName);
    /**
     * Retrieves a list of individual key versions with the same key name.
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;KeyItem&gt; object if successful.
     */
    PagedList<KeyItem> getKeyVersions(final String vaultBaseUrl, final String keyName, final Integer maxresults);

    /**
     * Retrieves a list of individual key versions with the same key name.
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<KeyItem>> getKeyVersionsAsync(final String vaultBaseUrl, final String keyName, final Integer maxresults, final ListOperationCallback<KeyItem> serviceCallback);

    /**
     * Retrieves a list of individual key versions with the same key name.
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;KeyItem&gt; object
     */
    Observable<Page<KeyItem>> getKeyVersionsAsync(final String vaultBaseUrl, final String keyName, final Integer maxresults);

    /**
     * Retrieves a list of individual key versions with the same key name.
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;KeyItem&gt; object
     */
    Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsWithServiceResponseAsync(final String vaultBaseUrl, final String keyName, final Integer maxresults);

    /**
     * List keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;KeyItem&gt; object if successful.
     */
    PagedList<KeyItem> getKeys(final String vaultBaseUrl);

    /**
     * List keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<KeyItem>> getKeysAsync(final String vaultBaseUrl, final ListOperationCallback<KeyItem> serviceCallback);

    /**
     * List keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;KeyItem&gt; object
     */
    Observable<Page<KeyItem>> getKeysAsync(final String vaultBaseUrl);

    /**
     * List keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;KeyItem&gt; object
     */
    Observable<ServiceResponse<Page<KeyItem>>> getKeysWithServiceResponseAsync(final String vaultBaseUrl);
    /**
     * List keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;KeyItem&gt; object if successful.
     */
    PagedList<KeyItem> getKeys(final String vaultBaseUrl, final Integer maxresults);

    /**
     * List keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<KeyItem>> getKeysAsync(final String vaultBaseUrl, final Integer maxresults, final ListOperationCallback<KeyItem> serviceCallback);

    /**
     * List keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;KeyItem&gt; object
     */
    Observable<Page<KeyItem>> getKeysAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * List keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;KeyItem&gt; object
     */
    Observable<ServiceResponse<Page<KeyItem>>> getKeysWithServiceResponseAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * Requests that a backup of the specified key be downloaded to the client.
     * The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does NOT return key material in a form that can be used outside the Azure Key Vault system, the returned key material is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this operation is to allow a client to GENERATE a key in one Azure Key Vault instance, BACKUP the key, and then RESTORE it into another Azure Key Vault instance. The BACKUP operation may be used to export, in protected form, any key type from Azure Key Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed within geographical boundaries only; meaning that a BACKUP from one geographical area cannot be restored to another geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical area. This operation requires the key/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BackupKeyResult object if successful.
     */
    BackupKeyResult backupKey(String vaultBaseUrl, String keyName);

    /**
     * Requests that a backup of the specified key be downloaded to the client.
     * The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does NOT return key material in a form that can be used outside the Azure Key Vault system, the returned key material is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this operation is to allow a client to GENERATE a key in one Azure Key Vault instance, BACKUP the key, and then RESTORE it into another Azure Key Vault instance. The BACKUP operation may be used to export, in protected form, any key type from Azure Key Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed within geographical boundaries only; meaning that a BACKUP from one geographical area cannot be restored to another geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical area. This operation requires the key/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<BackupKeyResult> backupKeyAsync(String vaultBaseUrl, String keyName, final ServiceCallback<BackupKeyResult> serviceCallback);

    /**
     * Requests that a backup of the specified key be downloaded to the client.
     * The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does NOT return key material in a form that can be used outside the Azure Key Vault system, the returned key material is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this operation is to allow a client to GENERATE a key in one Azure Key Vault instance, BACKUP the key, and then RESTORE it into another Azure Key Vault instance. The BACKUP operation may be used to export, in protected form, any key type from Azure Key Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed within geographical boundaries only; meaning that a BACKUP from one geographical area cannot be restored to another geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical area. This operation requires the key/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupKeyResult object
     */
    Observable<BackupKeyResult> backupKeyAsync(String vaultBaseUrl, String keyName);

    /**
     * Requests that a backup of the specified key be downloaded to the client.
     * The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does NOT return key material in a form that can be used outside the Azure Key Vault system, the returned key material is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this operation is to allow a client to GENERATE a key in one Azure Key Vault instance, BACKUP the key, and then RESTORE it into another Azure Key Vault instance. The BACKUP operation may be used to export, in protected form, any key type from Azure Key Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed within geographical boundaries only; meaning that a BACKUP from one geographical area cannot be restored to another geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical area. This operation requires the key/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupKeyResult object
     */
    Observable<ServiceResponse<BackupKeyResult>> backupKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName);

    /**
     * Restores a backed up key to a vault.
     * Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes and access control policies. The RESTORE operation may be used to import a previously backed up key. Individual versions of a key cannot be restored. The key is restored in its entirety with the same key name as it had when it was backed up. If the key name is not available in the target Key Vault, the RESTORE operation will be rejected. While the key name is retained during restore, the final key identifier will change if the key is restored to a different vault. Restore will restore all versions and preserve version identifiers. The RESTORE operation is subject to security constraints: The target Key Vault must be owned by the same Microsoft Azure Subscription as the source Key Vault The user must have RESTORE permission in the target Key Vault. This operation requires the keys/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyBundleBackup The backup blob associated with a key bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyBundle object if successful.
     */
    KeyBundle restoreKey(String vaultBaseUrl, byte[] keyBundleBackup);

    /**
     * Restores a backed up key to a vault.
     * Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes and access control policies. The RESTORE operation may be used to import a previously backed up key. Individual versions of a key cannot be restored. The key is restored in its entirety with the same key name as it had when it was backed up. If the key name is not available in the target Key Vault, the RESTORE operation will be rejected. While the key name is retained during restore, the final key identifier will change if the key is restored to a different vault. Restore will restore all versions and preserve version identifiers. The RESTORE operation is subject to security constraints: The target Key Vault must be owned by the same Microsoft Azure Subscription as the source Key Vault The user must have RESTORE permission in the target Key Vault. This operation requires the keys/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyBundleBackup The backup blob associated with a key bundle.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyBundle> restoreKeyAsync(String vaultBaseUrl, byte[] keyBundleBackup, final ServiceCallback<KeyBundle> serviceCallback);

    /**
     * Restores a backed up key to a vault.
     * Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes and access control policies. The RESTORE operation may be used to import a previously backed up key. Individual versions of a key cannot be restored. The key is restored in its entirety with the same key name as it had when it was backed up. If the key name is not available in the target Key Vault, the RESTORE operation will be rejected. While the key name is retained during restore, the final key identifier will change if the key is restored to a different vault. Restore will restore all versions and preserve version identifiers. The RESTORE operation is subject to security constraints: The target Key Vault must be owned by the same Microsoft Azure Subscription as the source Key Vault The user must have RESTORE permission in the target Key Vault. This operation requires the keys/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyBundleBackup The backup blob associated with a key bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<KeyBundle> restoreKeyAsync(String vaultBaseUrl, byte[] keyBundleBackup);

    /**
     * Restores a backed up key to a vault.
     * Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes and access control policies. The RESTORE operation may be used to import a previously backed up key. Individual versions of a key cannot be restored. The key is restored in its entirety with the same key name as it had when it was backed up. If the key name is not available in the target Key Vault, the RESTORE operation will be rejected. While the key name is retained during restore, the final key identifier will change if the key is restored to a different vault. Restore will restore all versions and preserve version identifiers. The RESTORE operation is subject to security constraints: The target Key Vault must be owned by the same Microsoft Azure Subscription as the source Key Vault The user must have RESTORE permission in the target Key Vault. This operation requires the keys/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyBundleBackup The backup blob associated with a key bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<ServiceResponse<KeyBundle>> restoreKeyWithServiceResponseAsync(String vaultBaseUrl, byte[] keyBundleBackup);

    /**
     * Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.
     * The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure Key Vault. Note that the ENCRYPT operation only supports a single block of data, the size of which is dependent on the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly necessary for symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using public portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have access to the public key material. This operation requires the keys/encypt permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyOperationResult object if successful.
     */
    KeyOperationResult encrypt(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value);

    /**
     * Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.
     * The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure Key Vault. Note that the ENCRYPT operation only supports a single block of data, the size of which is dependent on the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly necessary for symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using public portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have access to the public key material. This operation requires the keys/encypt permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyOperationResult> encryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, final ServiceCallback<KeyOperationResult> serviceCallback);

    /**
     * Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.
     * The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure Key Vault. Note that the ENCRYPT operation only supports a single block of data, the size of which is dependent on the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly necessary for symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using public portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have access to the public key material. This operation requires the keys/encypt permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyOperationResult object
     */
    Observable<KeyOperationResult> encryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value);

    /**
     * Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.
     * The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure Key Vault. Note that the ENCRYPT operation only supports a single block of data, the size of which is dependent on the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly necessary for symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using public portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have access to the public key material. This operation requires the keys/encypt permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyOperationResult object
     */
    Observable<ServiceResponse<KeyOperationResult>> encryptWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value);

    /**
     * Decrypts a single block of encrypted data.
     * The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of data may be decrypted, the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT operation applies to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This operation requires the keys/decrypt permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyOperationResult object if successful.
     */
    KeyOperationResult decrypt(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value);

    /**
     * Decrypts a single block of encrypted data.
     * The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of data may be decrypted, the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT operation applies to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This operation requires the keys/decrypt permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyOperationResult> decryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, final ServiceCallback<KeyOperationResult> serviceCallback);

    /**
     * Decrypts a single block of encrypted data.
     * The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of data may be decrypted, the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT operation applies to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This operation requires the keys/decrypt permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyOperationResult object
     */
    Observable<KeyOperationResult> decryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value);

    /**
     * Decrypts a single block of encrypted data.
     * The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of data may be decrypted, the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT operation applies to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This operation requires the keys/decrypt permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyOperationResult object
     */
    Observable<ServiceResponse<KeyOperationResult>> decryptWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value);

    /**
     * Creates a signature from a digest using the specified key.
     * The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this operation uses the private portion of the key. This operation requires the keys/sign permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm identifier. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512', 'ES256K'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyOperationResult object if successful.
     */
    KeyOperationResult sign(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value);

    /**
     * Creates a signature from a digest using the specified key.
     * The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this operation uses the private portion of the key. This operation requires the keys/sign permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm identifier. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512', 'ES256K'
     * @param value the Base64Url value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyOperationResult> signAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value, final ServiceCallback<KeyOperationResult> serviceCallback);

    /**
     * Creates a signature from a digest using the specified key.
     * The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this operation uses the private portion of the key. This operation requires the keys/sign permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm identifier. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512', 'ES256K'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyOperationResult object
     */
    Observable<KeyOperationResult> signAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value);

    /**
     * Creates a signature from a digest using the specified key.
     * The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this operation uses the private portion of the key. This operation requires the keys/sign permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm identifier. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512', 'ES256K'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyOperationResult object
     */
    Observable<ServiceResponse<KeyOperationResult>> signWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value);

    /**
     * Verifies a signature using a specified key.
     * The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly necessary for asymmetric keys stored in Azure Key Vault since signature verification can be performed using the public portion of the key but this operation is supported as a convenience for callers that only have a key-reference and not the public portion of the key. This operation requires the keys/verify permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512', 'ES256K'
     * @param digest The digest used for signing.
     * @param signature The signature to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyVerifyResult object if successful.
     */
    KeyVerifyResult verify(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature);

    /**
     * Verifies a signature using a specified key.
     * The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly necessary for asymmetric keys stored in Azure Key Vault since signature verification can be performed using the public portion of the key but this operation is supported as a convenience for callers that only have a key-reference and not the public portion of the key. This operation requires the keys/verify permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512', 'ES256K'
     * @param digest The digest used for signing.
     * @param signature The signature to be verified.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyVerifyResult> verifyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature, final ServiceCallback<KeyVerifyResult> serviceCallback);

    /**
     * Verifies a signature using a specified key.
     * The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly necessary for asymmetric keys stored in Azure Key Vault since signature verification can be performed using the public portion of the key but this operation is supported as a convenience for callers that only have a key-reference and not the public portion of the key. This operation requires the keys/verify permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512', 'ES256K'
     * @param digest The digest used for signing.
     * @param signature The signature to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyVerifyResult object
     */
    Observable<KeyVerifyResult> verifyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature);

    /**
     * Verifies a signature using a specified key.
     * The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly necessary for asymmetric keys stored in Azure Key Vault since signature verification can be performed using the public portion of the key but this operation is supported as a convenience for callers that only have a key-reference and not the public portion of the key. This operation requires the keys/verify permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm The signing/verification algorithm. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512', 'ES256K'
     * @param digest The digest used for signing.
     * @param signature The signature to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyVerifyResult object
     */
    Observable<ServiceResponse<KeyVerifyResult>> verifyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature);

    /**
     * Wraps a symmetric key using a specified key.
     * The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using the public portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have access to the public key material. This operation requires the keys/wrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyOperationResult object if successful.
     */
    KeyOperationResult wrapKey(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value);

    /**
     * Wraps a symmetric key using a specified key.
     * The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using the public portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have access to the public key material. This operation requires the keys/wrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyOperationResult> wrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, final ServiceCallback<KeyOperationResult> serviceCallback);

    /**
     * Wraps a symmetric key using a specified key.
     * The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using the public portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have access to the public key material. This operation requires the keys/wrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyOperationResult object
     */
    Observable<KeyOperationResult> wrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value);

    /**
     * Wraps a symmetric key using a specified key.
     * The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be performed using the public portion of the key. This operation is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have access to the public key material. This operation requires the keys/wrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyOperationResult object
     */
    Observable<ServiceResponse<KeyOperationResult>> wrapKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value);

    /**
     * Unwraps a symmetric key using the specified key that was initially used for wrapping that key.
     * The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This operation is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This operation requires the keys/unwrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyOperationResult object if successful.
     */
    KeyOperationResult unwrapKey(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value);

    /**
     * Unwraps a symmetric key using the specified key that was initially used for wrapping that key.
     * The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This operation is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This operation requires the keys/unwrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyOperationResult> unwrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, final ServiceCallback<KeyOperationResult> serviceCallback);

    /**
     * Unwraps a symmetric key using the specified key that was initially used for wrapping that key.
     * The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This operation is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This operation requires the keys/unwrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyOperationResult object
     */
    Observable<KeyOperationResult> unwrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value);

    /**
     * Unwraps a symmetric key using the specified key that was initially used for wrapping that key.
     * The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This operation is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This operation requires the keys/unwrapKey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param keyVersion The version of the key.
     * @param algorithm algorithm identifier. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
     * @param value the Base64Url value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyOperationResult object
     */
    Observable<ServiceResponse<KeyOperationResult>> unwrapKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value);

    /**
     * Lists the deleted keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedKeyItem&gt; object if successful.
     */
    PagedList<DeletedKeyItem> getDeletedKeys(final String vaultBaseUrl);

    /**
     * Lists the deleted keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedKeyItem>> getDeletedKeysAsync(final String vaultBaseUrl, final ListOperationCallback<DeletedKeyItem> serviceCallback);

    /**
     * Lists the deleted keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedKeyItem&gt; object
     */
    Observable<Page<DeletedKeyItem>> getDeletedKeysAsync(final String vaultBaseUrl);

    /**
     * Lists the deleted keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedKeyItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedKeyItem>>> getDeletedKeysWithServiceResponseAsync(final String vaultBaseUrl);
    /**
     * Lists the deleted keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedKeyItem&gt; object if successful.
     */
    PagedList<DeletedKeyItem> getDeletedKeys(final String vaultBaseUrl, final Integer maxresults);

    /**
     * Lists the deleted keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedKeyItem>> getDeletedKeysAsync(final String vaultBaseUrl, final Integer maxresults, final ListOperationCallback<DeletedKeyItem> serviceCallback);

    /**
     * Lists the deleted keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedKeyItem&gt; object
     */
    Observable<Page<DeletedKeyItem>> getDeletedKeysAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * Lists the deleted keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedKeyItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedKeyItem>>> getDeletedKeysWithServiceResponseAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * Gets the public part of a deleted key.
     * The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeletedKeyBundle object if successful.
     */
    DeletedKeyBundle getDeletedKey(String vaultBaseUrl, String keyName);

    /**
     * Gets the public part of a deleted key.
     * The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<DeletedKeyBundle> getDeletedKeyAsync(String vaultBaseUrl, String keyName, final ServiceCallback<DeletedKeyBundle> serviceCallback);

    /**
     * Gets the public part of a deleted key.
     * The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedKeyBundle object
     */
    Observable<DeletedKeyBundle> getDeletedKeyAsync(String vaultBaseUrl, String keyName);

    /**
     * Gets the public part of a deleted key.
     * The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedKeyBundle object
     */
    Observable<ServiceResponse<DeletedKeyBundle>> getDeletedKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName);

    /**
     * Permanently deletes the specified key.
     * The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void purgeDeletedKey(String vaultBaseUrl, String keyName);

    /**
     * Permanently deletes the specified key.
     * The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> purgeDeletedKeyAsync(String vaultBaseUrl, String keyName, final ServiceCallback<Void> serviceCallback);

    /**
     * Permanently deletes the specified key.
     * The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> purgeDeletedKeyAsync(String vaultBaseUrl, String keyName);

    /**
     * Permanently deletes the specified key.
     * The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the key
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> purgeDeletedKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName);

    /**
     * Recovers the deleted key to its latest version.
     * The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It recovers the deleted key back to its latest version under /keys. An attempt to recover an non-deleted key will return an error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation requires the keys/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the deleted key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the KeyBundle object if successful.
     */
    KeyBundle recoverDeletedKey(String vaultBaseUrl, String keyName);

    /**
     * Recovers the deleted key to its latest version.
     * The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It recovers the deleted key back to its latest version under /keys. An attempt to recover an non-deleted key will return an error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation requires the keys/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the deleted key.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<KeyBundle> recoverDeletedKeyAsync(String vaultBaseUrl, String keyName, final ServiceCallback<KeyBundle> serviceCallback);

    /**
     * Recovers the deleted key to its latest version.
     * The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It recovers the deleted key back to its latest version under /keys. An attempt to recover an non-deleted key will return an error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation requires the keys/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the deleted key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<KeyBundle> recoverDeletedKeyAsync(String vaultBaseUrl, String keyName);

    /**
     * Recovers the deleted key to its latest version.
     * The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It recovers the deleted key back to its latest version under /keys. An attempt to recover an non-deleted key will return an error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation requires the keys/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param keyName The name of the deleted key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the KeyBundle object
     */
    Observable<ServiceResponse<KeyBundle>> recoverDeletedKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName);

    /**
     * Sets a secret in a specified key vault.
     * The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param value The value of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretBundle object if successful.
     */
    SecretBundle setSecret(String vaultBaseUrl, String secretName, String value);

    /**
     * Sets a secret in a specified key vault.
     * The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param value The value of the secret.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value, final ServiceCallback<SecretBundle> serviceCallback);

    /**
     * Sets a secret in a specified key vault.
     * The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param value The value of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value);

    /**
     * Sets a secret in a specified key vault.
     * The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param value The value of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<ServiceResponse<SecretBundle>> setSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String value);
    /**
     * Sets a secret in a specified key vault.
     * The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param value The value of the secret.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param contentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretBundle object if successful.
     */
    SecretBundle setSecret(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes);

    /**
     * Sets a secret in a specified key vault.
     * The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param value The value of the secret.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param contentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes, final ServiceCallback<SecretBundle> serviceCallback);

    /**
     * Sets a secret in a specified key vault.
     * The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param value The value of the secret.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param contentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes);

    /**
     * Sets a secret in a specified key vault.
     * The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param value The value of the secret.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param contentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<ServiceResponse<SecretBundle>> setSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes);

    /**
     * Deletes a secret from a specified key vault.
     * The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied to an individual version of a secret. This operation requires the secrets/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeletedSecretBundle object if successful.
     */
    DeletedSecretBundle deleteSecret(String vaultBaseUrl, String secretName);

    /**
     * Deletes a secret from a specified key vault.
     * The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied to an individual version of a secret. This operation requires the secrets/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<DeletedSecretBundle> deleteSecretAsync(String vaultBaseUrl, String secretName, final ServiceCallback<DeletedSecretBundle> serviceCallback);

    /**
     * Deletes a secret from a specified key vault.
     * The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied to an individual version of a secret. This operation requires the secrets/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedSecretBundle object
     */
    Observable<DeletedSecretBundle> deleteSecretAsync(String vaultBaseUrl, String secretName);

    /**
     * Deletes a secret from a specified key vault.
     * The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied to an individual version of a secret. This operation requires the secrets/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedSecretBundle object
     */
    Observable<ServiceResponse<DeletedSecretBundle>> deleteSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName);

    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     * The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretBundle object if successful.
     */
    SecretBundle updateSecret(String vaultBaseUrl, String secretName, String secretVersion);

    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     * The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, final ServiceCallback<SecretBundle> serviceCallback);

    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     * The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion);

    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     * The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<ServiceResponse<SecretBundle>> updateSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String secretVersion);
    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     * The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @param contentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretBundle object if successful.
     */
    SecretBundle updateSecret(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags);

    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     * The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @param contentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags, final ServiceCallback<SecretBundle> serviceCallback);

    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     * The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @param contentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags);

    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     * The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @param contentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<ServiceResponse<SecretBundle>> updateSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags);

    /**
     * Get a specified secret from a given key vault.
     * The GET operation is applicable to any secret stored in Azure Key Vault. This operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretBundle object if successful.
     */
    SecretBundle getSecret(String vaultBaseUrl, String secretName, String secretVersion);

    /**
     * Get a specified secret from a given key vault.
     * The GET operation is applicable to any secret stored in Azure Key Vault. This operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<SecretBundle> getSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, final ServiceCallback<SecretBundle> serviceCallback);

    /**
     * Get a specified secret from a given key vault.
     * The GET operation is applicable to any secret stored in Azure Key Vault. This operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<SecretBundle> getSecretAsync(String vaultBaseUrl, String secretName, String secretVersion);

    /**
     * Get a specified secret from a given key vault.
     * The GET operation is applicable to any secret stored in Azure Key Vault. This operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<ServiceResponse<SecretBundle>> getSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String secretVersion);

    /**
     * List secrets in a specified key vault.
     * The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its attributes are provided in the response. Individual secret versions are not listed in the response. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SecretItem&gt; object if successful.
     */
    PagedList<SecretItem> getSecrets(final String vaultBaseUrl);

    /**
     * List secrets in a specified key vault.
     * The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its attributes are provided in the response. Individual secret versions are not listed in the response. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<SecretItem>> getSecretsAsync(final String vaultBaseUrl, final ListOperationCallback<SecretItem> serviceCallback);

    /**
     * List secrets in a specified key vault.
     * The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its attributes are provided in the response. Individual secret versions are not listed in the response. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretItem&gt; object
     */
    Observable<Page<SecretItem>> getSecretsAsync(final String vaultBaseUrl);

    /**
     * List secrets in a specified key vault.
     * The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its attributes are provided in the response. Individual secret versions are not listed in the response. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretItem&gt; object
     */
    Observable<ServiceResponse<Page<SecretItem>>> getSecretsWithServiceResponseAsync(final String vaultBaseUrl);
    /**
     * List secrets in a specified key vault.
     * The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its attributes are provided in the response. Individual secret versions are not listed in the response. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SecretItem&gt; object if successful.
     */
    PagedList<SecretItem> getSecrets(final String vaultBaseUrl, final Integer maxresults);

    /**
     * List secrets in a specified key vault.
     * The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its attributes are provided in the response. Individual secret versions are not listed in the response. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to 25 results.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<SecretItem>> getSecretsAsync(final String vaultBaseUrl, final Integer maxresults, final ListOperationCallback<SecretItem> serviceCallback);

    /**
     * List secrets in a specified key vault.
     * The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its attributes are provided in the response. Individual secret versions are not listed in the response. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretItem&gt; object
     */
    Observable<Page<SecretItem>> getSecretsAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * List secrets in a specified key vault.
     * The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its attributes are provided in the response. Individual secret versions are not listed in the response. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretItem&gt; object
     */
    Observable<ServiceResponse<Page<SecretItem>>> getSecretsWithServiceResponseAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * List all versions of the specified secret.
     * The full secret identifier and attributes are provided in the response. No values are returned for the secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SecretItem&gt; object if successful.
     */
    PagedList<SecretItem> getSecretVersions(final String vaultBaseUrl, final String secretName);

    /**
     * List all versions of the specified secret.
     * The full secret identifier and attributes are provided in the response. No values are returned for the secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<SecretItem>> getSecretVersionsAsync(final String vaultBaseUrl, final String secretName, final ListOperationCallback<SecretItem> serviceCallback);

    /**
     * List all versions of the specified secret.
     * The full secret identifier and attributes are provided in the response. No values are returned for the secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretItem&gt; object
     */
    Observable<Page<SecretItem>> getSecretVersionsAsync(final String vaultBaseUrl, final String secretName);

    /**
     * List all versions of the specified secret.
     * The full secret identifier and attributes are provided in the response. No values are returned for the secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretItem&gt; object
     */
    Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsWithServiceResponseAsync(final String vaultBaseUrl, final String secretName);
    /**
     * List all versions of the specified secret.
     * The full secret identifier and attributes are provided in the response. No values are returned for the secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SecretItem&gt; object if successful.
     */
    PagedList<SecretItem> getSecretVersions(final String vaultBaseUrl, final String secretName, final Integer maxresults);

    /**
     * List all versions of the specified secret.
     * The full secret identifier and attributes are provided in the response. No values are returned for the secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to 25 results.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<SecretItem>> getSecretVersionsAsync(final String vaultBaseUrl, final String secretName, final Integer maxresults, final ListOperationCallback<SecretItem> serviceCallback);

    /**
     * List all versions of the specified secret.
     * The full secret identifier and attributes are provided in the response. No values are returned for the secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretItem&gt; object
     */
    Observable<Page<SecretItem>> getSecretVersionsAsync(final String vaultBaseUrl, final String secretName, final Integer maxresults);

    /**
     * List all versions of the specified secret.
     * The full secret identifier and attributes are provided in the response. No values are returned for the secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretItem&gt; object
     */
    Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsWithServiceResponseAsync(final String vaultBaseUrl, final String secretName, final Integer maxresults);

    /**
     * Lists deleted secrets for the specified vault.
     * The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedSecretItem&gt; object if successful.
     */
    PagedList<DeletedSecretItem> getDeletedSecrets(final String vaultBaseUrl);

    /**
     * Lists deleted secrets for the specified vault.
     * The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedSecretItem>> getDeletedSecretsAsync(final String vaultBaseUrl, final ListOperationCallback<DeletedSecretItem> serviceCallback);

    /**
     * Lists deleted secrets for the specified vault.
     * The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedSecretItem&gt; object
     */
    Observable<Page<DeletedSecretItem>> getDeletedSecretsAsync(final String vaultBaseUrl);

    /**
     * Lists deleted secrets for the specified vault.
     * The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedSecretItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedSecretItem>>> getDeletedSecretsWithServiceResponseAsync(final String vaultBaseUrl);
    /**
     * Lists deleted secrets for the specified vault.
     * The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedSecretItem&gt; object if successful.
     */
    PagedList<DeletedSecretItem> getDeletedSecrets(final String vaultBaseUrl, final Integer maxresults);

    /**
     * Lists deleted secrets for the specified vault.
     * The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedSecretItem>> getDeletedSecretsAsync(final String vaultBaseUrl, final Integer maxresults, final ListOperationCallback<DeletedSecretItem> serviceCallback);

    /**
     * Lists deleted secrets for the specified vault.
     * The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedSecretItem&gt; object
     */
    Observable<Page<DeletedSecretItem>> getDeletedSecretsAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * Lists deleted secrets for the specified vault.
     * The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedSecretItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedSecretItem>>> getDeletedSecretsWithServiceResponseAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * Gets the specified deleted secret.
     * The Get Deleted Secret operation returns the specified deleted secret along with its attributes. This operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeletedSecretBundle object if successful.
     */
    DeletedSecretBundle getDeletedSecret(String vaultBaseUrl, String secretName);

    /**
     * Gets the specified deleted secret.
     * The Get Deleted Secret operation returns the specified deleted secret along with its attributes. This operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<DeletedSecretBundle> getDeletedSecretAsync(String vaultBaseUrl, String secretName, final ServiceCallback<DeletedSecretBundle> serviceCallback);

    /**
     * Gets the specified deleted secret.
     * The Get Deleted Secret operation returns the specified deleted secret along with its attributes. This operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedSecretBundle object
     */
    Observable<DeletedSecretBundle> getDeletedSecretAsync(String vaultBaseUrl, String secretName);

    /**
     * Gets the specified deleted secret.
     * The Get Deleted Secret operation returns the specified deleted secret along with its attributes. This operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedSecretBundle object
     */
    Observable<ServiceResponse<DeletedSecretBundle>> getDeletedSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName);

    /**
     * Permanently deletes the specified secret.
     * The purge deleted secret operation removes the secret permanently, without the possibility of recovery. This operation can only be enabled on a soft-delete enabled vault. This operation requires the secrets/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void purgeDeletedSecret(String vaultBaseUrl, String secretName);

    /**
     * Permanently deletes the specified secret.
     * The purge deleted secret operation removes the secret permanently, without the possibility of recovery. This operation can only be enabled on a soft-delete enabled vault. This operation requires the secrets/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> purgeDeletedSecretAsync(String vaultBaseUrl, String secretName, final ServiceCallback<Void> serviceCallback);

    /**
     * Permanently deletes the specified secret.
     * The purge deleted secret operation removes the secret permanently, without the possibility of recovery. This operation can only be enabled on a soft-delete enabled vault. This operation requires the secrets/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> purgeDeletedSecretAsync(String vaultBaseUrl, String secretName);

    /**
     * Permanently deletes the specified secret.
     * The purge deleted secret operation removes the secret permanently, without the possibility of recovery. This operation can only be enabled on a soft-delete enabled vault. This operation requires the secrets/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> purgeDeletedSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName);

    /**
     * Recovers the deleted secret to the latest version.
     * Recovers the deleted secret in the specified vault. This operation can only be performed on a soft-delete enabled vault. This operation requires the secrets/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the deleted secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretBundle object if successful.
     */
    SecretBundle recoverDeletedSecret(String vaultBaseUrl, String secretName);

    /**
     * Recovers the deleted secret to the latest version.
     * Recovers the deleted secret in the specified vault. This operation can only be performed on a soft-delete enabled vault. This operation requires the secrets/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the deleted secret.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<SecretBundle> recoverDeletedSecretAsync(String vaultBaseUrl, String secretName, final ServiceCallback<SecretBundle> serviceCallback);

    /**
     * Recovers the deleted secret to the latest version.
     * Recovers the deleted secret in the specified vault. This operation can only be performed on a soft-delete enabled vault. This operation requires the secrets/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the deleted secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<SecretBundle> recoverDeletedSecretAsync(String vaultBaseUrl, String secretName);

    /**
     * Recovers the deleted secret to the latest version.
     * Recovers the deleted secret in the specified vault. This operation can only be performed on a soft-delete enabled vault. This operation requires the secrets/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the deleted secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<ServiceResponse<SecretBundle>> recoverDeletedSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName);

    /**
     * Backs up the specified secret.
     * Requests that a backup of the specified secret be downloaded to the client. All versions of the secret will be downloaded. This operation requires the secrets/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BackupSecretResult object if successful.
     */
    BackupSecretResult backupSecret(String vaultBaseUrl, String secretName);

    /**
     * Backs up the specified secret.
     * Requests that a backup of the specified secret be downloaded to the client. All versions of the secret will be downloaded. This operation requires the secrets/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<BackupSecretResult> backupSecretAsync(String vaultBaseUrl, String secretName, final ServiceCallback<BackupSecretResult> serviceCallback);

    /**
     * Backs up the specified secret.
     * Requests that a backup of the specified secret be downloaded to the client. All versions of the secret will be downloaded. This operation requires the secrets/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupSecretResult object
     */
    Observable<BackupSecretResult> backupSecretAsync(String vaultBaseUrl, String secretName);

    /**
     * Backs up the specified secret.
     * Requests that a backup of the specified secret be downloaded to the client. All versions of the secret will be downloaded. This operation requires the secrets/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupSecretResult object
     */
    Observable<ServiceResponse<BackupSecretResult>> backupSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName);

    /**
     * Restores a backed up secret to a vault.
     * Restores a backed up secret, and all its versions, to a vault. This operation requires the secrets/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretBundleBackup The backup blob associated with a secret bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretBundle object if successful.
     */
    SecretBundle restoreSecret(String vaultBaseUrl, byte[] secretBundleBackup);

    /**
     * Restores a backed up secret to a vault.
     * Restores a backed up secret, and all its versions, to a vault. This operation requires the secrets/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretBundleBackup The backup blob associated with a secret bundle.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<SecretBundle> restoreSecretAsync(String vaultBaseUrl, byte[] secretBundleBackup, final ServiceCallback<SecretBundle> serviceCallback);

    /**
     * Restores a backed up secret to a vault.
     * Restores a backed up secret, and all its versions, to a vault. This operation requires the secrets/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretBundleBackup The backup blob associated with a secret bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<SecretBundle> restoreSecretAsync(String vaultBaseUrl, byte[] secretBundleBackup);

    /**
     * Restores a backed up secret to a vault.
     * Restores a backed up secret, and all its versions, to a vault. This operation requires the secrets/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretBundleBackup The backup blob associated with a secret bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretBundle object
     */
    Observable<ServiceResponse<SecretBundle>> restoreSecretWithServiceResponseAsync(String vaultBaseUrl, byte[] secretBundleBackup);

    /**
     * List certificates in a specified key vault.
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CertificateItem&gt; object if successful.
     */
    PagedList<CertificateItem> getCertificates(final String vaultBaseUrl);

    /**
     * List certificates in a specified key vault.
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<CertificateItem>> getCertificatesAsync(final String vaultBaseUrl, final ListOperationCallback<CertificateItem> serviceCallback);

    /**
     * List certificates in a specified key vault.
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateItem&gt; object
     */
    Observable<Page<CertificateItem>> getCertificatesAsync(final String vaultBaseUrl);

    /**
     * List certificates in a specified key vault.
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateItem&gt; object
     */
    Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesWithServiceResponseAsync(final String vaultBaseUrl);
    /**
     * List certificates in a specified key vault.
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CertificateItem&gt; object if successful.
     */
    PagedList<CertificateItem> getCertificates(final String vaultBaseUrl, final Integer maxresults, final Boolean includePending);

    /**
     * List certificates in a specified key vault.
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<CertificateItem>> getCertificatesAsync(final String vaultBaseUrl, final Integer maxresults, final Boolean includePending, final ListOperationCallback<CertificateItem> serviceCallback);

    /**
     * List certificates in a specified key vault.
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateItem&gt; object
     */
    Observable<Page<CertificateItem>> getCertificatesAsync(final String vaultBaseUrl, final Integer maxresults, final Boolean includePending);

    /**
     * List certificates in a specified key vault.
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateItem&gt; object
     */
    Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesWithServiceResponseAsync(final String vaultBaseUrl, final Integer maxresults, final Boolean includePending);

    /**
     * Deletes a certificate from a specified key vault.
     * Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot be used to remove individual versions of a certificate object. This operation requires the certificates/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeletedCertificateBundle object if successful.
     */
    DeletedCertificateBundle deleteCertificate(String vaultBaseUrl, String certificateName);

    /**
     * Deletes a certificate from a specified key vault.
     * Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot be used to remove individual versions of a certificate object. This operation requires the certificates/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<DeletedCertificateBundle> deleteCertificateAsync(String vaultBaseUrl, String certificateName, final ServiceCallback<DeletedCertificateBundle> serviceCallback);

    /**
     * Deletes a certificate from a specified key vault.
     * Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot be used to remove individual versions of a certificate object. This operation requires the certificates/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedCertificateBundle object
     */
    Observable<DeletedCertificateBundle> deleteCertificateAsync(String vaultBaseUrl, String certificateName);

    /**
     * Deletes a certificate from a specified key vault.
     * Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot be used to remove individual versions of a certificate object. This operation requires the certificates/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedCertificateBundle object
     */
    Observable<ServiceResponse<DeletedCertificateBundle>> deleteCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName);

    /**
     * Sets the certificate contacts for the specified key vault.
     * Sets the certificate contacts for the specified key vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param contacts The contacts for the key vault certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the Contacts object if successful.
     */
    Contacts setCertificateContacts(String vaultBaseUrl, Contacts contacts);

    /**
     * Sets the certificate contacts for the specified key vault.
     * Sets the certificate contacts for the specified key vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param contacts The contacts for the key vault certificate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Contacts> setCertificateContactsAsync(String vaultBaseUrl, Contacts contacts, final ServiceCallback<Contacts> serviceCallback);

    /**
     * Sets the certificate contacts for the specified key vault.
     * Sets the certificate contacts for the specified key vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param contacts The contacts for the key vault certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Contacts object
     */
    Observable<Contacts> setCertificateContactsAsync(String vaultBaseUrl, Contacts contacts);

    /**
     * Sets the certificate contacts for the specified key vault.
     * Sets the certificate contacts for the specified key vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param contacts The contacts for the key vault certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Contacts object
     */
    Observable<ServiceResponse<Contacts>> setCertificateContactsWithServiceResponseAsync(String vaultBaseUrl, Contacts contacts);

    /**
     * Lists the certificate contacts for a specified key vault.
     * The GetCertificateContacts operation returns the set of certificate contact resources in the specified key vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the Contacts object if successful.
     */
    Contacts getCertificateContacts(String vaultBaseUrl);

    /**
     * Lists the certificate contacts for a specified key vault.
     * The GetCertificateContacts operation returns the set of certificate contact resources in the specified key vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Contacts> getCertificateContactsAsync(String vaultBaseUrl, final ServiceCallback<Contacts> serviceCallback);

    /**
     * Lists the certificate contacts for a specified key vault.
     * The GetCertificateContacts operation returns the set of certificate contact resources in the specified key vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Contacts object
     */
    Observable<Contacts> getCertificateContactsAsync(String vaultBaseUrl);

    /**
     * Lists the certificate contacts for a specified key vault.
     * The GetCertificateContacts operation returns the set of certificate contact resources in the specified key vault. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Contacts object
     */
    Observable<ServiceResponse<Contacts>> getCertificateContactsWithServiceResponseAsync(String vaultBaseUrl);

    /**
     * Deletes the certificate contacts for a specified key vault.
     * Deletes the certificate contacts for a specified key vault certificate. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the Contacts object if successful.
     */
    Contacts deleteCertificateContacts(String vaultBaseUrl);

    /**
     * Deletes the certificate contacts for a specified key vault.
     * Deletes the certificate contacts for a specified key vault certificate. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Contacts> deleteCertificateContactsAsync(String vaultBaseUrl, final ServiceCallback<Contacts> serviceCallback);

    /**
     * Deletes the certificate contacts for a specified key vault.
     * Deletes the certificate contacts for a specified key vault certificate. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Contacts object
     */
    Observable<Contacts> deleteCertificateContactsAsync(String vaultBaseUrl);

    /**
     * Deletes the certificate contacts for a specified key vault.
     * Deletes the certificate contacts for a specified key vault certificate. This operation requires the certificates/managecontacts permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Contacts object
     */
    Observable<ServiceResponse<Contacts>> deleteCertificateContactsWithServiceResponseAsync(String vaultBaseUrl);

    /**
     * List certificate issuers for a specified key vault.
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CertificateIssuerItem&gt; object if successful.
     */
    PagedList<CertificateIssuerItem> getCertificateIssuers(final String vaultBaseUrl);

    /**
     * List certificate issuers for a specified key vault.
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<CertificateIssuerItem>> getCertificateIssuersAsync(final String vaultBaseUrl, final ListOperationCallback<CertificateIssuerItem> serviceCallback);

    /**
     * List certificate issuers for a specified key vault.
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateIssuerItem&gt; object
     */
    Observable<Page<CertificateIssuerItem>> getCertificateIssuersAsync(final String vaultBaseUrl);

    /**
     * List certificate issuers for a specified key vault.
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateIssuerItem&gt; object
     */
    Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersWithServiceResponseAsync(final String vaultBaseUrl);
    /**
     * List certificate issuers for a specified key vault.
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CertificateIssuerItem&gt; object if successful.
     */
    PagedList<CertificateIssuerItem> getCertificateIssuers(final String vaultBaseUrl, final Integer maxresults);

    /**
     * List certificate issuers for a specified key vault.
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<CertificateIssuerItem>> getCertificateIssuersAsync(final String vaultBaseUrl, final Integer maxresults, final ListOperationCallback<CertificateIssuerItem> serviceCallback);

    /**
     * List certificate issuers for a specified key vault.
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateIssuerItem&gt; object
     */
    Observable<Page<CertificateIssuerItem>> getCertificateIssuersAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * List certificate issuers for a specified key vault.
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateIssuerItem&gt; object
     */
    Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersWithServiceResponseAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * Sets the specified certificate issuer.
     * The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IssuerBundle object if successful.
     */
    IssuerBundle setCertificateIssuer(String vaultBaseUrl, String issuerName, String provider);

    /**
     * Sets the specified certificate issuer.
     * The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, final ServiceCallback<IssuerBundle> serviceCallback);

    /**
     * Sets the specified certificate issuer.
     * The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IssuerBundle object
     */
    Observable<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider);

    /**
     * Sets the specified certificate issuer.
     * The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IssuerBundle object
     */
    Observable<ServiceResponse<IssuerBundle>> setCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName, String provider);
    /**
     * Sets the specified certificate issuer.
     * The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IssuerBundle object if successful.
     */
    IssuerBundle setCertificateIssuer(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes);

    /**
     * Sets the specified certificate issuer.
     * The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes, final ServiceCallback<IssuerBundle> serviceCallback);

    /**
     * Sets the specified certificate issuer.
     * The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IssuerBundle object
     */
    Observable<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes);

    /**
     * Sets the specified certificate issuer.
     * The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IssuerBundle object
     */
    Observable<ServiceResponse<IssuerBundle>> setCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes);

    /**
     * Updates the specified certificate issuer.
     * The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IssuerBundle object if successful.
     */
    IssuerBundle updateCertificateIssuer(String vaultBaseUrl, String issuerName);

    /**
     * Updates the specified certificate issuer.
     * The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName, final ServiceCallback<IssuerBundle> serviceCallback);

    /**
     * Updates the specified certificate issuer.
     * The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IssuerBundle object
     */
    Observable<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName);

    /**
     * Updates the specified certificate issuer.
     * The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IssuerBundle object
     */
    Observable<ServiceResponse<IssuerBundle>> updateCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName);
    /**
     * Updates the specified certificate issuer.
     * The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IssuerBundle object if successful.
     */
    IssuerBundle updateCertificateIssuer(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes);

    /**
     * Updates the specified certificate issuer.
     * The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes, final ServiceCallback<IssuerBundle> serviceCallback);

    /**
     * Updates the specified certificate issuer.
     * The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IssuerBundle object
     */
    Observable<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes);

    /**
     * Updates the specified certificate issuer.
     * The UpdateCertificateIssuer operation performs an update on the specified certificate issuer entity. This operation requires the certificates/setissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param provider The issuer provider.
     * @param credentials The credentials to be used for the issuer.
     * @param organizationDetails Details of the organization as provided to the issuer.
     * @param attributes Attributes of the issuer object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IssuerBundle object
     */
    Observable<ServiceResponse<IssuerBundle>> updateCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes);

    /**
     * Lists the specified certificate issuer.
     * The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IssuerBundle object if successful.
     */
    IssuerBundle getCertificateIssuer(String vaultBaseUrl, String issuerName);

    /**
     * Lists the specified certificate issuer.
     * The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<IssuerBundle> getCertificateIssuerAsync(String vaultBaseUrl, String issuerName, final ServiceCallback<IssuerBundle> serviceCallback);

    /**
     * Lists the specified certificate issuer.
     * The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IssuerBundle object
     */
    Observable<IssuerBundle> getCertificateIssuerAsync(String vaultBaseUrl, String issuerName);

    /**
     * Lists the specified certificate issuer.
     * The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IssuerBundle object
     */
    Observable<ServiceResponse<IssuerBundle>> getCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName);

    /**
     * Deletes the specified certificate issuer.
     * The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from the vault. This operation requires the certificates/manageissuers/deleteissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IssuerBundle object if successful.
     */
    IssuerBundle deleteCertificateIssuer(String vaultBaseUrl, String issuerName);

    /**
     * Deletes the specified certificate issuer.
     * The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from the vault. This operation requires the certificates/manageissuers/deleteissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<IssuerBundle> deleteCertificateIssuerAsync(String vaultBaseUrl, String issuerName, final ServiceCallback<IssuerBundle> serviceCallback);

    /**
     * Deletes the specified certificate issuer.
     * The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from the vault. This operation requires the certificates/manageissuers/deleteissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IssuerBundle object
     */
    Observable<IssuerBundle> deleteCertificateIssuerAsync(String vaultBaseUrl, String issuerName);

    /**
     * Deletes the specified certificate issuer.
     * The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from the vault. This operation requires the certificates/manageissuers/deleteissuers permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param issuerName The name of the issuer.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IssuerBundle object
     */
    Observable<ServiceResponse<IssuerBundle>> deleteCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName);

    /**
     * Creates a new certificate.
     * If this is the first version, the certificate resource is created. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateOperation object if successful.
     */
    CertificateOperation createCertificate(String vaultBaseUrl, String certificateName);

    /**
     * Creates a new certificate.
     * If this is the first version, the certificate resource is created. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName, final ServiceCallback<CertificateOperation> serviceCallback);

    /**
     * Creates a new certificate.
     * If this is the first version, the certificate resource is created. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateOperation object
     */
    Observable<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName);

    /**
     * Creates a new certificate.
     * If this is the first version, the certificate resource is created. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateOperation object
     */
    Observable<ServiceResponse<CertificateOperation>> createCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName);
    /**
     * Creates a new certificate.
     * If this is the first version, the certificate resource is created. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateOperation object if successful.
     */
    CertificateOperation createCertificate(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags);

    /**
     * Creates a new certificate.
     * If this is the first version, the certificate resource is created. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, final ServiceCallback<CertificateOperation> serviceCallback);

    /**
     * Creates a new certificate.
     * If this is the first version, the certificate resource is created. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateOperation object
     */
    Observable<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags);

    /**
     * Creates a new certificate.
     * If this is the first version, the certificate resource is created. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateOperation object
     */
    Observable<ServiceResponse<CertificateOperation>> createCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags);

    /**
     * Imports a certificate into a specified key vault.
     * Imports an existing valid certificate, containing a private key, into Azure Key Vault. The certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key as well as x509 certificates. This operation requires the certificates/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This certificate needs to contain the private key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateBundle object if successful.
     */
    CertificateBundle importCertificate(String vaultBaseUrl, String certificateName, String base64EncodedCertificate);

    /**
     * Imports a certificate into a specified key vault.
     * Imports an existing valid certificate, containing a private key, into Azure Key Vault. The certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key as well as x509 certificates. This operation requires the certificates/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This certificate needs to contain the private key.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, final ServiceCallback<CertificateBundle> serviceCallback);

    /**
     * Imports a certificate into a specified key vault.
     * Imports an existing valid certificate, containing a private key, into Azure Key Vault. The certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key as well as x509 certificates. This operation requires the certificates/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This certificate needs to contain the private key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate);

    /**
     * Imports a certificate into a specified key vault.
     * Imports an existing valid certificate, containing a private key, into Azure Key Vault. The certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key as well as x509 certificates. This operation requires the certificates/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This certificate needs to contain the private key.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<ServiceResponse<CertificateBundle>> importCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate);
    /**
     * Imports a certificate into a specified key vault.
     * Imports an existing valid certificate, containing a private key, into Azure Key Vault. The certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key as well as x509 certificates. This operation requires the certificates/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This certificate needs to contain the private key.
     * @param password If the private key in base64EncodedCertificate is encrypted, the password used for encryption.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateBundle object if successful.
     */
    CertificateBundle importCertificate(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags);

    /**
     * Imports a certificate into a specified key vault.
     * Imports an existing valid certificate, containing a private key, into Azure Key Vault. The certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key as well as x509 certificates. This operation requires the certificates/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This certificate needs to contain the private key.
     * @param password If the private key in base64EncodedCertificate is encrypted, the password used for encryption.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, final ServiceCallback<CertificateBundle> serviceCallback);

    /**
     * Imports a certificate into a specified key vault.
     * Imports an existing valid certificate, containing a private key, into Azure Key Vault. The certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key as well as x509 certificates. This operation requires the certificates/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This certificate needs to contain the private key.
     * @param password If the private key in base64EncodedCertificate is encrypted, the password used for encryption.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags);

    /**
     * Imports a certificate into a specified key vault.
     * Imports an existing valid certificate, containing a private key, into Azure Key Vault. The certificate to be imported can be in either PFX or PEM format. If the certificate is in PEM format the PEM file must contain the key as well as x509 certificates. This operation requires the certificates/import permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param base64EncodedCertificate Base64 encoded representation of the certificate object to import. This certificate needs to contain the private key.
     * @param password If the private key in base64EncodedCertificate is encrypted, the password used for encryption.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<ServiceResponse<CertificateBundle>> importCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags);

    /**
     * List the versions of a certificate.
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CertificateItem&gt; object if successful.
     */
    PagedList<CertificateItem> getCertificateVersions(final String vaultBaseUrl, final String certificateName);

    /**
     * List the versions of a certificate.
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<CertificateItem>> getCertificateVersionsAsync(final String vaultBaseUrl, final String certificateName, final ListOperationCallback<CertificateItem> serviceCallback);

    /**
     * List the versions of a certificate.
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateItem&gt; object
     */
    Observable<Page<CertificateItem>> getCertificateVersionsAsync(final String vaultBaseUrl, final String certificateName);

    /**
     * List the versions of a certificate.
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateItem&gt; object
     */
    Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsWithServiceResponseAsync(final String vaultBaseUrl, final String certificateName);
    /**
     * List the versions of a certificate.
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CertificateItem&gt; object if successful.
     */
    PagedList<CertificateItem> getCertificateVersions(final String vaultBaseUrl, final String certificateName, final Integer maxresults);

    /**
     * List the versions of a certificate.
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<CertificateItem>> getCertificateVersionsAsync(final String vaultBaseUrl, final String certificateName, final Integer maxresults, final ListOperationCallback<CertificateItem> serviceCallback);

    /**
     * List the versions of a certificate.
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateItem&gt; object
     */
    Observable<Page<CertificateItem>> getCertificateVersionsAsync(final String vaultBaseUrl, final String certificateName, final Integer maxresults);

    /**
     * List the versions of a certificate.
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateItem&gt; object
     */
    Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsWithServiceResponseAsync(final String vaultBaseUrl, final String certificateName, final Integer maxresults);

    /**
     * Lists the policy for a certificate.
     * The GetCertificatePolicy operation returns the specified certificate policy resources in the specified key vault. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in a given key vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificatePolicy object if successful.
     */
    CertificatePolicy getCertificatePolicy(String vaultBaseUrl, String certificateName);

    /**
     * Lists the policy for a certificate.
     * The GetCertificatePolicy operation returns the specified certificate policy resources in the specified key vault. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in a given key vault.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificatePolicy> getCertificatePolicyAsync(String vaultBaseUrl, String certificateName, final ServiceCallback<CertificatePolicy> serviceCallback);

    /**
     * Lists the policy for a certificate.
     * The GetCertificatePolicy operation returns the specified certificate policy resources in the specified key vault. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in a given key vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificatePolicy object
     */
    Observable<CertificatePolicy> getCertificatePolicyAsync(String vaultBaseUrl, String certificateName);

    /**
     * Lists the policy for a certificate.
     * The GetCertificatePolicy operation returns the specified certificate policy resources in the specified key vault. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in a given key vault.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificatePolicy object
     */
    Observable<ServiceResponse<CertificatePolicy>> getCertificatePolicyWithServiceResponseAsync(String vaultBaseUrl, String certificateName);

    /**
     * Updates the policy for a certificate.
     * Set specified members in the certificate policy. Leave others as null. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificatePolicy The policy for the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificatePolicy object if successful.
     */
    CertificatePolicy updateCertificatePolicy(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy);

    /**
     * Updates the policy for a certificate.
     * Set specified members in the certificate policy. Leave others as null. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificatePolicy The policy for the certificate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificatePolicy> updateCertificatePolicyAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, final ServiceCallback<CertificatePolicy> serviceCallback);

    /**
     * Updates the policy for a certificate.
     * Set specified members in the certificate policy. Leave others as null. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificatePolicy The policy for the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificatePolicy object
     */
    Observable<CertificatePolicy> updateCertificatePolicyAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy);

    /**
     * Updates the policy for a certificate.
     * Set specified members in the certificate policy. Leave others as null. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificatePolicy The policy for the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificatePolicy object
     */
    Observable<ServiceResponse<CertificatePolicy>> updateCertificatePolicyWithServiceResponseAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy);

    /**
     * Updates the specified attributes associated with the given certificate.
     * The UpdateCertificate operation applies the specified update on the given certificate; the only elements updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateBundle object if successful.
     */
    CertificateBundle updateCertificate(String vaultBaseUrl, String certificateName, String certificateVersion);

    /**
     * Updates the specified attributes associated with the given certificate.
     * The UpdateCertificate operation applies the specified update on the given certificate; the only elements updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, final ServiceCallback<CertificateBundle> serviceCallback);

    /**
     * Updates the specified attributes associated with the given certificate.
     * The UpdateCertificate operation applies the specified update on the given certificate; the only elements updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion);

    /**
     * Updates the specified attributes associated with the given certificate.
     * The UpdateCertificate operation applies the specified update on the given certificate; the only elements updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<ServiceResponse<CertificateBundle>> updateCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String certificateVersion);
    /**
     * Updates the specified attributes associated with the given certificate.
     * The UpdateCertificate operation applies the specified update on the given certificate; the only elements updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateBundle object if successful.
     */
    CertificateBundle updateCertificate(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags);

    /**
     * Updates the specified attributes associated with the given certificate.
     * The UpdateCertificate operation applies the specified update on the given certificate; the only elements updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, final ServiceCallback<CertificateBundle> serviceCallback);

    /**
     * Updates the specified attributes associated with the given certificate.
     * The UpdateCertificate operation applies the specified update on the given certificate; the only elements updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags);

    /**
     * Updates the specified attributes associated with the given certificate.
     * The UpdateCertificate operation applies the specified update on the given certificate; the only elements updated are the certificate's attributes. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given key vault.
     * @param certificateVersion The version of the certificate.
     * @param certificatePolicy The management policy for the certificate.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<ServiceResponse<CertificateBundle>> updateCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags);

    /**
     * Gets information about a certificate.
     * Gets information about a specific certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificateVersion The version of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateBundle object if successful.
     */
    CertificateBundle getCertificate(String vaultBaseUrl, String certificateName, String certificateVersion);

    /**
     * Gets information about a certificate.
     * Gets information about a specific certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificateVersion The version of the certificate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateBundle> getCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, final ServiceCallback<CertificateBundle> serviceCallback);

    /**
     * Gets information about a certificate.
     * Gets information about a specific certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificateVersion The version of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<CertificateBundle> getCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion);

    /**
     * Gets information about a certificate.
     * Gets information about a specific certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate in the given vault.
     * @param certificateVersion The version of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<ServiceResponse<CertificateBundle>> getCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String certificateVersion);

    /**
     * Updates a certificate operation.
     * Updates a certificate creation operation that is already in progress. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param cancellationRequested Indicates if cancellation was requested on the certificate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateOperation object if successful.
     */
    CertificateOperation updateCertificateOperation(String vaultBaseUrl, String certificateName, boolean cancellationRequested);

    /**
     * Updates a certificate operation.
     * Updates a certificate creation operation that is already in progress. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param cancellationRequested Indicates if cancellation was requested on the certificate operation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateOperation> updateCertificateOperationAsync(String vaultBaseUrl, String certificateName, boolean cancellationRequested, final ServiceCallback<CertificateOperation> serviceCallback);

    /**
     * Updates a certificate operation.
     * Updates a certificate creation operation that is already in progress. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param cancellationRequested Indicates if cancellation was requested on the certificate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateOperation object
     */
    Observable<CertificateOperation> updateCertificateOperationAsync(String vaultBaseUrl, String certificateName, boolean cancellationRequested);

    /**
     * Updates a certificate operation.
     * Updates a certificate creation operation that is already in progress. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param cancellationRequested Indicates if cancellation was requested on the certificate operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateOperation object
     */
    Observable<ServiceResponse<CertificateOperation>> updateCertificateOperationWithServiceResponseAsync(String vaultBaseUrl, String certificateName, boolean cancellationRequested);

    /**
     * Gets the creation operation of a certificate.
     * Gets the creation operation associated with a specified certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateOperation object if successful.
     */
    CertificateOperation getCertificateOperation(String vaultBaseUrl, String certificateName);

    /**
     * Gets the creation operation of a certificate.
     * Gets the creation operation associated with a specified certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateOperation> getCertificateOperationAsync(String vaultBaseUrl, String certificateName, final ServiceCallback<CertificateOperation> serviceCallback);

    /**
     * Gets the creation operation of a certificate.
     * Gets the creation operation associated with a specified certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateOperation object
     */
    Observable<CertificateOperation> getCertificateOperationAsync(String vaultBaseUrl, String certificateName);

    /**
     * Gets the creation operation of a certificate.
     * Gets the creation operation associated with a specified certificate. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateOperation object
     */
    Observable<ServiceResponse<CertificateOperation>> getCertificateOperationWithServiceResponseAsync(String vaultBaseUrl, String certificateName);

    /**
     * Deletes the creation operation for a specific certificate.
     * Deletes the creation operation for a specified certificate that is in the process of being created. The certificate is no longer created. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateOperation object if successful.
     */
    CertificateOperation deleteCertificateOperation(String vaultBaseUrl, String certificateName);

    /**
     * Deletes the creation operation for a specific certificate.
     * Deletes the creation operation for a specified certificate that is in the process of being created. The certificate is no longer created. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateOperation> deleteCertificateOperationAsync(String vaultBaseUrl, String certificateName, final ServiceCallback<CertificateOperation> serviceCallback);

    /**
     * Deletes the creation operation for a specific certificate.
     * Deletes the creation operation for a specified certificate that is in the process of being created. The certificate is no longer created. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateOperation object
     */
    Observable<CertificateOperation> deleteCertificateOperationAsync(String vaultBaseUrl, String certificateName);

    /**
     * Deletes the creation operation for a specific certificate.
     * Deletes the creation operation for a specified certificate that is in the process of being created. The certificate is no longer created. This operation requires the certificates/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateOperation object
     */
    Observable<ServiceResponse<CertificateOperation>> deleteCertificateOperationWithServiceResponseAsync(String vaultBaseUrl, String certificateName);

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     * The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateBundle object if successful.
     */
    CertificateBundle mergeCertificate(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates);

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     * The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, final ServiceCallback<CertificateBundle> serviceCallback);

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     * The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates);

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     * The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<ServiceResponse<CertificateBundle>> mergeCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates);
    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     * The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateBundle object if successful.
     */
    CertificateBundle mergeCertificate(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags);

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     * The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags, final ServiceCallback<CertificateBundle> serviceCallback);

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     * The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags);

    /**
     * Merges a certificate or a certificate chain with a key pair existing on the server.
     * The MergeCertificate operation performs the merging of a certificate or certificate chain with a key pair currently available in the service. This operation requires the certificates/create permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param x509Certificates The certificate or the certificate chain to merge.
     * @param certificateAttributes The attributes of the certificate (optional).
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<ServiceResponse<CertificateBundle>> mergeCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags);

    /**
     * Backs up the specified certificate.
     * Requests that a backup of the specified certificate be downloaded to the client. All versions of the certificate will be downloaded. This operation requires the certificates/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BackupCertificateResult object if successful.
     */
    BackupCertificateResult backupCertificate(String vaultBaseUrl, String certificateName);

    /**
     * Backs up the specified certificate.
     * Requests that a backup of the specified certificate be downloaded to the client. All versions of the certificate will be downloaded. This operation requires the certificates/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<BackupCertificateResult> backupCertificateAsync(String vaultBaseUrl, String certificateName, final ServiceCallback<BackupCertificateResult> serviceCallback);

    /**
     * Backs up the specified certificate.
     * Requests that a backup of the specified certificate be downloaded to the client. All versions of the certificate will be downloaded. This operation requires the certificates/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupCertificateResult object
     */
    Observable<BackupCertificateResult> backupCertificateAsync(String vaultBaseUrl, String certificateName);

    /**
     * Backs up the specified certificate.
     * Requests that a backup of the specified certificate be downloaded to the client. All versions of the certificate will be downloaded. This operation requires the certificates/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupCertificateResult object
     */
    Observable<ServiceResponse<BackupCertificateResult>> backupCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName);

    /**
     * Restores a backed up certificate to a vault.
     * Restores a backed up certificate, and all its versions, to a vault. This operation requires the certificates/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateBundleBackup The backup blob associated with a certificate bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateBundle object if successful.
     */
    CertificateBundle restoreCertificate(String vaultBaseUrl, byte[] certificateBundleBackup);

    /**
     * Restores a backed up certificate to a vault.
     * Restores a backed up certificate, and all its versions, to a vault. This operation requires the certificates/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateBundleBackup The backup blob associated with a certificate bundle.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateBundle> restoreCertificateAsync(String vaultBaseUrl, byte[] certificateBundleBackup, final ServiceCallback<CertificateBundle> serviceCallback);

    /**
     * Restores a backed up certificate to a vault.
     * Restores a backed up certificate, and all its versions, to a vault. This operation requires the certificates/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateBundleBackup The backup blob associated with a certificate bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<CertificateBundle> restoreCertificateAsync(String vaultBaseUrl, byte[] certificateBundleBackup);

    /**
     * Restores a backed up certificate to a vault.
     * Restores a backed up certificate, and all its versions, to a vault. This operation requires the certificates/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateBundleBackup The backup blob associated with a certificate bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<ServiceResponse<CertificateBundle>> restoreCertificateWithServiceResponseAsync(String vaultBaseUrl, byte[] certificateBundleBackup);

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state and ready for recovery or purging. This operation includes deletion-specific information. This operation requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedCertificateItem&gt; object if successful.
     */
    PagedList<DeletedCertificateItem> getDeletedCertificates(final String vaultBaseUrl);

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state and ready for recovery or purging. This operation includes deletion-specific information. This operation requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedCertificateItem>> getDeletedCertificatesAsync(final String vaultBaseUrl, final ListOperationCallback<DeletedCertificateItem> serviceCallback);

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state and ready for recovery or purging. This operation includes deletion-specific information. This operation requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedCertificateItem&gt; object
     */
    Observable<Page<DeletedCertificateItem>> getDeletedCertificatesAsync(final String vaultBaseUrl);

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state and ready for recovery or purging. This operation includes deletion-specific information. This operation requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedCertificateItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedCertificateItem>>> getDeletedCertificatesWithServiceResponseAsync(final String vaultBaseUrl);
    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state and ready for recovery or purging. This operation includes deletion-specific information. This operation requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedCertificateItem&gt; object if successful.
     */
    PagedList<DeletedCertificateItem> getDeletedCertificates(final String vaultBaseUrl, final Integer maxresults, final Boolean includePending);

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state and ready for recovery or purging. This operation includes deletion-specific information. This operation requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedCertificateItem>> getDeletedCertificatesAsync(final String vaultBaseUrl, final Integer maxresults, final Boolean includePending, final ListOperationCallback<DeletedCertificateItem> serviceCallback);

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state and ready for recovery or purging. This operation includes deletion-specific information. This operation requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedCertificateItem&gt; object
     */
    Observable<Page<DeletedCertificateItem>> getDeletedCertificatesAsync(final String vaultBaseUrl, final Integer maxresults, final Boolean includePending);

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state and ready for recovery or purging. This operation includes deletion-specific information. This operation requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param includePending Specifies whether to include certificates which are not completely provisioned.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedCertificateItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedCertificateItem>>> getDeletedCertificatesWithServiceResponseAsync(final String vaultBaseUrl, final Integer maxresults, final Boolean includePending);

    /**
     * Retrieves information about the specified deleted certificate.
     * The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes, such as retention interval, scheduled permanent deletion and the current deletion recovery level. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeletedCertificateBundle object if successful.
     */
    DeletedCertificateBundle getDeletedCertificate(String vaultBaseUrl, String certificateName);

    /**
     * Retrieves information about the specified deleted certificate.
     * The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes, such as retention interval, scheduled permanent deletion and the current deletion recovery level. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<DeletedCertificateBundle> getDeletedCertificateAsync(String vaultBaseUrl, String certificateName, final ServiceCallback<DeletedCertificateBundle> serviceCallback);

    /**
     * Retrieves information about the specified deleted certificate.
     * The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes, such as retention interval, scheduled permanent deletion and the current deletion recovery level. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedCertificateBundle object
     */
    Observable<DeletedCertificateBundle> getDeletedCertificateAsync(String vaultBaseUrl, String certificateName);

    /**
     * Retrieves information about the specified deleted certificate.
     * The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes, such as retention interval, scheduled permanent deletion and the current deletion recovery level. This operation requires the certificates/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedCertificateBundle object
     */
    Observable<ServiceResponse<DeletedCertificateBundle>> getDeletedCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName);

    /**
     * Permanently deletes the specified deleted certificate.
     * The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate, without possibility for recovery. The operation is not available if the recovery level does not specify 'Purgeable'. This operation requires the certificate/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void purgeDeletedCertificate(String vaultBaseUrl, String certificateName);

    /**
     * Permanently deletes the specified deleted certificate.
     * The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate, without possibility for recovery. The operation is not available if the recovery level does not specify 'Purgeable'. This operation requires the certificate/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> purgeDeletedCertificateAsync(String vaultBaseUrl, String certificateName, final ServiceCallback<Void> serviceCallback);

    /**
     * Permanently deletes the specified deleted certificate.
     * The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate, without possibility for recovery. The operation is not available if the recovery level does not specify 'Purgeable'. This operation requires the certificate/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> purgeDeletedCertificateAsync(String vaultBaseUrl, String certificateName);

    /**
     * Permanently deletes the specified deleted certificate.
     * The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate, without possibility for recovery. The operation is not available if the recovery level does not specify 'Purgeable'. This operation requires the certificate/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the certificate
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> purgeDeletedCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName);

    /**
     * Recovers the deleted certificate back to its current version under /certificates.
     * The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The operation is applicable in vaults enabled for soft-delete, and must be issued during the retention interval (available in the deleted certificate's attributes). This operation requires the certificates/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the deleted certificate
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateBundle object if successful.
     */
    CertificateBundle recoverDeletedCertificate(String vaultBaseUrl, String certificateName);

    /**
     * Recovers the deleted certificate back to its current version under /certificates.
     * The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The operation is applicable in vaults enabled for soft-delete, and must be issued during the retention interval (available in the deleted certificate's attributes). This operation requires the certificates/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the deleted certificate
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<CertificateBundle> recoverDeletedCertificateAsync(String vaultBaseUrl, String certificateName, final ServiceCallback<CertificateBundle> serviceCallback);

    /**
     * Recovers the deleted certificate back to its current version under /certificates.
     * The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The operation is applicable in vaults enabled for soft-delete, and must be issued during the retention interval (available in the deleted certificate's attributes). This operation requires the certificates/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the deleted certificate
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<CertificateBundle> recoverDeletedCertificateAsync(String vaultBaseUrl, String certificateName);

    /**
     * Recovers the deleted certificate back to its current version under /certificates.
     * The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The operation is applicable in vaults enabled for soft-delete, and must be issued during the retention interval (available in the deleted certificate's attributes). This operation requires the certificates/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param certificateName The name of the deleted certificate
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateBundle object
     */
    Observable<ServiceResponse<CertificateBundle>> recoverDeletedCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName);

    /**
     * List storage accounts managed by the specified key vault. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;StorageAccountItem&gt; object if successful.
     */
    PagedList<StorageAccountItem> getStorageAccounts(final String vaultBaseUrl);

    /**
     * List storage accounts managed by the specified key vault. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<StorageAccountItem>> getStorageAccountsAsync(final String vaultBaseUrl, final ListOperationCallback<StorageAccountItem> serviceCallback);

    /**
     * List storage accounts managed by the specified key vault. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;StorageAccountItem&gt; object
     */
    Observable<Page<StorageAccountItem>> getStorageAccountsAsync(final String vaultBaseUrl);

    /**
     * List storage accounts managed by the specified key vault. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;StorageAccountItem&gt; object
     */
    Observable<ServiceResponse<Page<StorageAccountItem>>> getStorageAccountsWithServiceResponseAsync(final String vaultBaseUrl);
    /**
     * List storage accounts managed by the specified key vault. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;StorageAccountItem&gt; object if successful.
     */
    PagedList<StorageAccountItem> getStorageAccounts(final String vaultBaseUrl, final Integer maxresults);

    /**
     * List storage accounts managed by the specified key vault. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<StorageAccountItem>> getStorageAccountsAsync(final String vaultBaseUrl, final Integer maxresults, final ListOperationCallback<StorageAccountItem> serviceCallback);

    /**
     * List storage accounts managed by the specified key vault. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;StorageAccountItem&gt; object
     */
    Observable<Page<StorageAccountItem>> getStorageAccountsAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * List storage accounts managed by the specified key vault. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;StorageAccountItem&gt; object
     */
    Observable<ServiceResponse<Page<StorageAccountItem>>> getStorageAccountsWithServiceResponseAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * Lists deleted storage accounts for the specified vault.
     * The Get Deleted Storage Accounts operation returns the storage accounts that have been deleted for a vault enabled for soft-delete. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedStorageAccountItem&gt; object if successful.
     */
    PagedList<DeletedStorageAccountItem> getDeletedStorageAccounts(final String vaultBaseUrl);

    /**
     * Lists deleted storage accounts for the specified vault.
     * The Get Deleted Storage Accounts operation returns the storage accounts that have been deleted for a vault enabled for soft-delete. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedStorageAccountItem>> getDeletedStorageAccountsAsync(final String vaultBaseUrl, final ListOperationCallback<DeletedStorageAccountItem> serviceCallback);

    /**
     * Lists deleted storage accounts for the specified vault.
     * The Get Deleted Storage Accounts operation returns the storage accounts that have been deleted for a vault enabled for soft-delete. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedStorageAccountItem&gt; object
     */
    Observable<Page<DeletedStorageAccountItem>> getDeletedStorageAccountsAsync(final String vaultBaseUrl);

    /**
     * Lists deleted storage accounts for the specified vault.
     * The Get Deleted Storage Accounts operation returns the storage accounts that have been deleted for a vault enabled for soft-delete. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedStorageAccountItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> getDeletedStorageAccountsWithServiceResponseAsync(final String vaultBaseUrl);
    /**
     * Lists deleted storage accounts for the specified vault.
     * The Get Deleted Storage Accounts operation returns the storage accounts that have been deleted for a vault enabled for soft-delete. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedStorageAccountItem&gt; object if successful.
     */
    PagedList<DeletedStorageAccountItem> getDeletedStorageAccounts(final String vaultBaseUrl, final Integer maxresults);

    /**
     * Lists deleted storage accounts for the specified vault.
     * The Get Deleted Storage Accounts operation returns the storage accounts that have been deleted for a vault enabled for soft-delete. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedStorageAccountItem>> getDeletedStorageAccountsAsync(final String vaultBaseUrl, final Integer maxresults, final ListOperationCallback<DeletedStorageAccountItem> serviceCallback);

    /**
     * Lists deleted storage accounts for the specified vault.
     * The Get Deleted Storage Accounts operation returns the storage accounts that have been deleted for a vault enabled for soft-delete. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedStorageAccountItem&gt; object
     */
    Observable<Page<DeletedStorageAccountItem>> getDeletedStorageAccountsAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * Lists deleted storage accounts for the specified vault.
     * The Get Deleted Storage Accounts operation returns the storage accounts that have been deleted for a vault enabled for soft-delete. This operation requires the storage/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedStorageAccountItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> getDeletedStorageAccountsWithServiceResponseAsync(final String vaultBaseUrl, final Integer maxresults);

    /**
     * Gets the specified deleted storage account.
     * The Get Deleted Storage Account operation returns the specified deleted storage account along with its attributes. This operation requires the storage/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeletedStorageBundle object if successful.
     */
    DeletedStorageBundle getDeletedStorageAccount(String vaultBaseUrl, String storageAccountName);

    /**
     * Gets the specified deleted storage account.
     * The Get Deleted Storage Account operation returns the specified deleted storage account along with its attributes. This operation requires the storage/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<DeletedStorageBundle> getDeletedStorageAccountAsync(String vaultBaseUrl, String storageAccountName, final ServiceCallback<DeletedStorageBundle> serviceCallback);

    /**
     * Gets the specified deleted storage account.
     * The Get Deleted Storage Account operation returns the specified deleted storage account along with its attributes. This operation requires the storage/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedStorageBundle object
     */
    Observable<DeletedStorageBundle> getDeletedStorageAccountAsync(String vaultBaseUrl, String storageAccountName);

    /**
     * Gets the specified deleted storage account.
     * The Get Deleted Storage Account operation returns the specified deleted storage account along with its attributes. This operation requires the storage/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedStorageBundle object
     */
    Observable<ServiceResponse<DeletedStorageBundle>> getDeletedStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName);

    /**
     * Permanently deletes the specified storage account.
     * The purge deleted storage account operation removes the secret permanently, without the possibility of recovery. This operation can only be performed on a soft-delete enabled vault. This operation requires the storage/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    void purgeDeletedStorageAccount(String vaultBaseUrl, String storageAccountName);

    /**
     * Permanently deletes the specified storage account.
     * The purge deleted storage account operation removes the secret permanently, without the possibility of recovery. This operation can only be performed on a soft-delete enabled vault. This operation requires the storage/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<Void> purgeDeletedStorageAccountAsync(String vaultBaseUrl, String storageAccountName, final ServiceCallback<Void> serviceCallback);

    /**
     * Permanently deletes the specified storage account.
     * The purge deleted storage account operation removes the secret permanently, without the possibility of recovery. This operation can only be performed on a soft-delete enabled vault. This operation requires the storage/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<Void> purgeDeletedStorageAccountAsync(String vaultBaseUrl, String storageAccountName);

    /**
     * Permanently deletes the specified storage account.
     * The purge deleted storage account operation removes the secret permanently, without the possibility of recovery. This operation can only be performed on a soft-delete enabled vault. This operation requires the storage/purge permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    Observable<ServiceResponse<Void>> purgeDeletedStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName);

    /**
     * Recovers the deleted storage account.
     * Recovers the deleted storage account in the specified vault. This operation can only be performed on a soft-delete enabled vault. This operation requires the storage/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StorageBundle object if successful.
     */
    StorageBundle recoverDeletedStorageAccount(String vaultBaseUrl, String storageAccountName);

    /**
     * Recovers the deleted storage account.
     * Recovers the deleted storage account in the specified vault. This operation can only be performed on a soft-delete enabled vault. This operation requires the storage/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<StorageBundle> recoverDeletedStorageAccountAsync(String vaultBaseUrl, String storageAccountName, final ServiceCallback<StorageBundle> serviceCallback);

    /**
     * Recovers the deleted storage account.
     * Recovers the deleted storage account in the specified vault. This operation can only be performed on a soft-delete enabled vault. This operation requires the storage/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<StorageBundle> recoverDeletedStorageAccountAsync(String vaultBaseUrl, String storageAccountName);

    /**
     * Recovers the deleted storage account.
     * Recovers the deleted storage account in the specified vault. This operation can only be performed on a soft-delete enabled vault. This operation requires the storage/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<ServiceResponse<StorageBundle>> recoverDeletedStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName);

    /**
     * Backs up the specified storage account.
     * Requests that a backup of the specified storage account be downloaded to the client. This operation requires the storage/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BackupStorageResult object if successful.
     */
    BackupStorageResult backupStorageAccount(String vaultBaseUrl, String storageAccountName);

    /**
     * Backs up the specified storage account.
     * Requests that a backup of the specified storage account be downloaded to the client. This operation requires the storage/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<BackupStorageResult> backupStorageAccountAsync(String vaultBaseUrl, String storageAccountName, final ServiceCallback<BackupStorageResult> serviceCallback);

    /**
     * Backs up the specified storage account.
     * Requests that a backup of the specified storage account be downloaded to the client. This operation requires the storage/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupStorageResult object
     */
    Observable<BackupStorageResult> backupStorageAccountAsync(String vaultBaseUrl, String storageAccountName);

    /**
     * Backs up the specified storage account.
     * Requests that a backup of the specified storage account be downloaded to the client. This operation requires the storage/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupStorageResult object
     */
    Observable<ServiceResponse<BackupStorageResult>> backupStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName);

    /**
     * Restores a backed up storage account to a vault.
     * Restores a backed up storage account to a vault. This operation requires the storage/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageBundleBackup The backup blob associated with a storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StorageBundle object if successful.
     */
    StorageBundle restoreStorageAccount(String vaultBaseUrl, byte[] storageBundleBackup);

    /**
     * Restores a backed up storage account to a vault.
     * Restores a backed up storage account to a vault. This operation requires the storage/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageBundleBackup The backup blob associated with a storage account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<StorageBundle> restoreStorageAccountAsync(String vaultBaseUrl, byte[] storageBundleBackup, final ServiceCallback<StorageBundle> serviceCallback);

    /**
     * Restores a backed up storage account to a vault.
     * Restores a backed up storage account to a vault. This operation requires the storage/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageBundleBackup The backup blob associated with a storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<StorageBundle> restoreStorageAccountAsync(String vaultBaseUrl, byte[] storageBundleBackup);

    /**
     * Restores a backed up storage account to a vault.
     * Restores a backed up storage account to a vault. This operation requires the storage/restore permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageBundleBackup The backup blob associated with a storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<ServiceResponse<StorageBundle>> restoreStorageAccountWithServiceResponseAsync(String vaultBaseUrl, byte[] storageBundleBackup);

    /**
     * Deletes a storage account. This operation requires the storage/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeletedStorageBundle object if successful.
     */
    DeletedStorageBundle deleteStorageAccount(String vaultBaseUrl, String storageAccountName);

    /**
     * Deletes a storage account. This operation requires the storage/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<DeletedStorageBundle> deleteStorageAccountAsync(String vaultBaseUrl, String storageAccountName, final ServiceCallback<DeletedStorageBundle> serviceCallback);

    /**
     * Deletes a storage account. This operation requires the storage/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedStorageBundle object
     */
    Observable<DeletedStorageBundle> deleteStorageAccountAsync(String vaultBaseUrl, String storageAccountName);

    /**
     * Deletes a storage account. This operation requires the storage/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedStorageBundle object
     */
    Observable<ServiceResponse<DeletedStorageBundle>> deleteStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName);

    /**
     * Gets information about a specified storage account. This operation requires the storage/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StorageBundle object if successful.
     */
    StorageBundle getStorageAccount(String vaultBaseUrl, String storageAccountName);

    /**
     * Gets information about a specified storage account. This operation requires the storage/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<StorageBundle> getStorageAccountAsync(String vaultBaseUrl, String storageAccountName, final ServiceCallback<StorageBundle> serviceCallback);

    /**
     * Gets information about a specified storage account. This operation requires the storage/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<StorageBundle> getStorageAccountAsync(String vaultBaseUrl, String storageAccountName);

    /**
     * Gets information about a specified storage account. This operation requires the storage/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<ServiceResponse<StorageBundle>> getStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName);

    /**
     * Creates or updates a new storage account. This operation requires the storage/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param resourceId Storage account resource id.
     * @param activeKeyName Current active storage account key name.
     * @param autoRegenerateKey whether keyvault should manage the storage account for the user.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StorageBundle object if successful.
     */
    StorageBundle setStorageAccount(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey);

    /**
     * Creates or updates a new storage account. This operation requires the storage/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param resourceId Storage account resource id.
     * @param activeKeyName Current active storage account key name.
     * @param autoRegenerateKey whether keyvault should manage the storage account for the user.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<StorageBundle> setStorageAccountAsync(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey, final ServiceCallback<StorageBundle> serviceCallback);

    /**
     * Creates or updates a new storage account. This operation requires the storage/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param resourceId Storage account resource id.
     * @param activeKeyName Current active storage account key name.
     * @param autoRegenerateKey whether keyvault should manage the storage account for the user.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<StorageBundle> setStorageAccountAsync(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey);

    /**
     * Creates or updates a new storage account. This operation requires the storage/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param resourceId Storage account resource id.
     * @param activeKeyName Current active storage account key name.
     * @param autoRegenerateKey whether keyvault should manage the storage account for the user.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<ServiceResponse<StorageBundle>> setStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey);
    /**
     * Creates or updates a new storage account. This operation requires the storage/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param resourceId Storage account resource id.
     * @param activeKeyName Current active storage account key name.
     * @param autoRegenerateKey whether keyvault should manage the storage account for the user.
     * @param regenerationPeriod The key regeneration time duration specified in ISO-8601 format.
     * @param storageAccountAttributes The attributes of the storage account.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StorageBundle object if successful.
     */
    StorageBundle setStorageAccount(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags);

    /**
     * Creates or updates a new storage account. This operation requires the storage/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param resourceId Storage account resource id.
     * @param activeKeyName Current active storage account key name.
     * @param autoRegenerateKey whether keyvault should manage the storage account for the user.
     * @param regenerationPeriod The key regeneration time duration specified in ISO-8601 format.
     * @param storageAccountAttributes The attributes of the storage account.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<StorageBundle> setStorageAccountAsync(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags, final ServiceCallback<StorageBundle> serviceCallback);

    /**
     * Creates or updates a new storage account. This operation requires the storage/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param resourceId Storage account resource id.
     * @param activeKeyName Current active storage account key name.
     * @param autoRegenerateKey whether keyvault should manage the storage account for the user.
     * @param regenerationPeriod The key regeneration time duration specified in ISO-8601 format.
     * @param storageAccountAttributes The attributes of the storage account.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<StorageBundle> setStorageAccountAsync(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags);

    /**
     * Creates or updates a new storage account. This operation requires the storage/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param resourceId Storage account resource id.
     * @param activeKeyName Current active storage account key name.
     * @param autoRegenerateKey whether keyvault should manage the storage account for the user.
     * @param regenerationPeriod The key regeneration time duration specified in ISO-8601 format.
     * @param storageAccountAttributes The attributes of the storage account.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<ServiceResponse<StorageBundle>> setStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags);

    /**
     * Updates the specified attributes associated with the given storage account. This operation requires the storage/set/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StorageBundle object if successful.
     */
    StorageBundle updateStorageAccount(String vaultBaseUrl, String storageAccountName);

    /**
     * Updates the specified attributes associated with the given storage account. This operation requires the storage/set/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<StorageBundle> updateStorageAccountAsync(String vaultBaseUrl, String storageAccountName, final ServiceCallback<StorageBundle> serviceCallback);

    /**
     * Updates the specified attributes associated with the given storage account. This operation requires the storage/set/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<StorageBundle> updateStorageAccountAsync(String vaultBaseUrl, String storageAccountName);

    /**
     * Updates the specified attributes associated with the given storage account. This operation requires the storage/set/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<ServiceResponse<StorageBundle>> updateStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName);
    /**
     * Updates the specified attributes associated with the given storage account. This operation requires the storage/set/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param activeKeyName The current active storage account key name.
     * @param autoRegenerateKey whether keyvault should manage the storage account for the user.
     * @param regenerationPeriod The key regeneration time duration specified in ISO-8601 format.
     * @param storageAccountAttributes The attributes of the storage account.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StorageBundle object if successful.
     */
    StorageBundle updateStorageAccount(String vaultBaseUrl, String storageAccountName, String activeKeyName, Boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags);

    /**
     * Updates the specified attributes associated with the given storage account. This operation requires the storage/set/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param activeKeyName The current active storage account key name.
     * @param autoRegenerateKey whether keyvault should manage the storage account for the user.
     * @param regenerationPeriod The key regeneration time duration specified in ISO-8601 format.
     * @param storageAccountAttributes The attributes of the storage account.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<StorageBundle> updateStorageAccountAsync(String vaultBaseUrl, String storageAccountName, String activeKeyName, Boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags, final ServiceCallback<StorageBundle> serviceCallback);

    /**
     * Updates the specified attributes associated with the given storage account. This operation requires the storage/set/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param activeKeyName The current active storage account key name.
     * @param autoRegenerateKey whether keyvault should manage the storage account for the user.
     * @param regenerationPeriod The key regeneration time duration specified in ISO-8601 format.
     * @param storageAccountAttributes The attributes of the storage account.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<StorageBundle> updateStorageAccountAsync(String vaultBaseUrl, String storageAccountName, String activeKeyName, Boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags);

    /**
     * Updates the specified attributes associated with the given storage account. This operation requires the storage/set/update permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param activeKeyName The current active storage account key name.
     * @param autoRegenerateKey whether keyvault should manage the storage account for the user.
     * @param regenerationPeriod The key regeneration time duration specified in ISO-8601 format.
     * @param storageAccountAttributes The attributes of the storage account.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<ServiceResponse<StorageBundle>> updateStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String activeKeyName, Boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags);

    /**
     * Regenerates the specified key value for the given storage account. This operation requires the storage/regeneratekey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param keyName The storage account key name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StorageBundle object if successful.
     */
    StorageBundle regenerateStorageAccountKey(String vaultBaseUrl, String storageAccountName, String keyName);

    /**
     * Regenerates the specified key value for the given storage account. This operation requires the storage/regeneratekey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param keyName The storage account key name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<StorageBundle> regenerateStorageAccountKeyAsync(String vaultBaseUrl, String storageAccountName, String keyName, final ServiceCallback<StorageBundle> serviceCallback);

    /**
     * Regenerates the specified key value for the given storage account. This operation requires the storage/regeneratekey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param keyName The storage account key name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<StorageBundle> regenerateStorageAccountKeyAsync(String vaultBaseUrl, String storageAccountName, String keyName);

    /**
     * Regenerates the specified key value for the given storage account. This operation requires the storage/regeneratekey permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param keyName The storage account key name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageBundle object
     */
    Observable<ServiceResponse<StorageBundle>> regenerateStorageAccountKeyWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String keyName);

    /**
     * List storage SAS definitions for the given storage account. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SasDefinitionItem&gt; object if successful.
     */
    PagedList<SasDefinitionItem> getSasDefinitions(final String vaultBaseUrl, final String storageAccountName);

    /**
     * List storage SAS definitions for the given storage account. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<SasDefinitionItem>> getSasDefinitionsAsync(final String vaultBaseUrl, final String storageAccountName, final ListOperationCallback<SasDefinitionItem> serviceCallback);

    /**
     * List storage SAS definitions for the given storage account. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SasDefinitionItem&gt; object
     */
    Observable<Page<SasDefinitionItem>> getSasDefinitionsAsync(final String vaultBaseUrl, final String storageAccountName);

    /**
     * List storage SAS definitions for the given storage account. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SasDefinitionItem&gt; object
     */
    Observable<ServiceResponse<Page<SasDefinitionItem>>> getSasDefinitionsWithServiceResponseAsync(final String vaultBaseUrl, final String storageAccountName);
    /**
     * List storage SAS definitions for the given storage account. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SasDefinitionItem&gt; object if successful.
     */
    PagedList<SasDefinitionItem> getSasDefinitions(final String vaultBaseUrl, final String storageAccountName, final Integer maxresults);

    /**
     * List storage SAS definitions for the given storage account. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<SasDefinitionItem>> getSasDefinitionsAsync(final String vaultBaseUrl, final String storageAccountName, final Integer maxresults, final ListOperationCallback<SasDefinitionItem> serviceCallback);

    /**
     * List storage SAS definitions for the given storage account. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SasDefinitionItem&gt; object
     */
    Observable<Page<SasDefinitionItem>> getSasDefinitionsAsync(final String vaultBaseUrl, final String storageAccountName, final Integer maxresults);

    /**
     * List storage SAS definitions for the given storage account. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SasDefinitionItem&gt; object
     */
    Observable<ServiceResponse<Page<SasDefinitionItem>>> getSasDefinitionsWithServiceResponseAsync(final String vaultBaseUrl, final String storageAccountName, final Integer maxresults);

    /**
     * Lists deleted SAS definitions for the specified vault and storage account.
     * The Get Deleted Sas Definitions operation returns the SAS definitions that have been deleted for a vault enabled for soft-delete. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedSasDefinitionItem&gt; object if successful.
     */
    PagedList<DeletedSasDefinitionItem> getDeletedSasDefinitions(final String vaultBaseUrl, final String storageAccountName);

    /**
     * Lists deleted SAS definitions for the specified vault and storage account.
     * The Get Deleted Sas Definitions operation returns the SAS definitions that have been deleted for a vault enabled for soft-delete. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedSasDefinitionItem>> getDeletedSasDefinitionsAsync(final String vaultBaseUrl, final String storageAccountName, final ListOperationCallback<DeletedSasDefinitionItem> serviceCallback);

    /**
     * Lists deleted SAS definitions for the specified vault and storage account.
     * The Get Deleted Sas Definitions operation returns the SAS definitions that have been deleted for a vault enabled for soft-delete. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedSasDefinitionItem&gt; object
     */
    Observable<Page<DeletedSasDefinitionItem>> getDeletedSasDefinitionsAsync(final String vaultBaseUrl, final String storageAccountName);

    /**
     * Lists deleted SAS definitions for the specified vault and storage account.
     * The Get Deleted Sas Definitions operation returns the SAS definitions that have been deleted for a vault enabled for soft-delete. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedSasDefinitionItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> getDeletedSasDefinitionsWithServiceResponseAsync(final String vaultBaseUrl, final String storageAccountName);
    /**
     * Lists deleted SAS definitions for the specified vault and storage account.
     * The Get Deleted Sas Definitions operation returns the SAS definitions that have been deleted for a vault enabled for soft-delete. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedSasDefinitionItem&gt; object if successful.
     */
    PagedList<DeletedSasDefinitionItem> getDeletedSasDefinitions(final String vaultBaseUrl, final String storageAccountName, final Integer maxresults);

    /**
     * Lists deleted SAS definitions for the specified vault and storage account.
     * The Get Deleted Sas Definitions operation returns the SAS definitions that have been deleted for a vault enabled for soft-delete. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedSasDefinitionItem>> getDeletedSasDefinitionsAsync(final String vaultBaseUrl, final String storageAccountName, final Integer maxresults, final ListOperationCallback<DeletedSasDefinitionItem> serviceCallback);

    /**
     * Lists deleted SAS definitions for the specified vault and storage account.
     * The Get Deleted Sas Definitions operation returns the SAS definitions that have been deleted for a vault enabled for soft-delete. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedSasDefinitionItem&gt; object
     */
    Observable<Page<DeletedSasDefinitionItem>> getDeletedSasDefinitionsAsync(final String vaultBaseUrl, final String storageAccountName, final Integer maxresults);

    /**
     * Lists deleted SAS definitions for the specified vault and storage account.
     * The Get Deleted Sas Definitions operation returns the SAS definitions that have been deleted for a vault enabled for soft-delete. This operation requires the storage/listsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to 25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedSasDefinitionItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> getDeletedSasDefinitionsWithServiceResponseAsync(final String vaultBaseUrl, final String storageAccountName, final Integer maxresults);

    /**
     * Gets the specified deleted sas definition.
     * The Get Deleted SAS Definition operation returns the specified deleted SAS definition along with its attributes. This operation requires the storage/getsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeletedSasDefinitionBundle object if successful.
     */
    DeletedSasDefinitionBundle getDeletedSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Gets the specified deleted sas definition.
     * The Get Deleted SAS Definition operation returns the specified deleted SAS definition along with its attributes. This operation requires the storage/getsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<DeletedSasDefinitionBundle> getDeletedSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, final ServiceCallback<DeletedSasDefinitionBundle> serviceCallback);

    /**
     * Gets the specified deleted sas definition.
     * The Get Deleted SAS Definition operation returns the specified deleted SAS definition along with its attributes. This operation requires the storage/getsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedSasDefinitionBundle object
     */
    Observable<DeletedSasDefinitionBundle> getDeletedSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Gets the specified deleted sas definition.
     * The Get Deleted SAS Definition operation returns the specified deleted SAS definition along with its attributes. This operation requires the storage/getsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedSasDefinitionBundle object
     */
    Observable<ServiceResponse<DeletedSasDefinitionBundle>> getDeletedSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Recovers the deleted SAS definition.
     * Recovers the deleted SAS definition for the specified storage account. This operation can only be performed on a soft-delete enabled vault. This operation requires the storage/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SasDefinitionBundle object if successful.
     */
    SasDefinitionBundle recoverDeletedSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Recovers the deleted SAS definition.
     * Recovers the deleted SAS definition for the specified storage account. This operation can only be performed on a soft-delete enabled vault. This operation requires the storage/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<SasDefinitionBundle> recoverDeletedSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, final ServiceCallback<SasDefinitionBundle> serviceCallback);

    /**
     * Recovers the deleted SAS definition.
     * Recovers the deleted SAS definition for the specified storage account. This operation can only be performed on a soft-delete enabled vault. This operation requires the storage/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SasDefinitionBundle object
     */
    Observable<SasDefinitionBundle> recoverDeletedSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Recovers the deleted SAS definition.
     * Recovers the deleted SAS definition for the specified storage account. This operation can only be performed on a soft-delete enabled vault. This operation requires the storage/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SasDefinitionBundle object
     */
    Observable<ServiceResponse<SasDefinitionBundle>> recoverDeletedSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Deletes a SAS definition from a specified storage account. This operation requires the storage/deletesas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeletedSasDefinitionBundle object if successful.
     */
    DeletedSasDefinitionBundle deleteSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Deletes a SAS definition from a specified storage account. This operation requires the storage/deletesas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<DeletedSasDefinitionBundle> deleteSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, final ServiceCallback<DeletedSasDefinitionBundle> serviceCallback);

    /**
     * Deletes a SAS definition from a specified storage account. This operation requires the storage/deletesas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedSasDefinitionBundle object
     */
    Observable<DeletedSasDefinitionBundle> deleteSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Deletes a SAS definition from a specified storage account. This operation requires the storage/deletesas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeletedSasDefinitionBundle object
     */
    Observable<ServiceResponse<DeletedSasDefinitionBundle>> deleteSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Gets information about a SAS definition for the specified storage account. This operation requires the storage/getsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SasDefinitionBundle object if successful.
     */
    SasDefinitionBundle getSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Gets information about a SAS definition for the specified storage account. This operation requires the storage/getsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<SasDefinitionBundle> getSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, final ServiceCallback<SasDefinitionBundle> serviceCallback);

    /**
     * Gets information about a SAS definition for the specified storage account. This operation requires the storage/getsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SasDefinitionBundle object
     */
    Observable<SasDefinitionBundle> getSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Gets information about a SAS definition for the specified storage account. This operation requires the storage/getsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SasDefinitionBundle object
     */
    Observable<ServiceResponse<SasDefinitionBundle>> getSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Creates or updates a new SAS definition for the specified storage account. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param templateUri The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
     * @param sasType The type of SAS token the SAS definition will create. Possible values include: 'account', 'service'
     * @param validityPeriod The validity period of SAS tokens created according to the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SasDefinitionBundle object if successful.
     */
    SasDefinitionBundle setSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod);

    /**
     * Creates or updates a new SAS definition for the specified storage account. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param templateUri The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
     * @param sasType The type of SAS token the SAS definition will create. Possible values include: 'account', 'service'
     * @param validityPeriod The validity period of SAS tokens created according to the SAS definition.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<SasDefinitionBundle> setSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, final ServiceCallback<SasDefinitionBundle> serviceCallback);

    /**
     * Creates or updates a new SAS definition for the specified storage account. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param templateUri The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
     * @param sasType The type of SAS token the SAS definition will create. Possible values include: 'account', 'service'
     * @param validityPeriod The validity period of SAS tokens created according to the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SasDefinitionBundle object
     */
    Observable<SasDefinitionBundle> setSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod);

    /**
     * Creates or updates a new SAS definition for the specified storage account. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param templateUri The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
     * @param sasType The type of SAS token the SAS definition will create. Possible values include: 'account', 'service'
     * @param validityPeriod The validity period of SAS tokens created according to the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SasDefinitionBundle object
     */
    Observable<ServiceResponse<SasDefinitionBundle>> setSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod);
    /**
     * Creates or updates a new SAS definition for the specified storage account. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param templateUri The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
     * @param sasType The type of SAS token the SAS definition will create. Possible values include: 'account', 'service'
     * @param validityPeriod The validity period of SAS tokens created according to the SAS definition.
     * @param sasDefinitionAttributes The attributes of the SAS definition.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SasDefinitionBundle object if successful.
     */
    SasDefinitionBundle setSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags);

    /**
     * Creates or updates a new SAS definition for the specified storage account. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param templateUri The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
     * @param sasType The type of SAS token the SAS definition will create. Possible values include: 'account', 'service'
     * @param validityPeriod The validity period of SAS tokens created according to the SAS definition.
     * @param sasDefinitionAttributes The attributes of the SAS definition.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<SasDefinitionBundle> setSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags, final ServiceCallback<SasDefinitionBundle> serviceCallback);

    /**
     * Creates or updates a new SAS definition for the specified storage account. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param templateUri The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
     * @param sasType The type of SAS token the SAS definition will create. Possible values include: 'account', 'service'
     * @param validityPeriod The validity period of SAS tokens created according to the SAS definition.
     * @param sasDefinitionAttributes The attributes of the SAS definition.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SasDefinitionBundle object
     */
    Observable<SasDefinitionBundle> setSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags);

    /**
     * Creates or updates a new SAS definition for the specified storage account. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param templateUri The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
     * @param sasType The type of SAS token the SAS definition will create. Possible values include: 'account', 'service'
     * @param validityPeriod The validity period of SAS tokens created according to the SAS definition.
     * @param sasDefinitionAttributes The attributes of the SAS definition.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SasDefinitionBundle object
     */
    Observable<ServiceResponse<SasDefinitionBundle>> setSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags);

    /**
     * Updates the specified attributes associated with the given SAS definition. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SasDefinitionBundle object if successful.
     */
    SasDefinitionBundle updateSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Updates the specified attributes associated with the given SAS definition. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<SasDefinitionBundle> updateSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, final ServiceCallback<SasDefinitionBundle> serviceCallback);

    /**
     * Updates the specified attributes associated with the given SAS definition. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SasDefinitionBundle object
     */
    Observable<SasDefinitionBundle> updateSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);

    /**
     * Updates the specified attributes associated with the given SAS definition. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SasDefinitionBundle object
     */
    Observable<ServiceResponse<SasDefinitionBundle>> updateSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName);
    /**
     * Updates the specified attributes associated with the given SAS definition. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param templateUri The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
     * @param sasType The type of SAS token the SAS definition will create. Possible values include: 'account', 'service'
     * @param validityPeriod The validity period of SAS tokens created according to the SAS definition.
     * @param sasDefinitionAttributes The attributes of the SAS definition.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SasDefinitionBundle object if successful.
     */
    SasDefinitionBundle updateSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags);

    /**
     * Updates the specified attributes associated with the given SAS definition. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param templateUri The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
     * @param sasType The type of SAS token the SAS definition will create. Possible values include: 'account', 'service'
     * @param validityPeriod The validity period of SAS tokens created according to the SAS definition.
     * @param sasDefinitionAttributes The attributes of the SAS definition.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<SasDefinitionBundle> updateSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags, final ServiceCallback<SasDefinitionBundle> serviceCallback);

    /**
     * Updates the specified attributes associated with the given SAS definition. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param templateUri The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
     * @param sasType The type of SAS token the SAS definition will create. Possible values include: 'account', 'service'
     * @param validityPeriod The validity period of SAS tokens created according to the SAS definition.
     * @param sasDefinitionAttributes The attributes of the SAS definition.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SasDefinitionBundle object
     */
    Observable<SasDefinitionBundle> updateSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags);

    /**
     * Updates the specified attributes associated with the given SAS definition. This operation requires the storage/setsas permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param storageAccountName The name of the storage account.
     * @param sasDefinitionName The name of the SAS definition.
     * @param templateUri The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template.
     * @param sasType The type of SAS token the SAS definition will create. Possible values include: 'account', 'service'
     * @param validityPeriod The validity period of SAS tokens created according to the SAS definition.
     * @param sasDefinitionAttributes The attributes of the SAS definition.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SasDefinitionBundle object
     */
    Observable<ServiceResponse<SasDefinitionBundle>> updateSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags);

    /**
     * Retrieves a list of individual key versions with the same key name.
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;KeyItem&gt; object if successful.
     */
    PagedList<KeyItem> getKeyVersionsNext(final String nextPageLink);

    /**
     * Retrieves a list of individual key versions with the same key name.
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<KeyItem>> getKeyVersionsNextAsync(final String nextPageLink, final ServiceFuture<List<KeyItem>> serviceFuture, final ListOperationCallback<KeyItem> serviceCallback);

    /**
     * Retrieves a list of individual key versions with the same key name.
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;KeyItem&gt; object
     */
    Observable<Page<KeyItem>> getKeyVersionsNextAsync(final String nextPageLink);

    /**
     * Retrieves a list of individual key versions with the same key name.
     * The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;KeyItem&gt; object
     */
    Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * List keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response. This operation requires the keys/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;KeyItem&gt; object if successful.
     */
    PagedList<KeyItem> getKeysNext(final String nextPageLink);

    /**
     * List keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response. This operation requires the keys/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<KeyItem>> getKeysNextAsync(final String nextPageLink, final ServiceFuture<List<KeyItem>> serviceFuture, final ListOperationCallback<KeyItem> serviceCallback);

    /**
     * List keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response. This operation requires the keys/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;KeyItem&gt; object
     */
    Observable<Page<KeyItem>> getKeysNextAsync(final String nextPageLink);

    /**
     * List keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored key. The LIST operation is applicable to all key types, however only the base key identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response. This operation requires the keys/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;KeyItem&gt; object
     */
    Observable<ServiceResponse<Page<KeyItem>>> getKeysNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Lists the deleted keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedKeyItem&gt; object if successful.
     */
    PagedList<DeletedKeyItem> getDeletedKeysNext(final String nextPageLink);

    /**
     * Lists the deleted keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedKeyItem>> getDeletedKeysNextAsync(final String nextPageLink, final ServiceFuture<List<DeletedKeyItem>> serviceFuture, final ListOperationCallback<DeletedKeyItem> serviceCallback);

    /**
     * Lists the deleted keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedKeyItem&gt; object
     */
    Observable<Page<DeletedKeyItem>> getDeletedKeysNextAsync(final String nextPageLink);

    /**
     * Lists the deleted keys in the specified vault.
     * Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedKeyItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedKeyItem>>> getDeletedKeysNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * List secrets in a specified key vault.
     * The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its attributes are provided in the response. Individual secret versions are not listed in the response. This operation requires the secrets/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SecretItem&gt; object if successful.
     */
    PagedList<SecretItem> getSecretsNext(final String nextPageLink);

    /**
     * List secrets in a specified key vault.
     * The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its attributes are provided in the response. Individual secret versions are not listed in the response. This operation requires the secrets/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<SecretItem>> getSecretsNextAsync(final String nextPageLink, final ServiceFuture<List<SecretItem>> serviceFuture, final ListOperationCallback<SecretItem> serviceCallback);

    /**
     * List secrets in a specified key vault.
     * The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its attributes are provided in the response. Individual secret versions are not listed in the response. This operation requires the secrets/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretItem&gt; object
     */
    Observable<Page<SecretItem>> getSecretsNextAsync(final String nextPageLink);

    /**
     * List secrets in a specified key vault.
     * The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its attributes are provided in the response. Individual secret versions are not listed in the response. This operation requires the secrets/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretItem&gt; object
     */
    Observable<ServiceResponse<Page<SecretItem>>> getSecretsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * List all versions of the specified secret.
     * The full secret identifier and attributes are provided in the response. No values are returned for the secrets. This operations requires the secrets/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SecretItem&gt; object if successful.
     */
    PagedList<SecretItem> getSecretVersionsNext(final String nextPageLink);

    /**
     * List all versions of the specified secret.
     * The full secret identifier and attributes are provided in the response. No values are returned for the secrets. This operations requires the secrets/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<SecretItem>> getSecretVersionsNextAsync(final String nextPageLink, final ServiceFuture<List<SecretItem>> serviceFuture, final ListOperationCallback<SecretItem> serviceCallback);

    /**
     * List all versions of the specified secret.
     * The full secret identifier and attributes are provided in the response. No values are returned for the secrets. This operations requires the secrets/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretItem&gt; object
     */
    Observable<Page<SecretItem>> getSecretVersionsNextAsync(final String nextPageLink);

    /**
     * List all versions of the specified secret.
     * The full secret identifier and attributes are provided in the response. No values are returned for the secrets. This operations requires the secrets/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretItem&gt; object
     */
    Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Lists deleted secrets for the specified vault.
     * The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for soft-delete. This operation requires the secrets/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedSecretItem&gt; object if successful.
     */
    PagedList<DeletedSecretItem> getDeletedSecretsNext(final String nextPageLink);

    /**
     * Lists deleted secrets for the specified vault.
     * The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for soft-delete. This operation requires the secrets/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedSecretItem>> getDeletedSecretsNextAsync(final String nextPageLink, final ServiceFuture<List<DeletedSecretItem>> serviceFuture, final ListOperationCallback<DeletedSecretItem> serviceCallback);

    /**
     * Lists deleted secrets for the specified vault.
     * The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for soft-delete. This operation requires the secrets/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedSecretItem&gt; object
     */
    Observable<Page<DeletedSecretItem>> getDeletedSecretsNextAsync(final String nextPageLink);

    /**
     * Lists deleted secrets for the specified vault.
     * The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for soft-delete. This operation requires the secrets/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedSecretItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedSecretItem>>> getDeletedSecretsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * List certificates in a specified key vault.
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CertificateItem&gt; object if successful.
     */
    PagedList<CertificateItem> getCertificatesNext(final String nextPageLink);

    /**
     * List certificates in a specified key vault.
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<CertificateItem>> getCertificatesNextAsync(final String nextPageLink, final ServiceFuture<List<CertificateItem>> serviceFuture, final ListOperationCallback<CertificateItem> serviceCallback);

    /**
     * List certificates in a specified key vault.
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateItem&gt; object
     */
    Observable<Page<CertificateItem>> getCertificatesNextAsync(final String nextPageLink);

    /**
     * List certificates in a specified key vault.
     * The GetCertificates operation returns the set of certificates resources in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateItem&gt; object
     */
    Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * List certificate issuers for a specified key vault.
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CertificateIssuerItem&gt; object if successful.
     */
    PagedList<CertificateIssuerItem> getCertificateIssuersNext(final String nextPageLink);

    /**
     * List certificate issuers for a specified key vault.
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<CertificateIssuerItem>> getCertificateIssuersNextAsync(final String nextPageLink, final ServiceFuture<List<CertificateIssuerItem>> serviceFuture, final ListOperationCallback<CertificateIssuerItem> serviceCallback);

    /**
     * List certificate issuers for a specified key vault.
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateIssuerItem&gt; object
     */
    Observable<Page<CertificateIssuerItem>> getCertificateIssuersNextAsync(final String nextPageLink);

    /**
     * List certificate issuers for a specified key vault.
     * The GetCertificateIssuers operation returns the set of certificate issuer resources in the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateIssuerItem&gt; object
     */
    Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * List the versions of a certificate.
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CertificateItem&gt; object if successful.
     */
    PagedList<CertificateItem> getCertificateVersionsNext(final String nextPageLink);

    /**
     * List the versions of a certificate.
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<CertificateItem>> getCertificateVersionsNextAsync(final String nextPageLink, final ServiceFuture<List<CertificateItem>> serviceFuture, final ListOperationCallback<CertificateItem> serviceCallback);

    /**
     * List the versions of a certificate.
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateItem&gt; object
     */
    Observable<Page<CertificateItem>> getCertificateVersionsNextAsync(final String nextPageLink);

    /**
     * List the versions of a certificate.
     * The GetCertificateVersions operation returns the versions of a certificate in the specified key vault. This operation requires the certificates/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateItem&gt; object
     */
    Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state and ready for recovery or purging. This operation includes deletion-specific information. This operation requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedCertificateItem&gt; object if successful.
     */
    PagedList<DeletedCertificateItem> getDeletedCertificatesNext(final String nextPageLink);

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state and ready for recovery or purging. This operation includes deletion-specific information. This operation requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedCertificateItem>> getDeletedCertificatesNextAsync(final String nextPageLink, final ServiceFuture<List<DeletedCertificateItem>> serviceFuture, final ListOperationCallback<DeletedCertificateItem> serviceCallback);

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state and ready for recovery or purging. This operation includes deletion-specific information. This operation requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedCertificateItem&gt; object
     */
    Observable<Page<DeletedCertificateItem>> getDeletedCertificatesNextAsync(final String nextPageLink);

    /**
     * Lists the deleted certificates in the specified vault currently available for recovery.
     * The GetDeletedCertificates operation retrieves the certificates in the current vault which are in a deleted state and ready for recovery or purging. This operation includes deletion-specific information. This operation requires the certificates/get/list permission. This operation can only be enabled on soft-delete enabled vaults.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedCertificateItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedCertificateItem>>> getDeletedCertificatesNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * List storage accounts managed by the specified key vault. This operation requires the storage/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;StorageAccountItem&gt; object if successful.
     */
    PagedList<StorageAccountItem> getStorageAccountsNext(final String nextPageLink);

    /**
     * List storage accounts managed by the specified key vault. This operation requires the storage/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<StorageAccountItem>> getStorageAccountsNextAsync(final String nextPageLink, final ServiceFuture<List<StorageAccountItem>> serviceFuture, final ListOperationCallback<StorageAccountItem> serviceCallback);

    /**
     * List storage accounts managed by the specified key vault. This operation requires the storage/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;StorageAccountItem&gt; object
     */
    Observable<Page<StorageAccountItem>> getStorageAccountsNextAsync(final String nextPageLink);

    /**
     * List storage accounts managed by the specified key vault. This operation requires the storage/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;StorageAccountItem&gt; object
     */
    Observable<ServiceResponse<Page<StorageAccountItem>>> getStorageAccountsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Lists deleted storage accounts for the specified vault.
     * The Get Deleted Storage Accounts operation returns the storage accounts that have been deleted for a vault enabled for soft-delete. This operation requires the storage/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedStorageAccountItem&gt; object if successful.
     */
    PagedList<DeletedStorageAccountItem> getDeletedStorageAccountsNext(final String nextPageLink);

    /**
     * Lists deleted storage accounts for the specified vault.
     * The Get Deleted Storage Accounts operation returns the storage accounts that have been deleted for a vault enabled for soft-delete. This operation requires the storage/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedStorageAccountItem>> getDeletedStorageAccountsNextAsync(final String nextPageLink, final ServiceFuture<List<DeletedStorageAccountItem>> serviceFuture, final ListOperationCallback<DeletedStorageAccountItem> serviceCallback);

    /**
     * Lists deleted storage accounts for the specified vault.
     * The Get Deleted Storage Accounts operation returns the storage accounts that have been deleted for a vault enabled for soft-delete. This operation requires the storage/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedStorageAccountItem&gt; object
     */
    Observable<Page<DeletedStorageAccountItem>> getDeletedStorageAccountsNextAsync(final String nextPageLink);

    /**
     * Lists deleted storage accounts for the specified vault.
     * The Get Deleted Storage Accounts operation returns the storage accounts that have been deleted for a vault enabled for soft-delete. This operation requires the storage/list permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedStorageAccountItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> getDeletedStorageAccountsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * List storage SAS definitions for the given storage account. This operation requires the storage/listsas permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SasDefinitionItem&gt; object if successful.
     */
    PagedList<SasDefinitionItem> getSasDefinitionsNext(final String nextPageLink);

    /**
     * List storage SAS definitions for the given storage account. This operation requires the storage/listsas permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<SasDefinitionItem>> getSasDefinitionsNextAsync(final String nextPageLink, final ServiceFuture<List<SasDefinitionItem>> serviceFuture, final ListOperationCallback<SasDefinitionItem> serviceCallback);

    /**
     * List storage SAS definitions for the given storage account. This operation requires the storage/listsas permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SasDefinitionItem&gt; object
     */
    Observable<Page<SasDefinitionItem>> getSasDefinitionsNextAsync(final String nextPageLink);

    /**
     * List storage SAS definitions for the given storage account. This operation requires the storage/listsas permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SasDefinitionItem&gt; object
     */
    Observable<ServiceResponse<Page<SasDefinitionItem>>> getSasDefinitionsNextWithServiceResponseAsync(final String nextPageLink);

    /**
     * Lists deleted SAS definitions for the specified vault and storage account.
     * The Get Deleted Sas Definitions operation returns the SAS definitions that have been deleted for a vault enabled for soft-delete. This operation requires the storage/listsas permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws KeyVaultErrorException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeletedSasDefinitionItem&gt; object if successful.
     */
    PagedList<DeletedSasDefinitionItem> getDeletedSasDefinitionsNext(final String nextPageLink);

    /**
     * Lists deleted SAS definitions for the specified vault and storage account.
     * The Get Deleted Sas Definitions operation returns the SAS definitions that have been deleted for a vault enabled for soft-delete. This operation requires the storage/listsas permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    ServiceFuture<List<DeletedSasDefinitionItem>> getDeletedSasDefinitionsNextAsync(final String nextPageLink, final ServiceFuture<List<DeletedSasDefinitionItem>> serviceFuture, final ListOperationCallback<DeletedSasDefinitionItem> serviceCallback);

    /**
     * Lists deleted SAS definitions for the specified vault and storage account.
     * The Get Deleted Sas Definitions operation returns the SAS definitions that have been deleted for a vault enabled for soft-delete. This operation requires the storage/listsas permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedSasDefinitionItem&gt; object
     */
    Observable<Page<DeletedSasDefinitionItem>> getDeletedSasDefinitionsNextAsync(final String nextPageLink);

    /**
     * Lists deleted SAS definitions for the specified vault and storage account.
     * The Get Deleted Sas Definitions operation returns the SAS definitions that have been deleted for a vault enabled for soft-delete. This operation requires the storage/listsas permission.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeletedSasDefinitionItem&gt; object
     */
    Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> getDeletedSasDefinitionsNextWithServiceResponseAsync(final String nextPageLink);

}
