/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault;

import com.microsoft.azure.keyvault.ObjectIdentifier;
import java.net.URI;
import java.net.URISyntaxException;

public final class CertificateOperationIdentifier
extends ObjectIdentifier {
    public static boolean isCertificateOperationIdentifier(String identifier) {
        URI baseUri;
        identifier = CertificateOperationIdentifier.verifyNonEmpty(identifier, "identifier");
        try {
            baseUri = new URI(identifier);
        }
        catch (URISyntaxException e) {
            return false;
        }
        String[] segments = baseUri.getPath().split("/");
        if (segments.length != 4) {
            return false;
        }
        if (!segments[1].equals("certificates")) {
            return false;
        }
        return segments[3].equals("pending");
    }

    public CertificateOperationIdentifier(String vault, String name, String version) {
        super(vault, "certificates", name, "pending");
    }

    public CertificateOperationIdentifier(String identifier) {
        super("certificates", identifier);
        if (!this.version().equals("pending")) {
            throw new IllegalArgumentException(String.format("Invalid CertificateOperationIdentifier: %s", identifier));
        }
    }
}

