/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions;

import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.core.IKeyResolver;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AggregateKeyResolver
implements IKeyResolver {
    private final ArrayList<IKeyResolver> _resolvers = new ArrayList();

    public void Add(IKeyResolver resolver) {
        this._resolvers.add(resolver);
    }

    public Future<IKey> resolveKeyAsync(String kid) {
        return new FutureKey(kid);
    }

    class FutureKey
    implements Future<IKey> {
        private final String _kid;
        private boolean _cancelled = false;
        private boolean _done = false;
        private IKey _result = null;

        FutureKey(String kid) {
            this._kid = kid;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this._cancelled = true;
            return this._cancelled;
        }

        @Override
        public boolean isCancelled() {
            return this._cancelled;
        }

        @Override
        public boolean isDone() {
            return this._done;
        }

        @Override
        public IKey get() throws InterruptedException, ExecutionException {
            if (this._cancelled) {
                throw new InterruptedException();
            }
            for (IKeyResolver resolver : AggregateKeyResolver.this._resolvers) {
                Future futureKey = resolver.resolveKeyAsync(this._kid);
                this._result = (IKey)futureKey.get();
                if (this._result == null) continue;
                break;
            }
            this._done = true;
            return this._result;
        }

        @Override
        public IKey get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this._cancelled) {
                throw new InterruptedException();
            }
            for (IKeyResolver resolver : AggregateKeyResolver.this._resolvers) {
                Future futureKey = resolver.resolveKeyAsync(this._kid);
                this._result = (IKey)futureKey.get(timeout, unit);
                if (this._result == null) continue;
                break;
            }
            this._done = true;
            return this._result;
        }
    }
}

