/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions;

import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.core.IKeyResolver;
import com.microsoft.azure.keyvault.extensions.FutureImmediate;
import com.microsoft.azure.keyvault.extensions.LRUCache;
import java.util.concurrent.Future;

public class CachingKeyResolver
implements IKeyResolver {
    private final LRUCache<String, IKey> _cache;
    private final IKeyResolver _inner;

    public CachingKeyResolver(int capacity, IKeyResolver inner) {
        this._cache = new LRUCache(capacity);
        this._inner = inner;
    }

    public Future<IKey> resolveKeyAsync(String kid) {
        IKey result = (IKey)this._cache.get(kid);
        if (result == null) {
            return this._inner.resolveKeyAsync(kid);
        }
        return new FutureImmediate<IKey>(result);
    }
}

