/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class FutureAdapter<S, T>
implements Future<T> {
    private final Future<S> _source;

    protected FutureAdapter(Future<S> source) {
        this._source = source;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this._source.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this._source.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this._source.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.translate(this._source.get());
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.translate(this._source.get(timeout, unit));
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    protected abstract T translate(S var1) throws IOException;
}

