/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions;

import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.extensions.FutureAdapter;
import com.microsoft.azure.keyvault.extensions.RsaKey;
import com.microsoft.azure.keyvault.extensions.Strings;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class KeyVaultKey
implements IKey {
    private final KeyVaultClient _client;
    private IKey _implementation;

    protected KeyVaultKey(KeyVaultClient client, KeyBundle keyBundle) {
        if (client == null) {
            throw new IllegalArgumentException("client");
        }
        if (keyBundle == null) {
            throw new IllegalArgumentException("keyBundle");
        }
        JsonWebKey key = keyBundle.getKey();
        if (key == null) {
            throw new IllegalArgumentException("keyBundle must contain a key");
        }
        if (key.getKty().equals("RSA")) {
            this._implementation = new RsaKey(keyBundle.getKey());
        } else if (key.getKty().equals("RSA-HSM")) {
            this._implementation = new RsaKey(keyBundle.getKey());
        }
        if (this._implementation == null) {
            throw new IllegalArgumentException(String.format("The key type %s is not supported", keyBundle.getKey().getKty()));
        }
        this._client = client;
    }

    public void close() throws IOException {
        if (this._implementation != null) {
            this._implementation.close();
        }
    }

    public String getDefaultEncryptionAlgorithm() {
        if (this._implementation == null) {
            return null;
        }
        return this._implementation.getDefaultEncryptionAlgorithm();
    }

    public String getDefaultKeyWrapAlgorithm() {
        if (this._implementation == null) {
            return null;
        }
        return this._implementation.getDefaultKeyWrapAlgorithm();
    }

    public String getDefaultSignatureAlgorithm() {
        if (this._implementation == null) {
            return null;
        }
        return this._implementation.getDefaultSignatureAlgorithm();
    }

    public String getKid() {
        if (this._implementation == null) {
            return null;
        }
        return this._implementation.getKid();
    }

    public Future<byte[]> decryptAsync(byte[] ciphertext, byte[] iv, byte[] authenticationData, byte[] authenticationTag, String algorithm) {
        if (this._implementation == null) {
            return null;
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            algorithm = this.getDefaultEncryptionAlgorithm();
        }
        return new FutureDecryptResult(this._client.decryptAsync(this._implementation.getKid(), algorithm, ciphertext));
    }

    public Future<Triple<byte[], byte[], String>> encryptAsync(byte[] plaintext, byte[] iv, byte[] authenticationData, String algorithm) throws NoSuchAlgorithmException {
        if (this._implementation == null) {
            return null;
        }
        return this._implementation.encryptAsync(plaintext, iv, authenticationData, algorithm);
    }

    public Future<Pair<byte[], String>> wrapKeyAsync(byte[] plaintext, String algorithm) throws NoSuchAlgorithmException {
        if (this._implementation == null) {
            return null;
        }
        return this._implementation.wrapKeyAsync(plaintext, algorithm);
    }

    public Future<byte[]> unwrapKeyAsync(byte[] ciphertext, String algorithm) {
        if (this._implementation == null) {
            return null;
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            algorithm = this.getDefaultKeyWrapAlgorithm();
        }
        return new FutureDecryptResult(this._client.unwrapKeyAsync(this._implementation.getKid(), algorithm, ciphertext));
    }

    public Future<Pair<byte[], String>> signAsync(byte[] digest, String algorithm) {
        if (this._implementation == null) {
            return null;
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            algorithm = this.getDefaultSignatureAlgorithm();
        }
        return new FutureSignResult(algorithm, this._client.signAsync(this._implementation.getKid(), algorithm, digest));
    }

    public Future<Boolean> verifyAsync(byte[] digest, byte[] signature, String algorithm) {
        if (this._implementation == null) {
            return null;
        }
        return this._implementation.verifyAsync(digest, signature, algorithm);
    }

    class FutureSignResult
    extends FutureAdapter<KeyOperationResult, Pair<byte[], String>> {
        private final String _algorithm;

        FutureSignResult(String algorithm, Future<KeyOperationResult> source) {
            super(source);
            this._algorithm = algorithm;
        }

        @Override
        protected Pair<byte[], String> translate(KeyOperationResult result) throws IOException {
            return Pair.of((Object)result.getResult(), (Object)this._algorithm);
        }
    }

    class FutureDecryptResult
    extends FutureAdapter<KeyOperationResult, byte[]> {
        FutureDecryptResult(Future<KeyOperationResult> source) {
            super(source);
        }

        @Override
        protected byte[] translate(KeyOperationResult result) throws IOException {
            return result.getResult();
        }
    }
}

